<%--
  -- Page:        stsLoadDataSource.jsp
  -- Controller:  oracle.sysman.db.adm.inst.StsLoadController.java
  --
  -- Description: 1st step of SQL Tuning Set load  wizard: Data Source
  --
  --  MODIFIED    (MM/DD/YY)t
  --     yfeng   12/06/06 - Add comments
  --     yfeng   10/24/06 - Support user workload
  --     yfeng   10/12/06 - Include jspf file instead of jsfp
  --     yfeng   07/10/06 - Support Time Picker 
  --     yfeng   05/25/06 - Use stsDataSourcesForLoadSts.jsfp instead 
  --     yfeng   05/23/06 - created
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/LOV.js"/>

<script language="javascript">
function launchTimePeriodPicker()
{
    if (document.stsLoad.awrSnapshotIntervalChoice.value == "S_CUSTOMIZE")
        submitForm('stsLoad', true, {'event':'changeDataSource'});
        alert(document.stsLoad.awrSnapshotIntervalChoice.value);
}

function launchTimePickerPage(url, winName) 
{
  timePickerWin = openWindow(window, url, winName, {width:1000, height:600}, true, 'dialog', '');
  timePickerWin.focus();
}

function popWindow()
{
  startLov('baseline', 'ListBaselines');
}
</script>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="dbMsg"
            class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sqlMsg"
            class="oracle.sysman.db.rsc.inst.SQLMsg"/>
<uix:bundle name="AAMsgs"
            class="oracle.sysman.db.rsc.sqla.SqlAccessMsg"/>
<uix:document>

  <%-- HTML Page Title --%>
  <%@ include file="/oemTitle.jspf" %>

  <%-- Include body tag so page is slightly indented from edge of window --%>
  <uix:body>

    <%-- HTML Form --%>
    <db:form name="stsLoad" 
             method="post" 
             destination="/console/database/instance/stsLoad" 
             copyParams="target,type,backURL" >
      <uix:formValue name="pageName" 
                     value="/database/instance/sqlset/stsLoadDataSource"/>
      <uix:formValue name="dbid" 
                     valueBinding="dbid@stsLoadBean@servletRequest"/>                     
      <uix:formValue name="schemaName" 
                     valueBinding="loggedInUserName@stsCreateBean@servletRequest" />

<uix:pageLayout titleBinding="LOAD_STS_DATA_SOURCE_TITLE@sqlMsg">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/globalPopup.jspf" %>

  <%-- Display wizard train and Logged in As --%>
  <uix:location>
    <uix:tableLayout width="100%">
      <uix:rowLayout width="100%">
        <uix:cellFormat wrappingDisabled="true">
          <uix:train selectedIndex="0">
            <db:link textBinding="DATA_SOURCE@sqlMsg"
                     copyParams="target,type,backURL" />
            <db:link textBinding="FILTER_OPTIONS@sqlMsg"
                     copyParams="target,type,backURL" />
            <db:link textBinding="SCHEDULE@sqlMsg"
                     copyParams="target,type,backURL" />
            <db:link textBinding="REVIEW@sqlMsg"
                     copyParams="target,type,backURL" />
          </uix:train>
        </uix:cellFormat>
        <uix:cellFormat wrappingDisabled="true" hAlign="right"> 
          <uix:messageStyledText styleClass="OraTipText" 
                                 textBinding="loggedInAsLabel@servletRequest"
                                 renderedBinding="loggedInUserNameAvailable@servletRequest"/>
        </uix:cellFormat>
      </uix:rowLayout>
    </uix:tableLayout>
  </uix:location>

  <uix:pageStatus>
    <uix:rowLayout width="100%">
      <uix:stackLayout> 
        <uix:labeledFieldLayout labelWidth="10%">
          <uix:messagePrompt
               promptBinding="DATABASE@dbMsg"/>
          <uix:styledText styleClass="OraDataText"
                          textBinding="target@servletRequest"/>
        </uix:labeledFieldLayout>
      </uix:stackLayout>
    </uix:rowLayout>
  </uix:pageStatus>
  
  <%-- Follow page/wizard context information with a separator --%>
  <uix:separator/>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <uix:header textBinding="GENERAL@sqlMsg">
    <uix:labeledFieldLayout columns="2">

      <uix:messagePrompt promptBinding="SQL_TUNING_SET_NAME@sqlMsg" />
      <uix:styledText styleClass="OraDataText" 
                      textBinding="stsName@stsLoadBean@servletRequest"/>

      <uix:messagePrompt promptBinding="OWNER@sqlMsg" />
      <uix:styledText styleClass="OraDataText" 
                      textBinding="owner@stsLoadBean@servletRequest"/>
                      
      <uix:messagePrompt promptBinding="OPT_DESCRIPTION@sqlMsg"/>
      <uix:styledText styleClass="OraDataText" 
                      textBinding="description@stsLoadBean@servletRequest"/>
      
      <uix:messagePrompt promptBinding="NUMBER_OF_STATEMENTS@sqlMsg" />
      <uix:styledText styleClass="OraDataText" 
                      textBinding="sqlCount@stsLoadBean@servletRequest" />
    </uix:labeledFieldLayout>
  </uix:header>
  
  <%-- Two type os load methods --%>
  <uix:header textBinding="LOAD_METHODS@sqlMsg"
              renderedBinding="twoLoadMethods@stsLoadBean@servletRequest">
    <%@ include file="stsDataSourcesForLoadSts.jspf" %>
  </uix:header>

  <%-- Automatic capture only --%>
  <uix:header textBinding="LOAD_METHODS@sqlMsg"
              renderedBinding="automaticCaptureOnly@stsLoadBean@servletRequest">
    <uix:stackLayout>
      <uix:rowLayout>
        <uix:styledText textBinding="INCREMENTAL_CAPTURE_ONLY_DESC@sqlMsg"  
                        styleClass="OraInstructionText"/>
      </uix:rowLayout>
      <uix:spacer height="5"/>
      <uix:tableLayout>
      <uix:contents>
      <uix:rowLayout>
      <uix:cellFormat hAlign="right">
        <uix:spacer height ="0" width="38"/> 
        <uix:messagePrompt labeledNodeId="timeLimitValue" 
                           promptBinding="TIME_LIMIT@sqlMsg" />
        </uix:cellFormat>  
        <uix:cellFormat hAlign="right">
        <uix:spacer width="5" />
        <uix:textInput id="timeLimitValue" name="timeLimitValue"
                       columns="10"
                       textBinding="timeLimitValue@searchSource@servletRequest" />
        </uix:cellFormat>  
        <uix:cellFormat hAlign="right">
        <uix:spacer width="5" />
        <uix:choice id="timeLimitUnit" name="timeLimitUnit"
                    selectedValueBinding="timeLimitUnit@searchSource@servletRequest"                                
                    shortDescBinding="TIME_LIMIT_DESC@sqlMsg">
          <uix:contents childDataBinding="timeUnitList@searchSource@servletRequest">
            <uix:option textBinding="stext"
                        valueBinding="sval"/>
          </uix:contents>
        </uix:choice> 
        </uix:cellFormat>  
      </uix:rowLayout>

      <uix:rowLayout>
        <uix:spacer height ="4"/>
      </uix:rowLayout>
      
      <uix:rowLayout>
        <uix:cellFormat hAlign="right">
        <uix:spacer height ="0" width="38"/> 
        <uix:messagePrompt labeledNodeId="collectionFrequency" 
                            promptBinding="COLLECTION_FREQUENCY@sqlMsg" />
        </uix:cellFormat> 
        
        <uix:cellFormat hAlign="right">
        <uix:spacer width="5" />
        <uix:textInput id="collectionFrequency" 
                       name="collectionFrequency"
                       columns="10"
                       textBinding="collectionFrequency@searchSource@servletRequest" />
        </uix:cellFormat>  
        
        <uix:cellFormat hAlign="right">

        <uix:choice id="collFreqTimeUnit" 
                    name="collFreqTimeUnit"
                    selectedValueBinding="collFreqTimeUnit@searchSource@servletRequest"                                
                    shortDescBinding="COLLECTION_FREQUENCY_DESC@sqlMsg">
          <uix:contents childDataBinding="timeUnitList@searchSource@servletRequest">
            <uix:option textBinding="stext"
                        valueBinding="sval"/>
          </uix:contents>
        </uix:choice>                 
        </uix:cellFormat>  
        
      </uix:rowLayout>  
      
      </uix:contents>
      </uix:tableLayout>
    </uix:stackLayout>
  </uix:header>


  <uix:header textBinding="LOAD_STS_LOAD_OPTIONS@sqlMsg">
    <uix:tableLayout width="100%" cellSpacing="2">
      <uix:rowLayout>
        <uix:checkBox name="addNewSql" 
                      textBinding="LOAD_STS_ADD_NEW_SQL@sqlMsg"  
                      checkedBinding="addNewSql@searchSource@servletRequest"/>
      </uix:rowLayout>
      <uix:rowLayout>
        <uix:checkBox name="updateExistingSql" 
                      textBinding="LOAD_STS_UPDATE_EXIST_SQL@sqlMsg"  
                      checkedBinding="updateExistingSql@searchSource@servletRequest"/>
      </uix:rowLayout>
    </uix:tableLayout>
  </uix:header>
  
  <uix:pageButtons>  
    <uix:pageButtonBar>
      <uix:submitButton textBinding="FINISH@dbMsg"
                        shortDescBinding="FINISH@dbMsg"
                        name = "event"
                        unvalidated="true"
                        value = "finish" />
      <uix:submitButton textBinding="CANCEL@dbMsg"
                        shortDescBinding="CANCEL@dbMsg"
                        name = "event"
                        unvalidated="true"
                        value = "cancel" />
      <uix:navigationBar maxValue="4" minValue="1" name="step" value="1" 
                         destination="/console/database/instance/stsLoad" 
                         formSubmitted="true"
                         formName="stsLoad"/>
    </uix:pageButtonBar>
  </uix:pageButtons>
</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>
</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
