<%--
  -- Page:        stsLoadReview.jsp
  -- Controller:  oracle.sysman.db.adm.inst.StsLoadController.java
  --
  -- Description: 5th step of SQL Tuning Set creation wizard: Review
  --
  --  MODIFIED    (MM/DD/YY)t
  --     yfeng   07/10/06 - Fix bug to show custimized time 
  --     yfeng   07/09/06 - Change event from submit to submitJob 
  --     yfeng   05/25/06 - Fix the title 
  --     yfeng   05/23/06 - created
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="dbMsg"
            class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sqlMsg"
            class="oracle.sysman.db.rsc.inst.SQLMsg"/>
<uix:document>

  <%-- HTML Page Title --%>
  <%@ include file="/oemTitle.jspf" %>

  <%-- Include body tag so page is slightly indented from edge of window --%>
  <uix:body>

    <%-- HTML Form --%>
    <db:form name="stsLoad" 
             method="post" 
             destination="/console/database/instance/stsLoad" 
             copyParams="target,type,backURL" >
      <uix:formValue name="pageName" 
                     value="/database/instance/sqlset/stsLoadSchedule"/>                   


<uix:pageLayout titleBinding="LOAD_STS_REVIEW_TITLE@sqlMsg">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/globalPopup.jspf" %>

  <%-- Display wizard train and Logged in As --%>
  <uix:location>
    <uix:tableLayout width="100%">
      <uix:rowLayout width="100%">
        <uix:cellFormat wrappingDisabled="true">
          <uix:train selectedIndex="4">
            <db:link textBinding="OPTIONS@sqlMsg"
                     copyParams="target,type,backURL" />
            <db:link textBinding="LOAD_METHODS@sqlMsg"
                     copyParams="target,type,backURL" />
            <db:link textBinding="FILTER_OPTIONS@sqlMsg"
                     copyParams="target,type,backURL" />
            <db:link textBinding="SCHEDULE@sqlMsg"
                     copyParams="target,type,backURL" />
            <db:link textBinding="REVIEW@sqlMsg"
                     copyParams="target,type,backURL" />
          </uix:train>
        </uix:cellFormat>
        <uix:cellFormat wrappingDisabled="true" hAlign="right"> 
          <uix:messageStyledText styleClass="OraTipText" 
                                 textBinding="loggedInAsLabel@servletRequest"
                                 renderedBinding="loggedInUserNameAvailable@servletRequest"/>
        </uix:cellFormat>
      </uix:rowLayout>
    </uix:tableLayout>
  </uix:location>

  <uix:pageStatus>
    <uix:rowLayout width="100%">
      <uix:stackLayout> 
        <uix:labeledFieldLayout labelWidth="10%">
          <uix:messagePrompt
               promptBinding="DATABASE@dbMsg"/>
          <uix:styledText styleClass="OraDataText"
                          textBinding="target@servletRequest"/>
        </uix:labeledFieldLayout>
      </uix:stackLayout>
    </uix:rowLayout>
  </uix:pageStatus>
  
  <%-- Follow page/wizard context information with a separator --%>
  <uix:separator/>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

    <uix:stackLayout>
      <uix:flowLayout>
        <uix:rowLayout>
          <uix:spacer width="5"/>
          <uix:styledText textBinding="STS_CREATE_REVIEW_DESC@sqlMsg"  
                          styleClass="OraInstructionText"/>
        </uix:rowLayout>
        <uix:spacer height="5"/>
      </uix:flowLayout>
    </uix:stackLayout>   

    <uix:labeledFieldLayout columns="1">
      <%-- General information --%>
      <uix:messagePrompt promptBinding="STS_NAME@sqlMsg" />
      <uix:styledText styleClass="OraDataText" 
                      textBinding="stsName@stsLoadBean@servletRequest" />
                      
      <uix:messagePrompt promptBinding="OWNER@dbMsg" />
      <uix:styledText styleClass="OraDataText" 
                      textBinding="owner@stsLoadBean@servletRequest" />
      <uix:messagePrompt promptBinding="DESCRIPTION@dbMsg" />
      <uix:styledText styleClass="OraDataText" 
                      textBinding="description@stsLoadBean@servletRequest" />   

      <%-- Data source information --%>
      <uix:messagePrompt promptBinding="LOAD_METHODS@sqlMsg" /> 
      <uix:styledText styleClass="OraDataText" 
                      textBinding="loadMethodDesc@searchSource@servletRequest"/>      
      
      <uix:messagePrompt promptBinding="SQL_DATA_SOURCE@sqlMsg" 
                         renderedBinding="captureOnce@searchSource@servletRequest" />
      <uix:styledText styleClass="OraDataText" 
                      textBinding="dataSourceDesc@searchSource@servletRequest"
                      renderedBinding="captureOnce@searchSource@servletRequest" />

          <%-- Snapshot information --%>
      <uix:messagePrompt promptBinding="AWR_SNAPSHOTS@sqlMsg"
                         renderedBinding="searchAWRSnapshots@searchSource@servletRequest" />
      <uix:styledText styleClass="OraDataText" 
                      textBinding="AWRTimePeriodOption@searchSource@servletRequest"
                      renderedBinding="searchAWRSnapshots@searchSource@servletRequest" />

      <uix:messagePrompt promptBinding="INTERVAL_STARTING_TIME@sqlMsg"
                         renderedBinding="customized@searchSource@servletRequest" />
      <uix:styledText styleClass="OraDataText" 
                      textBinding="AWRStartTimeString@searchSource@servletRequest"
                      renderedBinding="customized@searchSource@servletRequest" />
                      
      <uix:messagePrompt promptBinding="INTERVAL_ENDING_TIME@sqlMsg"
                         renderedBinding="customized@searchSource@servletRequest" />
      <uix:styledText styleClass="OraDataText" 
                      textBinding="AWREndTimeString@searchSource@servletRequest"
                      renderedBinding="customized@searchSource@servletRequest" />
      
          <%-- Baseline information --%>    
      <uix:messagePrompt promptBinding="SS_BASELINE_NAME@sqlMsg"
                         renderedBinding="searchAWRBaseline@searchSource@servletRequest" />
      <uix:styledText styleClass="OraDataText" 
                      textBinding="awrBaseline@searchSource@servletRequest"
                      renderedBinding="searchAWRBaseline@searchSource@servletRequest" />
           
         <%-- Incremental capture (time limit and frequency) --%>  
      <uix:messagePrompt promptBinding="TIME_LIMIT@sqlMsg"
                         renderedBinding="incrementalCapture@searchSource@servletRequest" />
      <uix:styledText styleClass="OraDataText" 
                      textBinding="timeLimitDisplay@searchSource@servletRequest"
                      renderedBinding="incrementalCapture@searchSource@servletRequest" />

      <uix:messagePrompt promptBinding="COLLECTION_FREQUENCY@sqlMsg"
                         renderedBinding="incrementalCapture@searchSource@servletRequest" />
      <uix:styledText styleClass="OraDataText" 
                      textBinding="collectionFrequencyDisplay@searchSource@servletRequest"
                      renderedBinding="incrementalCapture@searchSource@servletRequest" />
          
          <%-- Load options --%>
      <uix:messagePrompt promptBinding="LOAD_STS_ADD_NEW_SQL@sqlMsg" />
      <uix:styledText styleClass="OraDataText" 
                      textBinding="addNewSqlDesc@searchSource@servletRequest" />
   
      <uix:messagePrompt promptBinding="LOAD_STS_UPDATE_EXIST_SQL@sqlMsg" />
      <uix:styledText styleClass="OraDataText" 
                      textBinding="updateExistingSqlDesc@searchSource@servletRequest" />
                      
      <%-- Filter Option information --%>
      <uix:messagePrompt promptBinding="TOP_N@sqlMsg"
                         renderedBinding="captureOnce@searchSource@servletRequest" />
      <uix:styledText styleClass="OraDataText" 
                      textBinding="topN@filterCondition@servletRequest"
                      renderedBinding="captureOnce@searchSource@servletRequest" />
                      
      <uix:messagePrompt promptBinding="SORTED_BY@sqlMsg" 
                         renderedBinding="showSortedBy@stsLoadBean@servletRequest" /> 
      <uix:styledText styleClass="OraDataText" 
                      textBinding="selectedSortedBy@filterCondition@servletRequest"
                      renderedBinding="showSortedBy@stsLoadBean@servletRequest" />
              <%-- Filter condition --%>
      <uix:messagePrompt promptBinding="FILTER_CONDITIONS@sqlMsg" 
                         renderedBinding="isFilterConditionAvailable@filterCondition@servletRequest" />
      <uix:styledText styleClass="OraDataText" 
                      textBinding="filterConditionExpr@filterCondition@servletRequest" 
                      renderedBinding="isFilterConditionAvailable@filterCondition@servletRequest" />
                      
      <%-- Schedule information --%>
      <uix:messagePrompt promptBinding="JOB_NAME@dbMsg" /> 
      <uix:styledText styleClass="OraDataText" 
                      textBinding="jobName@scheduleBean@servletRequest"/>
 
      <uix:messagePrompt promptBinding="DESCRIPTION@dbMsg"
                         renderedBinding="isJobDescSet@scheduleBean@servletRequest"/>
      <uix:styledText styleClass="OraDataText" 
                      textBinding="jobDesc@scheduleBean@servletRequest" 
                      renderedBinding="isJobDescSet@scheduleBean@servletRequest"/>

      <uix:messagePrompt promptBinding="SCHEDULE_START_TIME@sqlMsg" /> 
      <uix:styledText styleClass="OraDataText" 
                      textBinding="startTimeOnDisplay@scheduleBean@servletRequest"/>
                      
    </uix:labeledFieldLayout>
    
    <uix:hideShow 
                  formSubmitted="true" 
                  id="hideShow"
                  disclosedTextBinding="HIDE_SQL@sqlMsg"
                  disclosedBinding="isShowSql@stsLoadBean@servletRequest"
                  undisclosedTextBinding="SHOW_SQL@sqlMsg">
      <uix:contents>
        <uix:stackLayout>
          <uix:flowLayout>
            <uix:rowLayout>
              <uix:spacer width="18"/>
              <db:sqlDisplay  sqlListBinding="sqlList@stsLoadBean@servletRequest"/>
            </uix:rowLayout>
            <uix:spacer height="5"/>
          </uix:flowLayout>
        </uix:stackLayout>   
      </uix:contents>
    </uix:hideShow>
    
  <uix:pageButtons>  
    <uix:pageButtonBar>
      <uix:submitButton textBinding="CANCEL@dbMsg"
                        shortDescBinding="CANCEL@dbMsg"
                        name = "event"
                        unvalidated="true"
                        value = "cancel" />
      <uix:navigationBar maxValue="4" minValue="1" name="step" value="4" 
                         destination="/console/database/instance/stsLoad" 
                         formSubmitted="true"
                         formName="stsLoad"/>
      <uix:submitButton textBinding="SUBMIT@sqlMsg"
                        shortDescBinding="SUBMIT@sqlMsg"
                        name="event"
                        value="submitJob"/>
    </uix:pageButtonBar>
  </uix:pageButtons>
</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>
</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
