<%--
  -- Page:        viewsts.jsp
  -- Controller:  oracle.sysman.db.adm.inst.StsDetailsController.java
  --
  -- Description:  STS Details page
  --
  --  MODIFIED    (MM/DD/YY)
  --     ezeng   06/06/07 - 
  --     yfeng   04/16/07 - Fix bug 5985420 - remove onLoad event from the body
  --                        tag
  --     yfeng   04/09/07 - Fix bug 5975398 - Use Message bundle for SQL
  --                        Worksheet button
  --     yma     02/14/07 - bug 5755996 
  --     yfeng   11/29/06 - Add vertical spaces between buttons and the table 
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder 
                      id="renderingContext"/>

<uix:bundle name="sqlMsg"
            class="oracle.sysman.db.rsc.inst.SQLMsg"/>
<uix:bundle name="dbMsg"
            class="oracle.sysman.db.rsc.inst.DBMsg"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo2" method="POST" 
             destination="/console/database/instance/stsDetails"
             copyParams="target,type,stsId,stsName,stsOwner,stsDescription,stsCreated,stsLastModified">
      
    <uix:pageLayout titleBinding="header@sqlsetBean@servletRequest">
    <%@ include file="/database/global.jspf" %>
    <%@ include file="/sdk/page/pageMsgBox.jspf" %>
    
    
    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="confirmation"
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
          

      <uix:labeledFieldLayout fieldWidth="25%" labelWidth="25%" columns="2" width="100%">
          <uix:messagePrompt promptBinding="SCHEMA@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="owner@sqlsetBean@servletRequest" />
          <uix:messagePrompt promptBinding="DESCRIPTION@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="description@sqlsetBean@servletRequest" />
          <uix:messagePrompt promptBinding="CREATED@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="formattedCreatedDate@sqlsetBean@servletRequest" />
          <uix:messagePrompt promptBinding="LAST_MODIFIED@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="formattedLastModifiedDate@sqlsetBean@servletRequest" />            

        <uix:messagePrompt promptBinding="NUMBER_OF_STATEMENTS@sqlMsg" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="sqlCount@sqlsetBean@servletRequest" />
        <uix:messagePrompt promptBinding="TOTAL_DB_TIME@sqlMsg" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="dbTimeForDisplay@sqlsetBean@servletRequest" />   
          
     </uix:labeledFieldLayout>

    <uix:spacer height="10" />

    <uix:header textBinding="SQL_STATEMENTS@DBMsgBundle@servletRequest" >
    
      <uix:rowLayout width="100%">
        <uix:cellFormat hAlign="right" vAlign="top" width="100%">
          <uix:pageButtonBar>
            <uix:submitButton textBinding="RUN_SQL_ADVISOR@dbMsg"
                              name="event" 
                              value="runTuningAdvisor" />
            <uix:submitButton textBinding="SEARCH_SQL_IN_STS@sqlMsg"
                              name="event" 
                              value="searchSqlInSts" />  
            <uix:submitButton textBinding="ADD_MORE_SQL@sqlMsg"
                              name="event" 
                              value="loadSts" />
          </uix:pageButtonBar>
        </uix:cellFormat>
      </uix:rowLayout>
      
      <uix:rowLayout>
        <uix:spacer height="2" />
      </uix:rowLayout>
      
       <uix:tableLayout width="100%" >
          <uix:rowLayout vAlign="top">

            <oem:table name="STSContentUIDataSource"
                       id="stsContentTable"
                       alternateTextBinding="NO_STATEMENTS_ALT@DBMsgBundle@servletRequest"
                       partialRenderMode="self"
                       width="100%"
                       dataSourceProp="STSContentUIDataSource"
                       beanKey="sqlsetBean"
                       formSubmitted="true"
                       summaryBinding="SQL_STATEMENTS@DBMsgBundle@servletRequest"
                       blockSize="25">
              <uix:tableSelection>
                <uix:multipleSelection
                  selectedBinding="selected"
                  shortDescBinding="SELECT_SQL@sqlMsg"
                  selectionBinding="selection@STSContentUIDataSource@sqlsetBean@servletRequest"
                  >
<%--
                  <uix:submitButton
                    textBinding="SQL_WORKSHEET@sqlMsg"
                    name="event"
                    value="sqlWorksheet"
                  />
--%>
                  <uix:submitButton
                    textBinding="DELETE@dbMsg"
                    name="event"
                    value="delete"
                  />
                 </uix:multipleSelection>
              </uix:tableSelection>
            </oem:table>


          </uix:rowLayout>
        </uix:tableLayout>
      </uix:header>

    </uix:pageLayout>
    </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

