<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsg"
	    class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sqlMsg"
	    class="oracle.sysman.db.rsc.inst.SQLMsg"/>

  <oem:setURLEncoder id="renderingContext"/> 

  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>  
          <db:form name="foo" destination="/console/database/instance/sqltune"
                   copyParams="target,type,dbPageNum,advisoryCentralURL">
          <uix:pageLayout>
	  <%@ include file="/database/global.jspf" %>

<uix:header textBinding="SQL_TUNING_ADVISOR_LINKS_PG@sqlMsg">
<uix:styledText styleClass="OraInstructionText" 
                textBinding="SQL_TUNING_ADVISOR_LINKS_DESC@sqlMsg" />
<uix:tableLayout width="100%" cellSpacing="2">
<uix:rowLayout>
    <db:link textBinding="ACTIVITY_DETAILS@dbMsg"
    destination="/console/database/instance/waitDetails?event=doLoad&waitClass=Overview" copyParams="target,type,dbPageNum"/>
</uix:rowLayout>
<uix:rowLayout>
    <db:link textBinding="PERIOD_SQL@dbMsg"
    destination="/console/database/instance/topSqls?event=doLoad&refreshChoice=1" copyParams="target,type,dbPageNum"/>
</uix:rowLayout>
<uix:rowLayout>
    <db:link textBinding="SQL_TUNING_SETS@dbMsg" 
    destination="/console/database/instance/sqlSet?event=doLoad" copyParams="target,type,dbPageNum"/>
</uix:rowLayout>
<uix:rowLayout>
    <db:link textBinding="SNAPSHOTS@dbMsg"
    destination="/console/database/instance/swrfSnapshots?event=doLoad" copyParams="target,type,dbPageNum"/>
</uix:rowLayout>
<uix:rowLayout>
    <db:link textBinding="BASELINES@dbMsg" 
        destination="/console/database/instance/swrfBaselines?event=doLoad" copyParams="target,type,dbPageNum"/>
</uix:rowLayout>
</uix:tableLayout>
</uix:header>
        <%-- uix:pageButtons>
          <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@dbMsg"
		   name="event" value="cancelLinksPage"/>
          </uix:pageButtonBar>
        </uix:pageButtons --%>
</uix:pageLayout>
</db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
