<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsg"
	    class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sqlMsg"
	    class="oracle.sysman.db.rsc.inst.SQLMsg"/>
<uix:bundle name="autoSqlMsg"
	    class="oracle.sysman.db.rsc.inst.AutoSqlTuneMsg"/>
<uix:bundle name="dbObjectMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>

  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
  <%@ include file="/oemTitle.jspf" %>
  <uix:body>
  <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>   
          <oem:messageBox messageType="error"
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <oem:messageBox messageType="info"
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
        <db:form name="tsForm"  
                  destination="/console/database/instance/sqltune"
                 copyParams="target,type,taskName,taskUser,task_id,objectId,execID,advisoryCentralURL,dbPageNum,planType">
          <uix:header textBinding="RST_COL_ALTERNATIVE@sqlMsg" > 
            <uix:stackLayout>
                <uix:styledText styleClass="OraPromptText" textBinding="ALTERNATIVE_PLAN_PAGE_HEADER@sqlMsg"/>
        <uix:table width="80%"
               name="planListTable" id="planListTable"
                         tableDataBinding="planListTable@servletRequest"
                         alternateTextBinding = "NO_STAT_FINDING_SUMMARY@AutoSqlTuneBundle"
                         formSubmitted="true"> 
                   <uix:tableFormat tableBanding="rowBanding"/>
                  
                      <uix:column>
                        <uix:columnHeader>
                            <uix:styledText textBinding="SS_PLAN_HASH_VALUE@sqlMsg"/> 
                        </uix:columnHeader>
                        <uix:contents>
                            <uix:styledText styleClass="OraText" textBinding="planhash"/>
                            <uix:formValue name="planHashValue" valueBinding="planhash"/>
                        </uix:contents>
                      </uix:column>
                  
                      <uix:column>
                        <uix:columnHeader>
                            <uix:styledText textBinding="LAST_SEEN@sqlMsg"/> 
                        </uix:columnHeader>
                        <uix:contents>
                            <uix:styledText styleClass="OraText" textBinding="lastSeen"/>
                        </uix:contents>
                      </uix:column>
                  
                      <uix:column>
                        <uix:columnHeader>
                            <uix:styledText textBinding="PROCESSING_ELAPSED_TIME@sqlMsg"/> 
                        </uix:columnHeader>
                        <uix:contents>
                            <uix:styledText styleClass="OraText" 
                                            textBinding="elapsedTime"/>
                        </uix:contents>
                      </uix:column>
                  
                      <uix:column>
                        <uix:columnHeader>
                            <uix:styledText textBinding="ORIGIN@sqlMsg"/> 
                        </uix:columnHeader>
                        <uix:contents>
                            <uix:styledText styleClass="OraText" textBinding="origin"/>
                        </uix:contents>
                      </uix:column>
                  
                      <uix:column>
                        <uix:columnHeader>
                            <uix:styledText textBinding="NOTE@sqlMsg"/> 
                        </uix:columnHeader>
                        <uix:contents>
                            <uix:styledText styleClass="OraText" textBinding="note"/>
                        </uix:contents>
                      </uix:column>
                   <uix:tableSelection>
                   <uix:singleSelection disabledBinding="isDisabled"
                                        selectedIndexBinding="planListSelected@servletRequest" 
                                        shortDescBinding="RECOMMENDATIONS@AutoSqlTuneBundle">
                      <uix:submitButton textBinding="CREATE_PLN_BSLN@sqlMsg" 
                                        name="event" value="createPlanBaseline" />
                   </uix:singleSelection>
                   </uix:tableSelection>
                 </uix:table>   
            </uix:stackLayout>
        </uix:header>
        </db:form>
      <uix:header textBinding="PLAN_DETAILS@sqlMsg" > 
      <uix:contents childDataBinding="topFrameText@servletRequest">
      <uix:header textBinding="planHeader">
      <uix:stackLayout>
      <uix:tableLayout width="70%">
      <uix:rowLayout vAlign="top">
      <uix:cellFormat>

        <uix:tableLayout width="100%">
        <uix:rowLayout>
        <uix:cellFormat>
        <uix:labeledFieldLayout labelWidth="50%" fieldWidth="50%">
            <uix:styledText styleClass="OraPromptText" textBinding="ES_DISK_READS@sqlMsg"/>
            <uix:styledText styleClass="OraDataText" textBinding="disk_reads"/>
        </uix:labeledFieldLayout>
        </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout>
        <uix:cellFormat>
        <uix:labeledFieldLayout labelWidth="50%" fieldWidth="50%">
            <uix:styledText styleClass="OraPromptText" textBinding="ES_BUFFER_GETS@sqlMsg"/>
            <uix:styledText styleClass="OraDataText" textBinding="buffer_gets"/>
        </uix:labeledFieldLayout>
        </uix:cellFormat>
        </uix:rowLayout>
        </uix:tableLayout>
        
      </uix:cellFormat>
      <uix:cellFormat>

        <uix:tableLayout width="100%">
        <uix:rowLayout>
        <uix:cellFormat>
        <uix:labeledFieldLayout labelWidth="50%" fieldWidth="50%">
            <uix:styledText styleClass="OraPromptText" textBinding="ES_DIRECT_WRITES@sqlMsg"/>
            <uix:styledText styleClass="OraDataText" textBinding="disk_writes"/>
        </uix:labeledFieldLayout>
        </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout>
        <uix:cellFormat>
        <uix:labeledFieldLayout labelWidth="50%" fieldWidth="50%">
            <uix:styledText styleClass="OraPromptText" textBinding="ES_CPU_TIME@sqlMsg"/>
            <uix:styledText styleClass="OraDataText" textBinding="cpu_time"/>
        </uix:labeledFieldLayout>
        </uix:cellFormat>
        </uix:rowLayout>
        </uix:tableLayout>
        
      </uix:cellFormat>
      <uix:cellFormat>
        <uix:tableLayout width="100%" >
        <uix:rowLayout  vAlign="top">
        <uix:cellFormat>
        <uix:labeledFieldLayout labelWidth="50%" fieldWidth="50%">
            <uix:styledText styleClass="OraPromptText" textBinding="ES_EXECUTES@sqlMsg"/>
            <uix:styledText styleClass="OraDataText" textBinding="executions"/>
        </uix:labeledFieldLayout>
        </uix:cellFormat>
        </uix:rowLayout>
        </uix:tableLayout>
        
      </uix:cellFormat>
      </uix:rowLayout>

      </uix:tableLayout>
      <uix:styledText styleClass="OraPromptText" textBinding="NOTE@sqlMsg"/>
    <uix:styledList >
       <uix:contents childDataBinding="msgs">
        <uix:styledItem>
         <uix:contents>
          <uix:styledText textBinding="msg"
                          styleClass="OraDataText"/>
         </uix:contents>
        </uix:styledItem>
       </uix:contents>
      </uix:styledList>

            <uix:rawText id="selPlanDetails" textBinding="myframe" /> 
      </uix:stackLayout>
      </uix:header>
      </uix:contents>
      </uix:header>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
