<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsg"
	    class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sqlMsg"
	    class="oracle.sysman.db.rsc.inst.SQLMsg"/>
<uix:bundle name="autoSqlMsg"
	    class="oracle.sysman.db.rsc.inst.AutoSqlTuneMsg"/>

  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
  <%@ include file="/oemTitle.jspf" %>
  <uix:body>
  <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>   
        <db:form name="tsForm"  
                  destination="/console/database/instance/sqltune"
                 copyParams="target,type,task_id,objectId,advisoryCentralURL,dbPageNum,planType">
          <uix:header textBinding="SRT_COL_COMPARE_EXPLAIN_PLANS@sqlMsg" > 
          <uix:switcher childNameBinding="chartAvailability@servletRequest">
          <uix:case name="true">
            <uix:header textBinding="PROFILE_TESTING_RESULT@autoSqlMsg">
            <uix:tableLayout width="100%" borderWidth="0" cellSpacing="10">
            <uix:rowLayout>
            <uix:cellFormat>
		<uix:include nodeBinding="timeChartURL@servletRequest" />
            </uix:cellFormat>
            <uix:cellFormat>
		<uix:include nodeBinding="otherChartURL@servletRequest" />			   
            </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
            <uix:cellFormat columnSpan="2">
     <uix:tableLayout>
     <uix:rowLayout renderedBinding="dbVersionGTE112@servletRequest">
     <uix:cellFormat onMouseOver="document.getElementById('testLayer1').style.visibility='visible';return false;">
     <uix:spacer width="5" height="5"/>
     </uix:cellFormat>
     </uix:rowLayout>
     </uix:tableLayout>
     <uix:rawText renderedBinding="dbVersionGTE112@servletRequest" styleClass="OraText" textBinding="chartData@servletRequest"/>
	    
            </uix:cellFormat>
            </uix:rowLayout>
            </uix:tableLayout>
            </uix:header>
            </uix:case>
            </uix:switcher>
            
            
            <uix:header textBinding="origPlanHeader@servletRequest">
            <uix:switcher childNameBinding="isOriginalWithAdjusted@servletRequest">
            <uix:case name="true">
              <uix:rowLayout>
                <uix:image sourceBinding="changedItemIcon@servletRequest"/>
                <uix:styledText styleClass="OraPromptText" textBinding="KEY_NOTATION_MSG@sqlMsg"/>
              </uix:rowLayout>
            </uix:case>
            </uix:switcher>
            <uix:rowLayout width="80%">
            <uix:labeledFieldLayout labelWidth="15%">
                  <uix:styledText styleClass="OraPromptText"
                                  textBinding="PLAN_HASH_VALUE@dbMsg"/>
                  <uix:styledText styleClass="OraDataText"
                                  textBinding="origPlanHashValue@servletRequest"/>
            </uix:labeledFieldLayout>
            </uix:rowLayout>
            <uix:rowLayout width="100%">
            <uix:cellFormat height="300">
            <uix:rawText textBinding="topFrameText@servletRequest"/>
            </uix:cellFormat>
            </uix:rowLayout>
          </uix:header>
          <uix:header textBinding="newPlanHeader@servletRequest">
          <uix:switcher childNameBinding="planType@servletRequest">
            <uix:case name="newIndexPlan">
             <uix:styledText styleClass="OraPromptText" textBinding="SRT_NEW_EXPLAIN_PLAN_WITH_INDEX_DESC@sqlMsg"/>
            </uix:case>
            <uix:case name="newHintsetPlan">
             <uix:styledText styleClass="OraPromptText" textBinding="SRT_NEW_EXPLAIN_PLAN_WITH_SQLPROFILE_DESC@sqlMsg"/>
            </uix:case>
          </uix:switcher>
            <uix:rowLayout width="80%">
            <uix:labeledFieldLayout labelWidth="15%">
                  <uix:messagePrompt 
                                  promptBinding="PLAN_HASH_VALUE@dbMsg"/>
                  <uix:styledText styleClass="OraDataText"
                                  textBinding="newPlanHashValue@servletRequest"/>
            </uix:labeledFieldLayout>
            </uix:rowLayout>
            <uix:rowLayout width="100%">
            <uix:cellFormat height="300">
            <uix:rawText textBinding="bottomFrameText@servletRequest"/>
            </uix:cellFormat>
            </uix:rowLayout>
          </uix:header>
        </uix:header>
        </db:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
