<%@ include file="/sdk/oemTop.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ page import="oracle.sysman.emo.perf.bean.sqlt.SQLTuningConstants" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="DBObjectMsg"  class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="sqlMsg"  class="oracle.sysman.db.rsc.inst.SQLMsg"/>

  <oem:setURLEncoder id="renderingContext"/>  
  <uix:document>
    <uix:metaContainer>      
      <uix:head titleBinding="CONFIRMATION@DBObjectMsg"/>    
    </uix:metaContainer>    
    
    <uix:body>      
      <db:form name="implAlternativeConfForm" method="GET" destination="/console/database/instance/sqltune" 
          copyParams="target,type,taskName,taskUser,execID,advisoryCentralURL,task_id,objectId,backURL,processBackURL,dbPageNum">
        <uix:formValue name="event"/>
        <uix:formValue name="planHashValue" valueBinding="planHashValue@servletRequest"/>
        
        
        <uix:pageLayout>                  
          <%@ include file="/database/globalPopup.jspf" %>            
          
          <oem:messageBox messageType="error"                   
            errorTableBinding="errors@servletRequest"                  
            titleTextKey="titleText" mainTextKey="mainText"/>          
            
          <uix:header textBinding="CONFIRMATION@DBObjectMsg" icon="/em/images/confirmation.gif">            
            <uix:tableLayout>              
              <uix:rowLayout>              
                <uix:styledText styleClass="OraDataText"                                
                    textBinding="RST_ALTERNATIVE_CONFIRMATION@sqlMsg"
                    labeledNodeId="implProfConfId"/>              
              </uix:rowLayout>              
              <uix:rowLayout>                
                <uix:spacer height="10"/>              
              </uix:rowLayout>              
            </uix:tableLayout>          
          </uix:header>          
            
          <uix:pageButtons>            
            <uix:pageButtonBar>              
              <uix:submitButton textBinding="NO@DBObjectMsg"
                    shortDescBinding="NO@DBObjectMsg"
                    name="event" value="viewRecomm"/>             
              <uix:submitButton textBinding="YES@DBObjectMsg"
                    shortDescBinding="YES@DBObjectMsg"
                    name="event" value="implementPlanBaseline"/>             
            </uix:pageButtonBar>          
          </uix:pageButtons>        
        </uix:pageLayout>        
      </db:form>                
    </uix:body>  
  </uix:document>
</uix:renderingContext> 
