<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsg"
	    class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sqlMsg"
	    class="oracle.sysman.db.rsc.inst.SQLMsg"/>

  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:pageLayout titleBinding="header@servletRequest">
        <%@ include file="/database/global.jspf" %>

        <uix:contents>

          <oem:messageBox messageType="error"
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <db:form name="foo" method="GET" destinationBinding="formDest@servletRequest"
                   copyParams="target,type,task_id,taskName,taskUser,objectId,advisoryCentralURL,dbPageNum">

<uix:styledText styleClass="OraPromptText" textBinding="IDX_DESCRIPTION@sqlMsg"/>
              <uix:labeledFieldLayout columns="1" labelWidth="15%" fieldWidth="85%">

                <uix:messagePrompt labeledNodeId="job_name" promptBinding="IDX_JOB_NAME@sqlMsg"
                                   required="yes"  />

                <uix:textInput name="jobName" id="job_name" columns="40"
                               textBinding="jobName@sresultObj@servletRequest" />

                <uix:messagePrompt labeledNodeId="comment" promptBinding="IDX_COMMENT@sqlMsg"/>

                <uix:textInput name="jobComment" id = "comment" columns="80"
                               textBinding="jobComment@sresultObj@servletRequest" />

                <uix:messagePrompt promptBinding="IDX_SQL_ID@sqlMsg"/>
                <uix:link textBinding="signature@sresultObj@servletRequest" destinationBinding="sqlUrl@servletRequest" />

              </uix:labeledFieldLayout>

              <uix:header textBinding="IDX_NEW_INDEXES@sqlMsg">

                <oem:table name="recomTable" width="100%" 
			   summaryBinding="IDX_NEW_INDEXES@sqlMsg"
                           dataSourceBinding="recomTable@servletRequest"
                           formSubmitted="true">

<%--
                  <uix:tableSelection>
                    <uix:multipleSelection
                      shortDescBinding="SELECT@ResourceBundle@servletRequest"
                      selectionBinding="selection@recomTable@servletRequest"
selectedBinding="selection@recomTable@servletRequest"
                      >
                    </uix:multipleSelection>
                  </uix:tableSelection>
--%>
                  <uix:tableFormat tableBanding="noBanding"/>

                </oem:table>
              </uix:header>

<uix:switcher childNameBinding="hintsetRecomRendered@servletRequest">
          <uix:case name="true">

              <uix:header textBinding="IDX_SQL_PROFILE_RECOMMENDATION@sqlMsg"
                          renderedBinding="hintsetRecomRendered@servletRequest">
                <uix:messagePrompt promptBinding="IDX_SQL_PROFILE_INFO@sqlMsg" />
              </uix:header>
        </uix:case>
      </uix:switcher>

<uix:dataScope>
<uix:bundle name="ScheduleBundle"
          class="oracle.sysman.emSDK.eml.SDKUIMsg"/>         

<%-- START HEADER --%>
<uix:header textBinding="OPT_SCHEDULE@sqlMsg">

<uix:tableLayout cellSpacing="5">
<%-- START TIME ZONE --%>
<uix:cellFormat hAlign="right">
<uix:messagePrompt
     promptBinding="TIME_ZONE@ScheduleBundle"
/>
</uix:cellFormat>
<uix:cellFormat>
<oem:choice
     name="startTimeZoneSB"
     optionsBinding="timeZonesSB@scheduleBean@servletRequest"
     selectedValueBinding="startTimeZoneSB@scheduleBean@servletRequest"
/>
</uix:cellFormat>
</uix:tableLayout>

<uix:tableLayout cellSpacing="5">
<uix:rowLayout>
<%-- IMMEDIATELY RADIO BUTTON --%>
<uix:radioButton
     name="scheduleTypeSB"
     value="now"
     selectedValueBinding="scheduleTypeSB@scheduleBean@servletRequest"
     textBinding="IMMEDIATELY@ScheduleBundle"
     styleClass="OraInstructionText"
/>
</uix:rowLayout>

<uix:rowLayout>
<%-- LATER RADIO BUTTON --%>
<uix:radioButton
     name="scheduleTypeSB"
     value="later"
     selectedValueBinding="scheduleTypeSB@scheduleBean@servletRequest"
     textBinding="LATER@ScheduleBundle"
     styleClass="OraInstructionText"
/>
</uix:rowLayout>

<uix:rowLayout>
<%-- START DATE --%>
<uix:cellFormat  hAlign="right">
<uix:messagePrompt
     promptBinding="DATE@ScheduleBundle"
/>
</uix:cellFormat>
<uix:messageDateField
     name="startDateSB"
     valueBinding="startDateSB@scheduleBean@pageContext"
     tipBinding="dateTip@scheduleBean@servletRequest"
     columns="24">
<uix:onSubmitValidater>
<uix:date dateStyle="medium"/>
</uix:onSubmitValidater>
</uix:messageDateField>
</uix:rowLayout>

<uix:rowLayout hAlign="right">
<%-- START HOUR --%>
<uix:messagePrompt
     promptBinding="TIME@ScheduleBundle"
/>
<uix:flowLayout>
<oem:choice
     name="startHourSB"
     optionsBinding="hoursSB@scheduleBean@servletRequest"
     selectedValueBinding="startHourSB@scheduleBean@servletRequest"
/>

<%-- START MINUTE --%>
<oem:choice
     name="startMinuteSB"
     optionsBinding="minutesSB@scheduleBean@servletRequest"
     selectedValueBinding="startMinuteSB@scheduleBean@servletRequest"
/>

<%-- START SECOND --%>
<oem:choice
     name="startSecondSB"
     renderedBinding="showSeconds@scheduleBean@servletRequest"
     optionsBinding="secondsSB@scheduleBean@servletRequest"
     selectedValueBinding="startSecondSB@scheduleBean@servletRequest"
/>

<%-- START AM/PM --%>
<oem:radioButton
     name="startAmPmSB"
     value="AM_VALUE"
     selectedValueBinding="startAmPmSB@scheduleBean@servletRequest"
     textBinding="AM_LABEL@ScheduleBundle"
     styleClass="OraInstructionText"
/>
<oem:radioButton
     name="startAmPmSB"
     value="PM_VALUE"
     selectedValueBinding="startAmPmSB@scheduleBean@servletRequest"
     textBinding="PM_LABEL@ScheduleBundle"
     styleClass="OraInstructionText"
/>
</uix:flowLayout>
</uix:rowLayout>

</uix:tableLayout>
</uix:header>

</uix:dataScope>
<%--              <%@ include file="/sdk/schedule/start.jspf" %>  --%>

            <%-- /uix:header --%>

          </db:form>
        </uix:contents>

        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:flowLayout>
              <uix:submitButton textBinding="CANCEL@dbMsg" name="event" value="cancelIndexCreate" formName="foo"/>
              <uix:spacer width="5"/>
              <uix:submitButton textBinding="SHOW_SQL@dbMsg" name="event" value="showSQL" formName="foo"/>
              <uix:spacer width="5"/>
              <uix:submitButton textBinding="OK@dbMsg" name="event" value="createIndex" formName="foo"/>
            </uix:flowLayout>
          </uix:pageButtonBar>
        </uix:pageButtons>


      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
