<%--
  -- Page:        options.jsp
  -- Controller:  oracle.sysman.db.adm.inst.SqltuneController.java
  --
  -- Description: Export SQL Tuning Set page
  --
  --  MODIFIED    (MM/DD/YY)
  --     ezeng   06/06/07 - 
  --     misun   03/02/07 - fix SQL Tuning Advisor UI Exit Review bugs.
  --     yfeng   12/06/06 - Fix ADA issues
  --%>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<db:script src="/database/LOV.js"/>

<script language="javascript">
function setScopeOptions()
{
    bDisable = document.forms[0].scope[0].checked;
    document.forms[0].perStatementTimeLimitMinutes.disabled = bDisable;
}
</script>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsg"
	    class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sqlMsg"
	    class="oracle.sysman.db.rsc.inst.SQLMsg"/>

  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body onLoad="setScopeOptions()">
          <db:form name="foo" method="GET" destination="/console/database/instance/sqltune"
                   copyParams="target,type,isSTS,newSTS,backURL,defaultSTSName,sts,stsOwner,advisorCentralURL,dbPageNum,sql_id,childNum,planHashValue,beginSnapId,endSnapId,pageName">
            <uix:formValue name="pageName" value="/database/instance/sqltune/options"/>

      <uix:pageLayout titleBinding="OPT_PAGE_HEADER@sqlMsg">
          <oem:messageBox messageType="error"
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

        <%@ include file="/database/global.jspf" %>

<uix:styledText styleClass="OraInstructionText" textBinding="OPT_INSTRUCTION@sqlMsg"/>
    <uix:spacer height="5"/>

<uix:switcher childNameBinding="dataSource@servletRequest">
  <uix:case name="true">
    <uix:stackLayout>
        <%@include file="optionsTask.jspf" %>        
    </uix:stackLayout>
  </uix:case>
  
  <uix:case name="false">
    <uix:stackLayout>
        <uix:rowLayout>
            <uix:cellFormat width="60%">
                <%@include file="optionsTask.jspf" %>
            </uix:cellFormat>
        
            <uix:cellFormat width="40%">
                <uix:contentContainer textBinding="OVERVIEW@sqlMsg" width="100%">
                    <uix:stackLayout>
                        <uix:separator>
                            <uix:spacer width="10" height="7"/>
                        </uix:separator>
                  
                        <uix:rowLayout>
                            <uix:styledText styleClass="OraInstructionText" 
                                textBinding="OVERVIEW_DES1@sqlMsg" />
                        </uix:rowLayout>
                        <uix:rowLayout/>
                        <uix:rowLayout>
                            <uix:styledText styleClass="OraInstructionText" 
                                textBinding="OVERVIEW_DES2@sqlMsg" />
                        </uix:rowLayout>
                        <uix:rowLayout/>
                        <uix:rowLayout>
                            <uix:styledText styleClass="OraInstructionText" 
                                textBinding="OVERVIEW_DES3@sqlMsg" />
                        </uix:rowLayout>
                        <uix:rowLayout/>
                        <uix:tableLayout width="100%" cellSpacing="2">
                            <uix:rowLayout>
                            <db:link textBinding="ACTIVITY_DETAILS@dbMsg"
                                    destination="/console/database/instance/waitDetails?event=doLoad&waitClass=Overview"
                                    copyParams="target,type,dbPageNum"/>
                            <uix:spacer height="10"/>
                      
                            <db:link textBinding="PERIOD_SQL@dbMsg"
                                    destination="/console/database/instance/topSqls?event=doLoad&refreshChoice=1" 
                                    copyParams="target,type,dbPageNum"/>
                            <uix:spacer height="10"/>
      
                            <db:link textBinding="SQL_TUNING_SETS@dbMsg" 
                                    destination="/console/database/instance/sqlSet?event=doLoad" 
                                    copyParams="target,type,dbPageNum"/>
                            <uix:spacer height="10"/>
                            <%-- need to be changed into SQL Worksheet, the destination need to be generated from java coder
                            <db:link textBinding="SNAPSHOTS@dbMsg"
                                    destination="/console/database/instance/swrfSnapshots?event=doLoad" 
                                    copyParams="target,type,dbPageNum"/>
                            --%>
                            </uix:rowLayout>
                        </uix:tableLayout>      
                    </uix:stackLayout>
              </uix:contentContainer>

                <%-- uix:contentContainer textBinding="SQL_TUNING_ADVISOR_DATA_SOURCE_LINKS@sqlMsg" width="100%">
                    <uix:stackLayout>
                        <uix:separator>
                            <uix:spacer width="10" height="7"/>
                        </uix:separator>
                  
                        <uix:styledText styleClass="OraInstructionText" 
                            textBinding="SQL_TUNING_ADVISOR_DATA_SOURCE_LINKS_DESC@sqlMsg" />
                        <uix:tableLayout width="100%" cellSpacing="2">
                            <uix:rowLayout>
                            <db:link textBinding="ACTIVITY_DETAILS@dbMsg"
                                    destination="/console/database/instance/waitDetails?event=doLoad&waitClass=Overview"
                                    copyParams="target,type,dbPageNum"/>
                            <uix:spacer height="10"/>
                      
                            <db:link textBinding="PERIOD_SQL@dbMsg"
                                    destination="/console/database/instance/topSqls?event=doLoad&refreshChoice=1" 
                                    copyParams="target,type,dbPageNum"/>
                            <uix:spacer height="10"/>
      
                            <db:link textBinding="SQL_TUNING_SETS@dbMsg" 
                                    destination="/console/database/instance/sqlSet?event=doLoad" 
                                    copyParams="target,type,dbPageNum"/>
                            <uix:spacer height="10"/>
                            <db:link textBinding="SNAPSHOTS@dbMsg"
                                    destination="/console/database/instance/swrfSnapshots?event=doLoad" 
                                    copyParams="target,type,dbPageNum"/>
                            </uix:rowLayout>
                        </uix:tableLayout>      
                    </uix:stackLayout>
              </uix:contentContainer --%>
            </uix:cellFormat>
        </uix:rowLayout>      
    </uix:stackLayout>
  </uix:case>
</uix:switcher>
 
 <uix:hideShowHeader id="sqlStatementsHideShow"
                     textBinding="OPT_SQL_STMTS@sqlMsg"
                     disclosedBinding="showSqlStatements@defaultBean@servletRequest"
                     formName="foo"
                     formSubmitted="true" >

    <oem:table name="stmts"
        summaryBinding="OPT_SQL_STMTS@sqlMsg"
        partialRenderMode="self"
        dataSourceBinding="stmtTableUI@servletRequest"
        width="80%"
        renderedBinding="stmtTableUIRendered@servletRequest"
        blockSize="5"
        formSubmitted="true"
        copyParams="target,type,isSTS,newSTS,backURL,sts,stsOwner,defaultSTSName,advisorCentralURL,dbPageNum,sql_id,childNum,planHashValue,beginSnapId,endSnapId">
    </oem:table>
</uix:hideShowHeader>

              <uix:header textBinding="OPT_SCOPE@sqlMsg">
                <uix:stackLayout>
                    <uix:rowLayout width="100%">
                        <uix:cellFormat vAlign="middle" width="15%" hAlign="right">                      
                            <uix:styledText styleClass="OraPromptText"
                                labeledNodeId="OptTotalTimeLimit"
                                textBinding="OPT_TOTAL_TIME_LIMIT@sqlMsg"/>
                        </uix:cellFormat>
                        <uix:cellFormat width= "2" />                      
                        <uix:cellFormat vAlign="middle" hAlign="left">                      
                            <uix:textInput name="timeLimitedMinutes"
                                id="OptTotalTimeLimit"
                                textBinding="timeLimitedMinutes@defaultBean@servletRequest" columns="6"/>
                        </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout width="100%">
                        <uix:cellFormat vAlign="top" width="15%" hAlign="right">                      
                            <uix:styledText styleClass="OraPromptText"
                                labeledNodeId="OptTotalTimeLimit"
                                textBinding="DIAGOPT_SCOPE_OF_ANALYSIS@sqlMsg"/>
                        </uix:cellFormat>
                        <uix:cellFormat width= "2" />                      
                        <uix:cellFormat vAlign="middle" hAlign="left">                      
                            <uix:rowLayout>
                                <oem:radioButton name="scope"
                                   value="LIMITED" selectedValueBinding="scope@defaultBean@servletRequest"
                                   textBinding="OPT_LIMITED@sqlMsg"
                                   onClick='setScopeOptions()'
                                   styleClass="OraInstructionText"/>
                            </uix:rowLayout>
                            <uix:rowLayout>
                                <uix:cellFormat width= "20" />
                                <uix:cellFormat>
                                    <uix:styledText styleClass="OraInlineInfoText" 
                                        textBinding="OPT_LIMITED_HINT@sqlMsg" />
                                </uix:cellFormat>
                            </uix:rowLayout>
                            <uix:rowLayout>
                                <oem:radioButton name="scope"
                                   value="COMPREHENSIVE" selectedValueBinding="scope@defaultBean@servletRequest"
                                   textBinding="OPT_COMPREHENSIVE@sqlMsg"
                                   onClick='setScopeOptions()'
                                   styleClass="OraInstructionText"/>
                            </uix:rowLayout>
                            <uix:rowLayout>
                                <uix:cellFormat width= "20" />
                                <uix:cellFormat>
                                <uix:styledText styleClass="OraInlineInfoText" 
                                    textBinding="OPT_COMPREHENSIVE_HINT@sqlMsg" />
                                </uix:cellFormat>
                            </uix:rowLayout>
                            <uix:rowLayout>
                                <uix:cellFormat width= "30"/>
                                <uix:cellFormat vAlign="middle">
                                    <uix:styledText styleClass="OraPromptText"
                                            labeledNodeId="OptPerStatementTimeLimit"
                                            textBinding="OPT_PER_STATEMENT_TIME_LIMIT@sqlMsg"/>
                                </uix:cellFormat>
                                <uix:cellFormat width= "2" /> 
                                <uix:cellFormat vAlign="middle" hAlign="left">                      
                                    <uix:textInput name="perStatementTimeLimitMinutes"
                                            id="OptPerStatementTimeLimit"
                                            textBinding="perStatementTimeLimitMinutes@defaultBean@servletRequest" columns="6"/>
                                </uix:cellFormat>
                            </uix:rowLayout>
                        </uix:cellFormat>                    
                    </uix:rowLayout>                
                </uix:stackLayout>
              </uix:header>
<uix:dataScope>
<uix:bundle name="ScheduleBundle"
          class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

<%-- START HEADER --%>
<uix:header textBinding="OPT_SCHEDULE@sqlMsg">

<uix:tableLayout cellSpacing="5">
<%-- START TIME ZONE --%>
<uix:cellFormat hAlign="right">
<uix:messagePrompt labeledNodeId="startTimeZoneSB"
     promptBinding="TIME_ZONE@ScheduleBundle"
/>
</uix:cellFormat>
<uix:cellFormat>
<oem:choice
     name="startTimeZoneSB"
     id="startTimeZoneSB"
     optionsBinding="timeZonesSB@scheduleBean@servletRequest"
     selectedValueBinding="startTimeZoneSB@scheduleBean@servletRequest"
/>
</uix:cellFormat>
</uix:tableLayout>

<uix:tableLayout cellSpacing="5">
<uix:rowLayout>
<%-- IMMEDIATELY RADIO BUTTON --%>
<uix:radioButton
     name="scheduleTypeSB"
     value="now"
     selectedValueBinding="scheduleTypeSB@scheduleBean@servletRequest"
     textBinding="IMMEDIATELY@ScheduleBundle"
     styleClass="OraInstructionText"
/>
</uix:rowLayout>

<uix:rowLayout>
<%-- LATER RADIO BUTTON --%>
<uix:radioButton
     name="scheduleTypeSB"
     value="later"
     selectedValueBinding="scheduleTypeSB@scheduleBean@servletRequest"
     textBinding="LATER@ScheduleBundle"
     styleClass="OraInstructionText"
/>
</uix:rowLayout>

<uix:rowLayout>
<%-- START DATE --%>
<uix:cellFormat  hAlign="right">
<uix:messagePrompt
     promptBinding="DATE@ScheduleBundle"
     labeledNodeId="startDateSB"
/>
</uix:cellFormat>
<uix:messageDateField
     name="startDateSB"
     id="startDateSB"
     valueBinding="startDateSB@scheduleBean@pageContext"
     tipBinding="dateTip@scheduleBean@servletRequest"
     columns="24">
<uix:onSubmitValidater>
<uix:date dateStyle="medium"/>
</uix:onSubmitValidater>
</uix:messageDateField>
</uix:rowLayout>

<uix:rowLayout hAlign="right">
<%-- START HOUR --%>
<uix:messagePrompt
     promptBinding="TIME@ScheduleBundle"
     labeledNodeId="startHourSB"
/>
<uix:flowLayout>
<oem:choice
     name="startHourSB"
     id="startHourSB"
     optionsBinding="hoursSB@scheduleBean@servletRequest"
     selectedValueBinding="startHourSB@scheduleBean@servletRequest"
     shortDescBinding="HOURS@ScheduleBundle"
/>

<%-- START MINUTE --%>
<oem:choice
     name="startMinuteSB"
     optionsBinding="minutesSB@scheduleBean@servletRequest"
     selectedValueBinding="startMinuteSB@scheduleBean@servletRequest"
     shortDescBinding="MINUTES@ScheduleBundle"
/>

<%-- START SECOND --%>
<oem:choice
     name="startSecondSB"
     renderedBinding="showSeconds@scheduleBean@servletRequest"
     optionsBinding="secondsSB@scheduleBean@servletRequest"
     selectedValueBinding="startSecondSB@scheduleBean@servletRequest"
     shortDescBinding="SECONDS@ScheduleBundle"
/>

<%-- START AM/PM --%>
<oem:radioButton
     name="startAmPmSB"
     value="AM_VALUE"
     selectedValueBinding="startAmPmSB@scheduleBean@servletRequest"
     textBinding="AM_LABEL@ScheduleBundle"
     styleClass="OraInstructionText"
/>
<oem:radioButton
     name="startAmPmSB"
     value="PM_VALUE"
     selectedValueBinding="startAmPmSB@scheduleBean@servletRequest"
     textBinding="PM_LABEL@ScheduleBundle"
     styleClass="OraInstructionText"
/>
</uix:flowLayout>
</uix:rowLayout>

<%-- TIME LIMIT --%>
<%--
<uix:rowLayout>
<uix:cellFormat  hAlign="right">
<uix:messagePrompt
     prompt="Time Limit (Minutes)" required="yes"
/>
</uix:cellFormat>
<uix:textInput name="timeLimitedMinutes"
    shortDescBinding="timeLimitedMinutes@defaultBean@servletRequest"
    textBinding="timeLimitedMinutes@defaultBean@servletRequest" columns="10"/>
</uix:rowLayout>
--%>
</uix:tableLayout>
</uix:header>

</uix:dataScope>

            <%-- /uix:header --%>


        <uix:pageButtons>
          <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@dbMsg"
                                name="event" value="cancelOptions"/>
              <uix:submitButton textBinding="SUBMIT@sqlMsg" name="event" value="acceptOptions"/>
          </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>
          </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
