<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsg"
	    class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sqlMsg"
	    class="oracle.sysman.db.rsc.inst.SQLMsg"/>
<uix:bundle name="autoSqlMsg"
	    class="oracle.sysman.db.rsc.inst.AutoSqlTuneMsg"/>

  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
  <%@ include file="/oemTitle.jspf" %>
  <uix:body>
  <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>   
        <oem:messageBox messageType="error"
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
        <db:form name="tsForm"  
                  destination="/console/database/instance/sqltune"
                 copyParams="target,type,task_id,objectId,advisoryCentralURL,dbPageNum,planType">
            <uix:contents childDataBinding="pqRecommend@servletRequest">
          <uix:header textBinding="PX_DETAILS@sqlMsg" > 
            <uix:header textBinding="INFORMATION@sqlMsg">
            <uix:stackLayout>
                <uix:styledText styleClass="OraInstructionText" textBinding="note"/> 
            <uix:tableLayout width="100%" >
            <uix:rowLayout>
            <uix:rawText>
            <td rowspan="3" width="20"><script>t(20,1)</script></td>
            </uix:rawText>
            <uix:cellFormat>
            <uix:table tableDataBinding="pxInfo" width="50%">
                <uix:tableFormat tableBanding="rowBanding"/>
                <uix:column>
                    <uix:styledText styleClass="OraPromptText" textBinding="key"/>
                </uix:column>
                <uix:column> 
                    <uix:columnFormat columnDataFormat="numberFormat" />
                    <uix:styledText styleClass="OraDataText" textBinding="value"/>
                </uix:column>
            </uix:table>
            </uix:cellFormat>
            </uix:rowLayout>
            </uix:tableLayout>
            </uix:stackLayout>
            </uix:header>
            
            <uix:header textBinding="RST_COL_STATS@sqlMsg">
            <uix:stackLayout>
            <uix:styledText styleClass="OraInstructionText" textBinding="PX_INSTR_TEXT@sqlMsg"/>
                <uix:header textBinding="PAST_WEEK@sqlMsg">
                    <uix:table tableDataBinding="beforeStat" width="50%">
                        <uix:tableFormat tableBanding="rowBanding"/>
                        <uix:column>
                            <uix:styledText styleClass="OraPromptText" textBinding="key"/>
                        </uix:column>
                        <uix:column> 
                            <uix:columnFormat columnDataFormat="numberFormat" />
                            <uix:styledText styleClass="OraDataText" textBinding="value"/>
                        </uix:column>
                    </uix:table>
                </uix:header>
                <uix:header textBinding="PROJ_STATS@sqlMsg">
                    <uix:table tableDataBinding="afterStat" width="50%">
                        <uix:tableFormat tableBanding="rowBanding"/>
                        <uix:column>
                            <uix:styledText styleClass="OraPromptText" textBinding="key"/>
                        </uix:column>
                        <uix:column> 
                            <uix:columnFormat columnDataFormat="numberFormat" />
                            <uix:styledText styleClass="OraDataText" textBinding="value"/>
                        </uix:column>
                    </uix:table>
                </uix:header>
                </uix:stackLayout>
            </uix:header>
 
               
        </uix:header>
            </uix:contents>
        </db:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
