<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsg"
	    class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sqlMsg"
	    class="oracle.sysman.db.rsc.inst.SQLMsg"/>

<oem:setURLEncoder id="renderingContext"/> 
<uix:rawText>
    <meta http-equiv="Refresh"
            content="5; URL=<%=request.getAttribute("sqltuneProcessRefreshUrl") %>">
</uix:rawText>
  <uix:document> 

    <%@ include file="/enablePPR.jspf" %>
    <%-- @ include file="/completePPR.jspf"  --%>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/setRefreshRate.jspf" %>

    <uix:body>
      <db:form name="processForm" method="POST" destination="/console/database/instance/sqltune" copyParams="target,type,processId,backURL,planHashValue,objectId,advisorCentralURL,processBackURL,dbPageNum">
      <uix:formValue name="pageName" value="/database/instance/sqltune/process.jsp"/>

    <uix:pageLayout titleBinding="header@processBean@servletRequest">
        <%@ include file="/database/global.jspf" %>
	
        <uix:spacer height="5" />
        <uix:styledText styleClass="OraInstructionText" textBinding="PROCESSING_DESCRIPTION@sqlMsg"/>
        <uix:spacer height="5" /> 

        <uix:labeledFieldLayout columns="3">            
            <uix:styledText styleClass="OraPromptText" 
                            textBinding="OPT_TUNING_SET_OWNER@sqlMsg" 
                            renderedBinding="showSTSOwner@processBean@servletRequest"/>                
            <uix:styledText styleClass="OraDataText" 
                            textBinding="STSOwner@processBean@servletRequest" 
                            renderedBinding="showSTSOwner@processBean@servletRequest"/>
                
            <uix:styledText styleClass="OraPromptText"
                        textBinding="stsNameOrSqlIdLabel@processBean@servletRequest"/>
            <uix:styledText styleClass="OraDataText"
                        textBinding="stsNameOrSqlId@processBean@servletRequest"/>

            <uix:styledText styleClass="OraPromptText" textBinding="RST_TIME_LIMIT@sqlMsg"/>
            <uix:styledText styleClass="OraDataText" textBinding="timeLimitSeconds@processBean@servletRequest"/>

        </uix:labeledFieldLayout>
        <uix:spacer height="5" /> 
        
        <%-- do refresh for this process --%>
        <uix:processing id="percentageTunedSqlStmtNum"
             percentCompleteBinding="percentageTunedSqlStmtNum@processBean@servletRequest"
             timeInterval="150000">

        <uix:spacer height="5" /> 
              <uix:labeledFieldLayout>
            <uix:styledText styleClass="OraPromptText" textBinding="RST_STATUS@sqlMsg"/>
            <uix:styledText styleClass="OraDataText" textBinding="taskStatus@processBean@servletRequest"/>
            <uix:styledText styleClass="OraPromptText" textBinding="RST_STARTED@sqlMsg"/>
            <uix:styledText styleClass="OraDataText" textBinding="startDate@processBean@servletRequest"/>


                <uix:styledText styleClass="OraPromptText" textBinding="PROCESSING_ELAPSED_TIME@sqlMsg"/>
                <uix:styledText styleClass="OraDataText" textBinding="elapsedSeconds@processBean@servletRequest"/>
              </uix:labeledFieldLayout>

        <uix:spacer height="5" /> 
        <uix:tableLayout cellSpacing="1" hAlign="center">
            <uix:contents childDataBinding="allStepsData@processBean@servletRequest">
                <uix:rowLayout>
                    <uix:cellFormat>
                        <uix:image source="/em/images/processCheck.gif"
                            shortDescBinding="RST_COMPLETED@sqlMsg"
                          renderedBinding="renderedDone"/>       
                        <uix:image source="/em/images/currentStep.gif" 
                            shortDescBinding="PROCESSING_CURRENT_EXECUTING@sqlMsg"
                          renderedBinding="current"/>       
                    </uix:cellFormat>
                    <uix:spacer width="3" />
                    <uix:switcher childNameBinding="stepOutFormat">
                        <uix:case name="text">
                            <uix:cellFormat vAlign="bottom">
                              <uix:styledText styleClass="OraFieldText" textBinding="text" /> 
                            </uix:cellFormat>
                        </uix:case>
                        <uix:case name="table">
                            <uix:cellFormat vAlign="bottom">
                                <uix:tableLayout cellSpacing="1">
                                    <uix:rowLayout>
                                        <uix:cellFormat>
                                            <uix:styledText styleClass="OraDataText" textBinding="tunedSqlStmtNum@processBean@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:spacer width="2" />
                                        <uix:cellFormat>
                                            <uix:styledText styleClass="OraPromptText" textBinding="LABEL_OUT_OF@sqlMsg"/>
                                            <uix:styledText styleClass="OraDataText" textBinding="totalSqlStmtNum@processBean@servletRequest"/>
                                            <uix:styledText styleClass="OraPromptText" textBinding="LABEL_SQL_STATEMENT@sqlMsg"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>                            
                                    <uix:rowLayout>
                                        <uix:cellFormat>
                                            <uix:styledText styleClass="OraDataText" textBinding="benefitSofarString@processBean@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:spacer width="2" />
                                        <uix:cellFormat>
                                            <uix:styledText styleClass="OraPromptText" textBinding="PROCESSING_LABEL_BENEFIT_SO_FAR@sqlMsg"/>
                                        </uix:cellFormat>                                                                        
                                    </uix:rowLayout>                            
                                </uix:tableLayout>
                            </uix:cellFormat>
                        </uix:case>
                    </uix:switcher>
                </uix:rowLayout>
            </uix:contents>
        </uix:tableLayout>

        </uix:processing>
        <uix:tip>
            <uix:styledText textBinding="PROCESSING_PAGE_TIP@sqlMsg"  styleClass="OraTipText"  />
        </uix:tip>

       <uix:pageButtons>
        <uix:pageButtonBar>
           <uix:submitButton textBinding="CANCEL@dbMsg" name="event" value="cancelProcess" /> 
           <uix:submitButton textBinding="PROCESSING_INTERRUPT@sqlMsg" name="event" value="interruptProcess"/>
        </uix:pageButtonBar>
        </uix:pageButtons>

     </uix:pageLayout>

     </db:form>
    
    </uix:body>
  </uix:document> 
</uix:renderingContext>
