<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%-- ================  SQL Page =================== 
   MODIFIED    (MM/DD/YY)
      manaraya  03/29/09 - Bug 7707453
      ezeng     02/21/08 - add plan hash value
      nachen    04/11/07 - fix desc for new plan
      misun     01/05/07 - XbranchMerge misun_bug-5675432 from main
      misun     12/14/06 - fix bug 5675432
      hxlin     04/11/06 - Cut over to sharable execution plan component 
      ychan     07/14/06 - Change destination binding 
      nachen    06/22/05 - add summary for hgrid 
      nachen    04/18/05 - add graphical new plans 
      nachen    01/18/05 - add blue dot 
      nachen    11/16/04 - fix legend url 
      nachen    10/15/04 - add graphical explain plan 
      nachen    04/16/04 - fix bug 3153000
      nachen    09/10/03 - change the text in original plan page 
      nachen    08/08/03 - add nls string 
      nachen    08/06/03 - add line id 
      hsu       07/25/03 - change global
      nachen    07/02/03 - add advisoryCentralURL
      yfeng     06/12/03 - yfeng_sql_6_10
      yfeng     06/11/03 - Created
--%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsg"
	    class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sqlMsg"
	    class="oracle.sysman.db.rsc.inst.SQLMsg"/>
<uix:bundle name="sdkMessageBundle"
	    class="oracle.sysman.emSDK.eml.SDKUIMsg"/>      

  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:pageLayout>
        <%@ include file="/database/global.jspf" %>
        <db:form name="tsForm"
                  destination="/console/database/instance/sqltune"
                 copyParams="target,type,planType,execID,taskUser,taskName,task_id,objectId,execID,advisoryCentralURL,dbPageNum,planType,state,_root,node">
        <uix:formValue name="event"/>
        <uix:formValue name="pageName" value="/database/instance/sqltune/sqlPlan.jsp"/>
          <uix:header textBinding="header@servletRequest" >

            <uix:rowLayout width="80%">
            <uix:labeledFieldLayout labelWidth="15%">
                  <uix:styledText styleClass="OraPromptText"
                                  textBinding="PLAN_HASH_VALUE@dbMsg"/>
                  <uix:switcher childNameBinding="planType@servletRequest">
                    <uix:case name="original">
                    <uix:styledText styleClass="OraDataText"
                                    textBinding="origPlanHashValue@servletRequest"/>
                    </uix:case>
                    <uix:case name="indexPlan">
                    <uix:styledText styleClass="OraDataText"
                                    textBinding="newPlanHashValue@servletRequest"/>
                    </uix:case>
                    <uix:case name="hintsetPlan">
                    <uix:styledText styleClass="OraDataText"
                                    textBinding="newPlanHashValue@servletRequest"/>
                    </uix:case>
                    <uix:case name="hintsetPXPlan">
                    <uix:styledText styleClass="OraDataText"
                                    textBinding="newPlanHashValue@servletRequest"/>
                    </uix:case>
                    <uix:case name="newAlternativePlan">
                    <uix:flowLayout>
                    <uix:styledText styleClass="OraDataText"
                                    textBinding="newPlanHashValue@servletRequest"/>
		            <uix:formValue name="planHashValue" valueBinding="newPlanHashValue@servletRequest"/>
                    </uix:flowLayout>
                    </uix:case>
                  </uix:switcher>
            </uix:labeledFieldLayout>
            </uix:rowLayout>

<uix:switcher childNameBinding="displayTypeForOrigPlan@sresultObj@servletRequest">
  <uix:case name="tabular">
  <uix:switcher childNameBinding="isOriginalWithAdjusted@servletRequest">
    <uix:case name="true">
    <uix:switcher childNameBinding="planType@servletRequest">
      <uix:case name="original">
      <uix:rowLayout>
      <uix:image sourceBinding="changedItemIcon@servletRequest"/>
      <uix:styledText styleClass="OraPromptText" textBinding="KEY_NOTATION_MSG@sqlMsg"/>
      </uix:rowLayout>
      </uix:case>
    </uix:switcher>
    </uix:case>
  </uix:switcher>
  </uix:case>
</uix:switcher>


      <uix:switcher childNameBinding="usingSVG@servletRequest">
      <uix:case name="true">
        <uix:tableLayout>
        <uix:rowLayout>
        <uix:messagePrompt promptBinding="VIEW_DETAIL@dbMsg"/>
        <uix:switcher childNameBinding="planType@servletRequest">
        <uix:case name="original">
        <uix:flowLayout>
          <uix:contents childDataBinding="displayTypesListForOrigPlan@sresultObj@servletRequest">
          <uix:radioButton name="displayTypeForOrigPlan" 
                         textBinding="text"
                         valueBinding="val" 
                         onClickBinding="onclick"
                         selectedBinding="selected"/>
          </uix:contents>
        </uix:flowLayout>
        </uix:case>
        <uix:case name="indexPlan">
        <uix:flowLayout>
          <uix:contents childDataBinding="displayTypesListForIndexPlan@sresultObj@servletRequest">
          <uix:radioButton name="displayTypeForIndexPlan" 
                         textBinding="text"
                         valueBinding="val" 
                         onClickBinding="onclick"
                         selectedBinding="selected"/>
          </uix:contents>
        </uix:flowLayout>
        </uix:case>
        <uix:case name="hintsetPlan">
        <uix:flowLayout>
          <uix:contents childDataBinding="displayTypesListForHintsetPlan@sresultObj@servletRequest">
          <uix:radioButton name="displayTypeForHintsetPlan" 
                         textBinding="text"
                         valueBinding="val" 
                         onClickBinding="onclick"
                         selectedBinding="selected"/>
          </uix:contents>
        </uix:flowLayout>
        </uix:case>
        <uix:case name="hintsetPXPlan">
        <uix:flowLayout>
          <uix:contents childDataBinding="displayTypesListForHintsetPlan@sresultObj@servletRequest">
          <uix:radioButton name="displayTypeForHintsetPlan" 
                         textBinding="text"
                         valueBinding="val" 
                         onClickBinding="onclick"
                         selectedBinding="selected"/>
          </uix:contents>
        </uix:flowLayout>
        </uix:case>
        <uix:case name="newAlternativePlan">
        <uix:flowLayout>
          <uix:contents childDataBinding="displayTypesListForAlternativePlan@sresultObj@servletRequest">
          <uix:radioButton name="displayTypeForAlternativePlan" 
                         textBinding="text"
                         valueBinding="val" 
                         onClickBinding="onclick"
                         selectedBinding="selected"/>
          </uix:contents>
        </uix:flowLayout>
        </uix:case>
        </uix:switcher>
        </uix:rowLayout>
        </uix:tableLayout>
      </uix:case>
      </uix:switcher>

      <uix:tableLayout width="100%">
      <uix:rowLayout>
      <uix:cellFormat height="100%" width="100%">
        <uix:switcher childNameBinding="displayType@servletRequest">
          <uix:case name="graphical">
		<oem:topology topoPageType="sqlPlanTopoPageType"
                            keyParameters="target, type, objectId, task_id, planType,taskName,taskUser" 
                            width="100%"
                            height="100%"/> 
	  </uix:case>
	  <uix:case name="tabular">
            <%@ include file="/database/instance/executionPlanTable.jspf" %>
	  </uix:case>
        </uix:switcher>
       </uix:cellFormat>
       </uix:rowLayout>
       </uix:tableLayout>

        <uix:switcher childNameBinding="displayType@servletRequest">
          <uix:case name="graphical">
    <uix:tip>
            <uix:styledText textBinding="LEGEND_TEXT@sdkMessageBundle"/>
            <uix:link textBinding="ICON_LEGEND_HEADER@sqlMsg" destinationBinding="iconLegendUrl@servletRequest"/>  
    </uix:tip>                           
	  </uix:case>
    </uix:switcher> 

          </uix:header>            
        </db:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

