<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsg"
	    class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="dbObjectMsg"
	    class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="sqlMsg"
	    class="oracle.sysman.db.rsc.inst.SQLMsg"/>

  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
          <db:form name="foo" method="GET" destinationBinding="formDest@servletRequest"
                   copyParams="target,type,task_id,objectId,taskUser,backURL,processBackURL,advisoryCentralURL,dbPageNum">
      <uix:formValue name="taskName" valueBinding="taskName@sresultObj@servletRequest" />
      <uix:formValue name="execID" valueBinding="advisorexecId@sresultObj@servletRequest" />
      <uix:formValue name="planType" value="original" />
      <uix:pageLayout titleBinding="header@servletRequest">
        <%@ include file="/database/global.jspf" %>

        <uix:contents>

          <oem:messageBox messageType="error"
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

          <oem:messageBox messageType="info"
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>

<%-- REFRESH --%>
<%-- uix:tableLayout width="100%" cellSpacing="2">
<uix:rowLayout hAlign="right">
  <uix:cellFormat>
    <uix:rowLayout>
      <uix:styledText styleClass="OraInlineInfoText"
           textBinding="RST_REFRESH_DESC@sqlMsg"/>
      <uix:spacer width="3"/>
      <uix:styledText styleClass="OraInlineInfoText"
           textBinding="lastUpdatedTime@sresultObj@servletRequest"/>
      <uix:image sourceBinding="refreshImage@servletRequest"
	   destinationBinding="refreshD@servletRequest" />
    </uix:rowLayout>
  </uix:cellFormat>
</uix:rowLayout>
</uix:tableLayout --%>


<uix:styledText styleClass="OraPromptText" textBinding="SRT_DESCRIPTION@sqlMsg" renderedBinding="showDescription@servletRequest"/>
<%--
              <uix:labeledFieldLayout columns="1">

                <uix:styledText styleClass="OraPromptText" textBinding="SS_PLAN_HASH_VALUE@sqlMsg"/>
                <uix:styledText styleClass="OraDataText" textBinding="planHashValue@sresultObj@servletRequest"/>

                <uix:styledText styleClass="OraPromptText" textBinding="OPM_STATUS@sqlMsg"/>
                <uix:styledText styleClass="OraDataText" textBinding="taskStatus@sresultObj@servletRequest"/>

                <uix:styledText styleClass="OraPromptText" textBinding="COMPLETED_CONTEXT@sqlMsg"/>
                <uix:styledText styleClass="OraDataText" textBinding="taskCompletedTime@sresultObj@servletRequest"/>

              </uix:labeledFieldLayout>

--%>
              <uix:header textBinding="SRT_SQL_TEXT@sqlMsg">
                <%-- db:sqlDisplay sqlListBinding="sqlList@servletRequest"/ --%>

                <uix:link textBinding="displaySQLText@sresultObj@servletRequest" destinationBinding="sqlUrl@servletRequest" />
              </uix:header>

              <uix:header textBinding="SRT_RECOMMENDATIONS@sqlMsg">


            <uix:tableLayout  width="100%">
   
            <uix:rowLayout hAlign="left">
              <uix:submitButton textBinding="ORIGINAL_EXPLAIN_PLAN@sqlMsg"
                                name="event" value="origPlan" 
                                renderedBinding="originalPlanAvailable@sresultObj@servletRequest" />
            </uix:rowLayout>
                  <uix:rowLayout>
                      <uix:spacer height="5"/>
                  </uix:rowLayout>

            </uix:tableLayout>


            <uix:switcher childNameBinding="dbVersionGTE112@servletRequest" >
            <uix:case name="true">
                <uix:table name="recomTable"  id="recomTable"
                            formSubmitted="true"
                           showAll="yes" width="100%"
                           alternateTextBinding="NO_RECOMMENDATION@sqlMsg"
                            tableDataBinding="tabData@uixRecomTable@servletRequest"
                            summaryBinding="SRT_RECOMMENDATIONS@sqlMsg"
                >
                
                  <uix:tableSelection>
                    <uix:singleSelection shortDescBinding="SELECT@dbMsg"
                        selectedIndex="0">
                      <uix:submitButton textBinding="SRT_IMPLEMENT@sqlMsg" name="event" value="implement" renderedBinding="couldImplement@servletRequest"/>
                    </uix:singleSelection>
                  </uix:tableSelection>
                
                  <uix:tableFormat tableBanding="noBanding"/>

                    <uix:column>
                       <uix:columnHeader>
                           <uix:styledText textBinding="SRT_COL_TYPE@sqlMsg" /> 
                       </uix:columnHeader>
                       <uix:text textBinding="type" />
                    </uix:column>
                    
                    <uix:column>
                        <uix:columnHeader>
                           <uix:styledText textBinding="SRT_COL_FINDINGS@sqlMsg" />
                        </uix:columnHeader>
                        <uix:stackLayout>
                            <uix:contents childDataBinding="findings">
                             <uix:flowLayout>  
                             <uix:formValue name="couldImpl" valueBinding="couldImpl" />
                                <uix:switcher childNameBinding="typeNum">
                                <uix:case name="6">
                                    <uix:link destinationBinding="origPlanUrl" textBinding="finding" />
                                </uix:case>
                                <uix:case name="2">
                                    <uix:styledText styleClass="OraPromptText" textBinding="finding" renderedBinding="canRender"/>
                                </uix:case>
                                <uix:default>
                                    <uix:styledText styleClass="OraPromptText" textBinding="finding" />
                                </uix:default>
                                </uix:switcher>
                                </uix:flowLayout>
                            </uix:contents>
                        </uix:stackLayout>
                    </uix:column>
                    
                    <uix:column useSeparateRows="true">
                       <uix:columnHeader>
                           <uix:styledText textBinding="RST_RECOMMENDATIONS@sqlMsg" />
                       </uix:columnHeader>
                           <uix:contents childDataBinding="recoms">
                                <uix:stackLayout>
                                    <uix:flowLayout>
                                    <uix:contents childDataBinding="recomsData">
                                    <uix:formValue name="recomType" valueBinding="command"/>
                                    <uix:formValue name="actionID" valueBinding="actionID"/>
                                    <uix:switcher childNameBinding="hasRowSpan">
                                    <uix:case name="true">
                                    <uix:radioButton id="hindSet" name="hindSet" 
                                                    valueBinding="value" selectedBinding="selected"/>
                                    </uix:case>
                                    </uix:switcher>
                                        <uix:styledText textBinding="recomMsg" />
                                        <uix:styledText textBinding="recomText" />
                                    </uix:contents>
                                    </uix:flowLayout>
                                </uix:stackLayout>
                           </uix:contents>
                    </uix:column>
                    
                    <uix:column useSeparateRows="true">
                       <uix:columnHeader>
                           <uix:styledText textBinding="SRT_COL_RATIONALE@sqlMsg" />
                       </uix:columnHeader>
                       <uix:contents childDataBinding="rationals">
                            <uix:stackLayout>
                                <uix:contents childDataBinding="rationalsData">
                                    <uix:styledText textBinding="rationalMsg" />
                                </uix:contents>
                            </uix:stackLayout>
                       </uix:contents>
                    </uix:column>
                    
                    <uix:column useSeparateRows="true">
                        <uix:columnFormat columnDataFormat="numberFormat" /> 
                       <uix:columnHeader>
                           <uix:styledText textBinding="BENEFIT@sqlMsg" />
                       </uix:columnHeader>
                       <uix:contents childDataBinding="benefits">
                            <uix:text textBinding="benefitsData" />
                       </uix:contents>
                        
                    </uix:column>
                    
                    <uix:column useSeparateRows="true">
                       <uix:columnHeader>
                           <uix:styledText textBinding="SRT_COL_OTHER_STATISTICS@sqlMsg" />
                       </uix:columnHeader>
                       <uix:contents childDataBinding="otherStats">
                            <uix:image shortDescBinding="SRT_COL_OTHER_STATISTICS@sqlMsg" sourceBinding="otherStatIcon" destinationBinding="otherStatUrl" />
                       </uix:contents>
                    </uix:column>
                    
                    <uix:column useSeparateRows="true">
                       <uix:columnHeader>
                           <uix:styledText textBinding="SRT_COL_NEW_EXPLAIN_PLAN@sqlMsg" />
                       </uix:columnHeader>
                       <uix:contents childDataBinding="newPlan">
                            <uix:image shortDescBinding="SRT_COL_NEW_EXPLAIN_PLAN@sqlMsg" sourceBinding="newPlanIcon" destinationBinding="newPlanUrl" />
                       </uix:contents>
                    </uix:column>
                    
                    <uix:column useSeparateRows="true">
                       <uix:columnHeader>
                           <uix:styledText textBinding="SRT_COL_COMPARE_EXPLAIN_PLANS@sqlMsg" />
                       </uix:columnHeader>
                       <uix:contents childDataBinding="comparePlan">
                       <uix:flowLayout>
                            <uix:image shortDescBinding="SRT_COL_COMPARE_EXPLAIN_PLANS@sqlMsg" sourceBinding="compPlanIcon" destinationBinding="compPlanUrl" />
                            <uix:formValue name="planHashValue" valueBinding="compPlanHash" />
                       </uix:flowLayout>
                       </uix:contents>
                    </uix:column>
                    

                </uix:table>
                </uix:case>
                <uix:default>
                <oem:table name="recomTable" width="100%"
                           summaryBinding="SRT_RECOMMENDATIONS@sqlMsg"
                           dataSourceBinding="recomTable@servletRequest">
                  <uix:tableSelection>
                    <oem:singleSelection shortDescBinding="SELECT@dbMsg"
                        selectedIndex="0">
                      <uix:submitButton textBinding="SRT_IMPLEMENT@sqlMsg" name="event" value="implement" renderedBinding="couldImplement@servletRequest"/>
                    </oem:singleSelection>
                  </uix:tableSelection>
                  <uix:tableFormat tableBanding="noBanding"/>
                </oem:table>
                </uix:default>
                </uix:switcher>
              </uix:header>

        </uix:contents>

        <uix:pageButtons>
          <uix:pageButtonBar>
               <uix:submitButton textBinding="RETURN@dbObjectMsg"
                                name="event" value="cancelStmtResult"/>
          </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
