<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="dbBundle"
              class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="sqlMsgBundle"
              class="oracle.sysman.db.rsc.inst.SQLMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf"%>
    <%@ include file="/oemTitle.jspf"%>
    <uix:body>
      <uix:pageLayout>
        <%@ include file="/database/global.jspf"%>
        <oem:messageBox 
            messageType="info" 
            errorTableBinding="info@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
        <oem:messageBox 
            messageType="error" 
            errorTableBinding="errors@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
        <db:form name="foo" method="POST"
                 destination="/console/database/instance/storedOutlines"
                 copyParams="target,type">
          <uix:formValue 
            name="pageName" 
            value="/database/instance/storedOutlines/migrateConfirm"/>
          
                 
          <uix:header textBinding="MIGRATE_CONFIRM_PAGE_HEADER@sqlMsgBundle">
            <uix:styledText styleClass="OraInstructionText" textBinding="pageInstructionText@migrateConfirmPageBean@servletRequest" />
            <uix:tableLayout width="100%" cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:submitButton textBinding="BACK@dbBundle" name="event"
                                    value="back"/>
                  <uix:spacer width="10" />
                  <uix:submitButton textBinding="SUBMIT@sqlMsgBundle" name="event"
                                    value="submit"/>
                </uix:cellFormat>
              
              </uix:rowLayout>
            </uix:tableLayout>
            <uix:hideShowHeader textBinding="PREVIEW@sqlMsgBundle" 
                                disclosedBinding="hideShow@migrateConfirmPageBean@servletRequest">
              <uix:stackLayout>
                <uix:styledText styleClass="OraInstructionText" textBinding="PREVIEW_TABLE_INSTR_TEXT@sqlMsgBundle" />
                <uix:spacer height="5"/>
                <uix:table name="confirmPreview"
                           width="100%"
                           tableDataBinding="outlinePreviewTableData@migrateConfirmPageBean@servletRequest"
                           formSubmitted="true"
                           alternateTextBinding="NO_STORED_OUTLINES@sqlMsgBundle">
                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="NAME@dbBundle"/>
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:styledText styleClass="OraText" textBinding="name"/>
                    </uix:contents>
                  </uix:column>  
                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="HDR_SQL_TEXT@dbBundle"/>
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:styledText styleClass="OraText" textBinding="sqlText"/>
                    </uix:contents>
                  </uix:column>  
                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="CATEGORY@sqlMsgBundle" />
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:styledText styleClass="OraText" textBinding="category"/>
                    </uix:contents>
                  </uix:column> 
                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="VERSION@sqlMsgBundle" />
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:styledText styleClass="OraText" textBinding="version"/>
                    </uix:contents>
                  </uix:column> 
                    <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="USED@sqlMsgBundle" />
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:styledText styleClass="OraText" textBinding="used"/>
                    </uix:contents>
                  </uix:column> 
                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="ENABLED@sqlMsgBundle" />
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:styledText styleClass="OraText" textBinding="enabled"/>
                    </uix:contents>
                  </uix:column> 
                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="CREATED@sqlMsgBundle" />
                    </uix:columnHeader>
                    <uix:contents>
                      <uix:styledText styleClass="OraText" textBinding="created"/>
                    </uix:contents>
                  </uix:column> 
                </uix:table>
                <uix:spacer height="5"/>

                <uix:tip textBinding="MIGRATE_CONFIRM_TIP_2@sqlMsgBundle" />
              </uix:stackLayout>
            </uix:hideShowHeader>
             <%@ include file="/database/instance/simpleSchedule.jspf" %>
          </uix:header>
        </db:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
