<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="dbBundle" class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="sqlMsgBundle" class="oracle.sysman.db.rsc.inst.SQLMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf"%>
    <%@ include file="/oemTitle.jspf"%>
    <uix:body>
      <uix:pageLayout>
        <%@ include file="/database/global.jspf"%>
        <oem:messageBox 
            messageType="info" 
            errorTableBinding="info@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
        <oem:messageBox 
            messageType="error" 
            errorTableBinding="errors@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
        <db:form name="foo" method="POST"
                 destination="/console/database/instance/storedOutlines"
                 copyParams="target,type">
          <uix:header textBinding="MIGRATE_REPORT_PAGE_HEADER@sqlMsgBundle">
            <uix:stackLayout>
              <uix:tableLayout width="100%">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:submitButton textBinding="OK@dbBundle"
                                  name="event" value="reportOk"/>
                    <uix:spacer width="5"/>
                    <uix:submitButton textBinding="SAVE_TO_FILE@dbBundle"
                                  name="event" value="saveToFile"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
              <uix:spacer height="10"/>
              <uix:rawText styleClass="OraText" textBinding="migrateReport@storedOutlinesBean@servletRequest"/>
            </uix:stackLayout>
          </uix:header>
        </db:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>