<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="dbBundle" class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="sqlMsgBundle" class="oracle.sysman.db.rsc.inst.SQLMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf"%>
    <%@ include file="/oemTitle.jspf"%>
    <uix:body>
      <uix:pageLayout>
        <%@ include file="/database/global.jspf"%>
        <db:form name="foo" method="POST"
                 destination="/console/database/instance/storedOutlines"
                 copyParams="target,type">
          <uix:header textBinding="OUTLINE_DETAILS_PAGE_HEADER@sqlMsgBundle">
            <uix:tableLayout width="100%" cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:submitButton textBinding="BACK@dbBundle" name="event"
                                    value="back"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
            <uix:labeledFieldLayout>
              <uix:messageStyledText styleClass="OraDataText"
                                     promptBinding="NAME@dbBundle"
                                     textBinding="name@selectedOutline@servletRequest"/>
              <uix:spacer height="5"/>
              <uix:messageStyledText styleClass="OraDataText"
                                     promptBinding="OWNER@sqlMsgBundle"
                                     textBinding="owner@selectedOutline@servletRequest"/>
              <uix:spacer height="5"/>
              <uix:messageStyledText styleClass="OraDataText"
                                     promptBinding="CATEGORY@sqlMsgBundle"
                                     textBinding="category@selectedOutline@servletRequest"/>
              <uix:spacer height="5"/>
              <uix:messageStyledText styleClass="OraDataText"
                                     promptBinding="VERSION@sqlMsgBundle"
                                     textBinding="version@selectedOutline@servletRequest"/>   
              <uix:spacer height="5"/>
              <uix:messageStyledText styleClass="OraDataText"
                                     promptBinding="FORMAT@sqlMsgBundle"
                                     textBinding="format@selectedOutline@servletRequest"/> 
              <uix:spacer height="5"/>
              <uix:messageStyledText styleClass="OraDataText"
                                     promptBinding="COMPATIBLE@sqlMsgBundle"
                                     textBinding="compatible@selectedOutline@servletRequest"/> 
              <uix:spacer height="5"/>
              <uix:messageStyledText styleClass="OraDataText"
                                     promptBinding="SIGNATURE@sqlMsgBundle"
                                     textBinding="signature@selectedOutline@servletRequest"/> 
              <uix:spacer height="5"/>
              <uix:messageStyledText styleClass="OraDataText"
                                     promptBinding="USED@sqlMsgBundle"
                                     textBinding="used@selectedOutline@servletRequest"/> 
              <uix:spacer height="5"/>
              <uix:messageStyledText styleClass="OraDataText"
                                     promptBinding="ENABLED@sqlMsgBundle"
                                     textBinding="enabled@selectedOutline@servletRequest"/> 
              <uix:spacer height="5"/>
              <uix:messageStyledText styleClass="OraDataText"
                                     promptBinding="CREATED@sqlMsgBundle"
                                     textBinding="created@selectedOutline@servletRequest"/> 
                                     
              <uix:spacer height="10"/>
              
                
                      
            </uix:labeledFieldLayout>
            
            <uix:header textBinding="OPM_SQL_TEXT@sqlMsgBundle"> 
                <db:sqlDisplay sqlListBinding="sqlDisplay@selectedOutline@servletRequest" />
                <%--uix:messageTextInput name="sqlText" readOnly="true" promptBinding="OPM_SQL_TEXT@sqlMsgBundle" 
                        columns="70"  textBinding="sqlText@selectedOutline@servletRequest" /--%>
            </uix:header>
          </uix:header>
        </db:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>