<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="dbBundle"
              class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="sqlMsgBundle"
              class="oracle.sysman.db.rsc.inst.SQLMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf"%>
    <%@ include file="/oemTitle.jspf"%>
    <db:script src="/database/LOV.js"/>
    <uix:body>
      <uix:pageLayout>
        <%@ include file="/database/global.jspf"%>
       
         <oem:messageBox 
            messageType="info" 
            errorTableBinding="info@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
          <oem:messageBox 
            messageType="error" 
            errorTableBinding="errors@servletRequest"
            titleTextKey="titleText" 
            mainTextKey="mainText"/>
       
        <db:form name="foo" method="POST"
                 destination="storedOutlines"
                 copyParams="target,type">
          
          <uix:formValue 
            name="pageName" 
            value="/database/instance/storedOutlines/searchMigrate"/>
          
          <uix:header textBinding="MIGRATE_SEARCH_PAGE_HEADER@sqlMsgBundle">
            <%-- Buttons on top of the page--%>
            <uix:tableLayout width="100%" cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:submitButton textBinding="CANCEL@dbBundle" name="event" value="cancel"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
            <%-- Bulk Migrate--%>
            <uix:header textBinding="BULK_MIGRATE@sqlMsgBundle">
              <uix:stackLayout>
                <uix:contents childDataBinding="bulkMigrateOptions@searchMigratePageBean@servletRequest">
                  <uix:rowLayout>
                    <uix:radioButton name="bulkAttribute" textBinding="text" valueBinding="value"
                                   selectedBinding="selected" />
                    <uix:spacer width="10" />
                    <uix:choice name="bulkValue" id="bulkValue"  
                                renderedBinding="hasChoice"
                                selectedValueBinding="bulkValue@searchMigratePageBean@servletRequest">
                
                      <uix:contents childDataBinding="categories@searchMigratePageBean@servletRequest">
                        <uix:option textBinding="text" valueBinding="value"/>
                      </uix:contents>
                    </uix:choice>
                  </uix:rowLayout>
                  <uix:spacer height="5" />
                </uix:contents>
              </uix:stackLayout>
              <uix:spacer height="10" />
              <uix:rowLayout>
                <uix:submitButton textBinding="MIGRATE@sqlMsgBundle" name="event" value="bulkMigrate"/>  
              </uix:rowLayout>
            </uix:header>
            <uix:spacer height="20" />
            <uix:header textBinding="SEARCH_AND_MIGRATE@sqlMsgBundle">
              <uix:stackLayout>
                <uix:styledText styleClass="OraInstructionText" textBinding="SEARCH_MIGRATE_INSTR_TEXT@sqlMsgBundle" />
                
                <uix:spacer height="10" />
                
                <uix:labeledFieldLayout columns="1" labelWidth="0%" fieldWidth="0%" width="40%">
                  <%--Category --%>
                  <uix:messageChoice promptBinding="CATEGORY@sqlMsgBundle" name="searchCategory" id="searchCategory"
                                     selectedValueBinding="searchCategory@searchMigratePageBean@servletRequest">
                    <uix:contents childDataBinding="categories@searchMigratePageBean@servletRequest">
                      <uix:option textBinding="text" valueBinding="value"/>
                    </uix:contents>
                  </uix:messageChoice>
                 
                  <%-- Name --%>
                  <uix:messageLovField promptBinding="NAME@dbBundle" name="searchName" shortDescBinding="NAME@dbBundle"
                                id="searchName" textBinding="searchName@searchMigratePageBean@servletRequest" columns="30"
                                onClick="startLov('searchName', 'ListOutlines')"/>
               
                  <%-- SQL Text --%>
                  <uix:messageTextInput name="searchSql" tipBinding="OPM_SEARCH_TIP@sqlMsgBundle" promptBinding="OPM_SQL_TEXT@sqlMsgBundle" 
                        columns="30" rows="5" textBinding="searchSql@searchMigratePageBean@servletRequest"/>
                
                  <%-- Go Button --%>
                  <uix:submitButton textBinding="GO@sqlMsgBundle" name="event" value="previewMigrate"/>   
                
                </uix:labeledFieldLayout>
                
                <uix:spacer height="10" />
                
                <uix:tableLayout width="100%" cellSpacing="5">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:submitButton textBinding="MIGRATE_ALL_MATCHES@sqlMsgBundle" name="event" value="migrateAllMatches"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
                
                <uix:table id="searchedOutlines"
                           width="100%"
                           maxValueBinding="tableMaxValue@searchMigratePageBean@servletRequest"
                           valueBinding="tableStartIndex@searchMigratePageBean@servletRequest"
                           blockSize="25"
                           showAll="yes"
                           tableDataBinding="searchedOutlines@searchMigratePageBean@servletRequest"
                           formSubmitted="true"
                           columnHeaderDataBinding="searchedOutlinesHeaders@searchMigratePageBean@servletRequest"
                           alternateTextBinding="NO_STORED_OUTLINES@sqlMsgBundle">

                  <uix:tableFormat tableBanding="rowBanding"/>
                  
                  <uix:tableSelection>
                    <uix:multipleSelection selectedBinding="selected" shortDescBinding="SELECTED@sqlMsgBundle" selectionBinding="selection@searchMigratePageBean@servletRequest">
                      <uix:submitButton textBinding="MIGRATE@sqlMsgBundle" name="event" value="migrateSelected" />
                    </uix:multipleSelection>
                  </uix:tableSelection>
                  
                  <uix:columnHeaderStamp>
                    <uix:sortableHeader textBinding="text" sortableBinding="sortable" />
                  </uix:columnHeaderStamp>
                  
                  <uix:contents>
                      <uix:styledText textBinding="name" />
                      <uix:link textBinding="sqlTextShort" destinationBinding="sqlLinkDestination" shortDescBinding="sqlText" />
                      <%--uix:styledText textBinding="sqlText"/--%>
                      <uix:styledText textBinding="category"/>
                      <uix:styledText textBinding="version"/>
                      <uix:styledText textBinding="used"/>
                      <uix:styledText textBinding="enabled"/>
                      <uix:styledText textBinding="created"/>
                  </uix:contents>
                  
                </uix:table>
                  
              </uix:stackLayout>
            
            </uix:header>
          </uix:header>
        </db:form>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
