<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="HDMMsg"
	    class="oracle.sysman.db.rsc.inst.HDMMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>

        <uix:header textBinding="ICON_LEGEND_HEADER@HDMMsg" messageType="info">
         <uix:rowLayout>
           <uix:spacer width="15"/>
           <uix:styledText styleClass="OraInstructionTextStrong"
                           textBinding="ICON_LEGEND_TEXT@HDMMsg"/>
         </uix:rowLayout>

           <uix:tableLayout  cellSpacing="5">
             <uix:rowLayout vAlign="top">
               <uix:cellFormat hAlign="left">
                <uix:contents>

                 <uix:header textBinding="ADDM_SECTION@HDMMsg">
                  <uix:tableLayout cellSpacing="8">

                   <uix:rowLayout hAlign="left">
                     <uix:image sourceBinding="taskWithFindingsImage@servletRequest" />
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="ADDM_TASK_WITH_FINDINGS@HDMMsg"/>
                   </uix:rowLayout>
		    
		    <uix:rowLayout hAlign="left">
                     <uix:image sourceBinding="selectedTaskWithFindingsImage@servletRequest" />
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="SELECTED_ADDM_TASK_WITH_FINDINGS@HDMMsg"/>
                   </uix:rowLayout>
		    
		    <uix:rowLayout hAlign="left">
                     <uix:image sourceBinding="taskWithNoFindingsImage@servletRequest" />
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="ADDM_TASK_WITH_NO_FINDINGS@HDMMsg"/>
                   </uix:rowLayout>
		    
		    <uix:rowLayout hAlign="left">
                     <uix:image sourceBinding="selectedTaskWithNoFindingsImage@servletRequest" />
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="SELECTED_ADDM_TASK_WITH_NO_FINDINGS@HDMMsg"/>
                   </uix:rowLayout>

		    <uix:rowLayout hAlign="left">
                     <uix:image sourceBinding="taskWithErrorsImage@servletRequest" />
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="ADDM_TASK_WITH_ERRORS@HDMMsg"/>
                   </uix:rowLayout>
		    
		    <uix:rowLayout hAlign="left">
                     <uix:image sourceBinding="selectedTaskWithErrorsImage@servletRequest" />
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="SELECTED_ADDM_TASK_WITH_ERRORS@HDMMsg"/>
                   </uix:rowLayout>		                      

                  </uix:tableLayout>
                 </uix:header>

                 <spacer width="10"/>


                 <uix:header textBinding="SNAPSHOT_SECTION@HDMMsg">
                  <uix:tableLayout cellSpacing="8">

                   <uix:rowLayout>
                     <uix:image sourceBinding="snapshotImage@servletRequest"/>
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="SNAPSHOT@HDMMsg"/>
                   </uix:rowLayout>



                   <uix:rowLayout>
                     <uix:image sourceBinding="startSnapshotImage@servletRequest"/>
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="START_SNAPSHOT@HDMMsg"/>
                   </uix:rowLayout>

		      <uix:rowLayout>
                     <uix:image sourceBinding="endSnapshotImage@servletRequest"/>
                     <uix:styledText styleClass="OraInstructionText"
                                   textBinding="END_SNAPSHOT@HDMMsg"/>
                   </uix:rowLayout>

		     
                   
                  </uix:tableLayout>
                 </uix:header>

                </uix:contents>
               </uix:cellFormat>
             </uix:rowLayout>

             


           </uix:tableLayout>

        </uix:header>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

