<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>


  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <uix:pageLayout>
    <%@ include file="/database/global.jspf" %>
    
    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>                

    <db:form name="foo" method="get" destination="/console/database/instance/ashReport"
      copyParams="target,type">

    <uix:header textBinding="header@defaultBean@servletRequest">
    
    
  <uix:tableLayout width="100%" >
    <uix:rowLayout hAlign="right" vAlign="top">
      <uix:cellFormat hAlign="left">
          <uix:styledText styleClass="OraFieldText"
            textBinding="SPECIFY_REPORT_TIMES@DBMsgBundle@servletRequest" />
         </uix:cellFormat>
        <uix:cellFormat>
          <uix:flowLayout>
            <uix:submitButton textBinding="SP_RTF_GENERATE@DBMsgBundle@servletRequest" 
              name="event" value="createReport"/>         
          </uix:flowLayout>
        </uix:cellFormat>
      </uix:rowLayout>
    </uix:tableLayout>

    <uix:spacer height="10" />

    <uix:tableLayout width="100%">
    
    <uix:cellFormat width="50%" >
      <uix:tableLayout cellSpacing="2" >
        <uix:cellFormat hAlign="left" vAlign="top" columnSpan="2"> 
          <uix:messageDateField name="startDate" id="startDate"
           columns="15" valueBinding="startDate@defaultBean@servletRequest"
           tipBinding="exampleDate@defaultBean@servletRequest"
           promptBinding="START_DATE@SDKBundle@servletRequest" 
           maxValueBinding="currentDate@defaultBean@servletRequest" >
            <uix:onSubmitValidater>
              <uix:date dateStyle="short"/>
            </uix:onSubmitValidater>
          </uix:messageDateField>
        </uix:cellFormat>

      <uix:rowLayout>
        <uix:spacer height="10" />
      </uix:rowLayout>
    
     <uix:rowLayout>
      <uix:messagePrompt promptBinding="START_TIME@SDKBundle@servletRequest" />
      <uix:cellFormat hAlign="left" vAlign="top"> 
      <uix:spacer width="5" />
		  <oem:choice
		     name="startTimeHour"
         shortDescBinding="START_TIME@SDKBundle@servletRequest"
		     optionsBinding="hoursListSource@defaultBean@servletRequest" 
		     selectedValueBinding="startTimeHour@defaultBean@servletRequest" />
		  <oem:choice
		     name="startTimeMinute"
         shortDescBinding="START_TIME@SDKBundle@servletRequest"
		     optionsBinding="minutesListSource@defaultBean@servletRequest" 
		     selectedValueBinding="startTimeMinute@defaultBean@servletRequest" />
        <oem:radioButton name="startTimeAmPm" value="am"
                           selectedValueBinding="startTimeAmPm@defaultBean@servletRequest"
                           textBinding="AM_LABEL@SDKBundle@servletRequest"
                           styleClass="OraInstructionText" />
        <oem:radioButton name="startTimeAmPm" value="pm"
                           selectedValueBinding="startTimeAmPm@defaultBean@servletRequest"
                           textBinding="PM_LABEL@SDKBundle@servletRequest"
                           styleClass="OraInstructionText" />
      </uix:cellFormat>
   </uix:rowLayout>
  </uix:tableLayout>
  </uix:cellFormat>
  
  <uix:cellFormat width="50%" >
    <uix:tableLayout cellSpacing="2" >
      <uix:cellFormat hAlign="left" vAlign="top" columnSpan="2"> 
        <uix:messageDateField name="endDate" id="endDate"
         columns="15" valueBinding="endDate@defaultBean@servletRequest"
         tipBinding="exampleDate@defaultBean@servletRequest"
         promptBinding="END_DATE@SDKBundle@servletRequest" 
         maxValueBinding="currentDate@defaultBean@servletRequest" >
          <uix:onSubmitValidater>
            <uix:date dateStyle="short"/>
          </uix:onSubmitValidater>
        </uix:messageDateField>
      </uix:cellFormat>

      <uix:rowLayout>
        <uix:spacer height="10" />
      </uix:rowLayout>
          
     <uix:rowLayout>
      <uix:messagePrompt promptBinding="END_TIME@SDKBundle@servletRequest" />
      <uix:cellFormat hAlign="left" vAlign="top"> 
      <uix:spacer width="5" />
		  <oem:choice
		     name="endTimeHour"
         shortDescBinding="END_TIME@SDKBundle@servletRequest"
		     optionsBinding="hoursListSource@defaultBean@servletRequest" 
		     selectedValueBinding="endTimeHour@defaultBean@servletRequest" />
		  <oem:choice
		     name="endTimeMinute"
         shortDescBinding="END_TIME@SDKBundle@servletRequest"
		     optionsBinding="minutesListSource@defaultBean@servletRequest" 
		     selectedValueBinding="endTimeMinute@defaultBean@servletRequest" />
        <oem:radioButton name="endTimeAmPm" value="am"
                           selectedValueBinding="endTimeAmPm@defaultBean@servletRequest"
                           textBinding="AM_LABEL@SDKBundle@servletRequest"
                           styleClass="OraInstructionText" />
        <oem:radioButton name="endTimeAmPm" value="pm"
                           selectedValueBinding="endTimeAmPm@defaultBean@servletRequest"
                           textBinding="PM_LABEL@SDKBundle@servletRequest"
                           styleClass="OraInstructionText" />
      </uix:cellFormat>
   </uix:rowLayout>
  </uix:tableLayout>
  </uix:cellFormat>


    <uix:tableLayout cellSpacing="2" >
    <uix:spacer height="15" />
     <uix:rowLayout hAlign="left">

      <uix:styledText styleClass="OraPromptText"
        labeledNodeId="FilterLabel"
        textBinding="FILTER@DBMsgBundle@servletRequest"/>
      <uix:spacer width="8"/>
      <uix:cellFormat hAlign="left" wrappingDisabled="true">
        <uix:choice name="searchCriteria" 
        id="FilterLabel"
        selectedValueBinding="searchCriteria@defaultBean@servletRequest" >
        
          <uix:option textBinding="TS_SID@DBMsgBundle@servletRequest"
            value="TS_SID" />
          <uix:option textBinding="SQL_ID@DBMsgBundle@servletRequest"
            value="SQL_ID" />
          <uix:option textBinding="WAIT_CLASS@DBMsgBundle@servletRequest"
            value="WAIT_CLASS" />
          <uix:option textBinding="SERVICE@DBMsgBundle@servletRequest"
            value="SERVICE" />
          <uix:option textBinding="MODULE@DBMsgBundle@servletRequest"
            value="MODULE" />
          <uix:option textBinding="ACTION@DBMsgBundle@servletRequest"
            value="ACTION" />
          <uix:option textBinding="CLIENT@DBMsgBundle@servletRequest"
            value="CLIENT" />

        </uix:choice>
      
      </uix:cellFormat>
      
      <uix:spacer width="8"/>
      
      <uix:textInput name="searchString" columns="30" 
        shortDescBinding="FILTER@DBMsgBundle@servletRequest"
        textBinding="searchString@defaultBean@servletRequest" />
        

    </uix:rowLayout>
  </uix:tableLayout>
      
      
    
    <uix:header textBinding="REPORT_RESULTS@DBMsgBundle@servletRequest" 
                renderedBinding="showReport@defaultBean@servletRequest" >

    <uix:tableLayout width="100%" renderedBinding="showReport@defaultBean@servletRequest">
      <uix:rowLayout hAlign="right">  
        <uix:submitButton textBinding="SAVE_TO_FILE@DBMsgBundle@servletRequest" 
            name="event" value="saveToFile" />
       </uix:rowLayout>
    </uix:tableLayout>


   <uix:tableLayout width="100%" renderedBinding="showReport@defaultBean@servletRequest" >
      <uix:rawText textBinding="ashReport@defaultBean@servletRequest" /> 
    </uix:tableLayout>

    </uix:header>

    </uix:tableLayout>
    </uix:header>

    </db:form>    
    </uix:pageLayout>
    </uix:body>

  </uix:document>
</uix:renderingContext>

