<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>


  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" method="POST" destination="/console/database/instance/swrfBaselines"
      copyParams="target,type">

    <uix:pageLayout>
    <%@ include file="/database/global.jspf" %>

    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>     

    <uix:header textBinding="CREATE_STS@DBMsgBundle@servletRequest">
    
    
      <uix:labeledFieldLayout fieldWidth="100%" labelWidth="0" columns="1" >
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt promptBinding="BASELINE_ID@DBMsgBundle@servletRequest" />
        </uix:cellFormat>
        <uix:styledText styleClass="OraDataText" 
          textBinding="baselineID@baselinesBean@servletRequest" />
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt promptBinding="NAME@DBMsgBundle@servletRequest" />
        </uix:cellFormat>
        <uix:styledText styleClass="OraDataText" 
          textBinding="baselineName@baselinesBean@servletRequest" />
        <uix:cellFormat wrappingDisabled="true" hAlign="right">  
          <uix:messagePrompt promptBinding="BEGIN_SNAP_ID@DBMsgBundle@servletRequest" />
        </uix:cellFormat>
        <uix:styledText styleClass="OraDataText" 
          textBinding="beginSnapshotID@baselinesBean@servletRequest" />
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt promptBinding="BEGIN_SNAP_CAPTURE_TIME@DBMsgBundle@servletRequest" />
        </uix:cellFormat>
        <uix:styledText styleClass="OraDataText" 
          textBinding="beginSnapshotTime@baselinesBean@servletRequest" />
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt promptBinding="END_SNAP_ID@DBMsgBundle@servletRequest" />
        </uix:cellFormat>
        <uix:styledText styleClass="OraDataText" 
          textBinding="endSnapshotID@baselinesBean@servletRequest" />
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt promptBinding="END_SNAP_CAPTURE_TIME@DBMsgBundle@servletRequest" />
        </uix:cellFormat>
        <uix:styledText styleClass="OraDataText" 
          textBinding="endSnapshotTime@baselinesBean@servletRequest" />
            
     </uix:labeledFieldLayout>

      <uix:spacer height="30" />


      <uix:labeledFieldLayout labelWidth="0" fieldWidth="100%" columns="1">
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt promptBinding="NAME@DBMsgBundle@servletRequest" 
             labeledNodeId="stsNameId"
             required="yes"  />
        </uix:cellFormat>
           <uix:textInput name="stsName" id="stsNameId"
            textBinding="stsName@baselinesBean@servletRequest" />
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt promptBinding="DESCRIPTION@DBMsgBundle@servletRequest" 
            labeledNodeId="stsDescId"  />
        </uix:cellFormat>
           <uix:textInput name="description" id="stsDescId"
            textBinding="description@baselinesBean@servletRequest"  />
     </uix:labeledFieldLayout>

     
    </uix:header>

        <uix:pageButtons>
        <uix:pageButtonBar>
         <uix:flowLayout >
            <uix:button textBinding="CANCEL@DBMsgBundle@servletRequest"
              destinationBinding="cancelURL@servletRequest" />
            <uix:submitButton textBinding="OK@DBMsgBundle@servletRequest"
              name="event" 
              value="doCreateSTS"/>
          </uix:flowLayout>
        </uix:pageButtonBar>
        </uix:pageButtons>



    </uix:pageLayout>
    </db:form>    
    </uix:body>

  </uix:document>
</uix:renderingContext>

