<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>


  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <uix:pageLayout>
    <%@ include file="/database/global.jspf" %>
    
    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>                

    <db:form name="foo" method="POST" destination="/console/database/instance/swrfBaselines"
      copyParams="target,type">

    <uix:header textBinding="header@baselinesBean@servletRequest">
    
    <%@ include file="../refreshTime.jspf" %>

      <uix:rowLayout width="100%">
        <uix:cellFormat hAlign="right" vAlign="top" width="100%">
          <uix:submitButton textBinding="CREATE_BASELINE@DBMsgBundle@servletRequest" 
            name="event" value="createBaseline"/>
        </uix:cellFormat>
      </uix:rowLayout>

    
       <uix:tableLayout width="100%" >
          <uix:rowLayout vAlign="top">

            <oem:table name="baselinesUIDataSource"
                       partialRenderMode="self"
                       id="baselinesTable"
                       alternateTextBinding="NO_BASELINES_ALT@DBMsgBundle@servletRequest" 
                       width="100%"
                       dataSourceProp="baselinesUIDataSource"
                       beanKey="baselinesBean"
                       formSubmitted="true"
                       summaryBinding="BASELINES@DBMsgBundle@servletRequest" 
                       blockSize="25">

              <uix:tableSelection >
                <oem:singleSelection 
                  shortDescBinding="SELECT@DBMsgBundle@servletRequest"
                  selectedIndex="0" >

                  <uix:messagePrompt promptBinding="ACTIONS@DBMsgBundle@servletRequest" />

                  <uix:spacer width="10" />

                  <uix:choice name="selectedAction" 
                    shortDescBinding="ACTIONS@DBMsgBundle@servletRequest" >
                    <uix:option textBinding="CREATE_STS@DBMsgBundle@servletRequest"
                      value="CREATE_STS"/>
                    <uix:option textBinding="VIEW_REPORT@DBMsgBundle@servletRequest"
                      value="VIEW_REPORT" />
                    <uix:option textBinding="CREATE_ADDM_TASK@DBMsgBundle@servletRequest"
                      value="CREATE_ADDM_TASK" />
                    <uix:option textBinding="DELETE_BASELINE@DBMsgBundle@servletRequest"
                      value="DELETE_BASELINE" />          
                    <uix:option textBinding="COMPARE@DBMsgBundle@servletRequest"
                      value="COMPARE" />    
                  </uix:choice>

                
                  <uix:submitButton textBinding="GO@DBMsgBundle@servletRequest"
                        name="event" value="chooseAction"/>
                </oem:singleSelection>
              </uix:tableSelection>
            </oem:table>


          </uix:rowLayout>
        </uix:tableLayout>




    </uix:header>


    </db:form>    
    </uix:pageLayout>
    </uix:body>

  </uix:document>
</uix:renderingContext>

