<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>


  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <uix:pageLayout>
    <%@ include file="/database/global.jspf" %>
    
    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>                

    <db:form name="foo" method="POST" destination="/console/database/instance/swrfSnapshots"
      copyParams="target,type">

    <uix:header textBinding="header@snapshotsBean@servletRequest">
    <%@ include file="/database/instances.jspf" %>

     <uix:flowLayout>
          <uix:tableLayout width="100%">
            <uix:rowLayout vAlign="top">
            
              <uix:cellFormat hAlign="left" width="60%">
                <uix:styledText styleClass="OraInstructionText"
                  textBinding="SNAPSHOT_DESCRIPTION@DBMsgBundle@servletRequest"/>
              </uix:cellFormat>

               <uix:cellFormat hAlign="right" wrappingDisabled="true" >
                <uix:rowLayout>
                    <uix:styledText styleClass="OraTipText" 
                      textBinding="PAGE_REFRESHED_TIME@SDKBundle@servletRequest"/>
                    <uix:spacer width="5" />  
                    <uix:styledText styleClass="OraTipLabel" 
                      textBinding="refreshTime@servletRequest"/>
                    <uix:spacer width="5" />
                    <uix:button textBinding="REFRESH@SDKBundle@servletRequest"
                        destinationBinding="refreshDest@servletRequest" />
                </uix:rowLayout>
              </uix:cellFormat>
                 
              </uix:rowLayout>
        </uix:tableLayout>
      </uix:flowLayout>


    <uix:header textBinding="SELECT_BEGIN_SNAP@DBMsgBundle@servletRequest" >
    
      <uix:tableLayout>
        <uix:rowLayout hAlign="left">  
          <uix:messagePrompt promptBinding="JUMP_TO_TIME@DBMsgBundle@servletRequest" 
           labeledNodeId="jumpToTime" />
          <uix:spacer width="10" />
          <uix:cellFormat>
            <uix:dateField  name="jumpDate" columns="15" id="jumpToTime"
              valueBinding="jumpDate@snapshotsBean@servletRequest"
              maxValueBinding="currentDate@snapshotsBean@servletRequest" />

            <oem:choice name="jumpTime" 
              shortDescBinding="JUMP_TO_TIME@DBMsgBundle@servletRequest" 
              selectedValueBinding="jumpTime@snapshotsBean@servletRequest"
              optionsBinding="timeValues@snapshotsBean@servletRequest"  />
              
            <uix:submitButton textBinding="GO@DBMsgBundle@servletRequest"
                name="event" value="jumpToTime"/>
              
          </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout hAlign="left">  
            <uix:spacer width="1" />
            <uix:spacer width="1" />
            <uix:styledText styleClass="OraInlineInfoText"
              textBinding="exampleDate@snapshotsBean@servletRequest" />
          </uix:rowLayout>
        </uix:tableLayout>



      <uix:rowLayout width="80%">
        <uix:cellFormat hAlign="right" vAlign="top" width="100%">
          <uix:submitButton textBinding="CREATE@DBMsgBundle@servletRequest" 
            name="event" value="takeSnapshot"/>
        </uix:cellFormat>
      </uix:rowLayout>


            <oem:table name="snapshotsUIDataSource"
                       partialRenderMode="self"
                       id="snapshotsTable"
                       alternateTextBinding="NO_SNAPSHOTS_ALT@DBMsgBundle@servletRequest" 
                       width="80%"
                       dataSourceProp="snapshotsUIDataSource"
                       beanKey="snapshotsBean"
                       formSubmitted="true"
                       summaryBinding="SNAPSHOTS@DBMsgBundle@servletRequest"
                       blockSize="25">

              <uix:tableSelection >
                <oem:singleSelection 
                  selectedIndexBinding="snapshotSelectedIndex@snapshotsBean@servletRequest" 
                  shortDescBinding="SELECT@DBMsgBundle@servletRequest" 
                    >

                  <uix:submitButton name="event" value="deleteSingle"
                    textBinding="DELETE@DBMsgBundle@servletRequest" />
                  <uix:spacer width="10" />
                  <uix:messagePrompt promptBinding="ACTIONS@DBMsgBundle@servletRequest"  />

                  <uix:spacer width="10" />

                  <uix:choice name="selectedAction" 
                    shortDescBinding="ACTIONS@DBMsgBundle@servletRequest" >
                    <uix:option textBinding="CREATE_STS@DBMsgBundle@servletRequest"
                      value="CREATE_STS"/>
                    <uix:option textBinding="VIEW_REPORT@DBMsgBundle@servletRequest"
                      value="VIEW_REPORT"/> 
                    <uix:option textBinding="CREATE_ADDM_TASK@DBMsgBundle@servletRequest"
                      value="CREATE_ADDM_TASK" />
                    <uix:option textBinding="DELETE_SNAPSHOTS@DBMsgBundle@servletRequest"
                      value="DELETE_SNAPSHOTS" />
                    <uix:option textBinding="COMPARE@DBMsgBundle@servletRequest"
                      value="COMPARE" />
                  </uix:choice>

                
                  <uix:submitButton textBinding="GO@DBMsgBundle@servletRequest"
                        name="event" value="chooseAction"/>
                </oem:singleSelection>
              </uix:tableSelection>
            </oem:table>


      </uix:header>

    </uix:header>


    </db:form>    
    </uix:pageLayout>
    </uix:body>

  </uix:document>
</uix:renderingContext>

