<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>


  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" method="POST" destination="/console/database/instance/swrfSnapshots"
      copyParams="target,type">

    <uix:formValue name="pageName" value="/database/instance/swrf/beginSnapshotViewReport" />

    <uix:pageLayout titleBinding="VIEW_REPORT@DBMsgBundle@servletRequest">
    <%@ include file="/database/global.jspf" %>
    
    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>                
    <%@ include file="/database/instances.jspf" %>


    <uix:header textBinding="SELECT_BEGIN_SNAP@DBMsgBundle@servletRequest" >
    
      <uix:tableLayout>
        <uix:rowLayout hAlign="left">  
          <uix:messagePrompt promptBinding="JUMP_TO_TIME@DBMsgBundle@servletRequest" 
           labeledNodeId="jumpToTime" />
          <uix:spacer width="10" />
          <uix:cellFormat>
            <uix:dateField  name="jumpDate" columns="15" id="jumpToTime"
              valueBinding="jumpDate@snapshotsBean@servletRequest"
              maxValueBinding="currentDate@snapshotsBean@servletRequest" />

            <oem:choice name="jumpTime" 
              shortDescBinding="JUMP_TO_TIME@DBMsgBundle@servletRequest" 
              selectedValueBinding="jumpTime@snapshotsBean@servletRequest"
              optionsBinding="timeValues@snapshotsBean@servletRequest"  />
              
            <uix:submitButton textBinding="GO@DBMsgBundle@servletRequest"
                name="event" value="jumpToTimeReport"/>
              
          </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout hAlign="left">  
            <uix:spacer width="1" />
            <uix:spacer width="1" />
            <uix:styledText styleClass="OraInlineInfoText"
              textBinding="exampleDate@snapshotsBean@servletRequest" />
          </uix:rowLayout>
        </uix:tableLayout>


            <oem:table name="snapshotsUIDataSource"
                       partialRenderMode="self"
                       id="snapshotsTable"
                       alternateTextBinding="NO_SNAPSHOTS_ALT@DBMsgBundle@servletRequest" 
                       width="80%"
                       dataSourceProp="snapshotsUIDataSource"
                       beanKey="snapshotsBean"
                       formSubmitted="true"
                       summaryBinding="SNAPSHOTS@DBMsgBundle@servletRequest"
                       blockSize="25">

              <uix:tableSelection >
                <oem:singleSelection 
                  selectedIndexBinding="snapshotSelectedIndex@snapshotsBean@servletRequest" 
                  shortDescBinding="SELECT@DBMsgBundle@servletRequest" /> 
              </uix:tableSelection>
            </oem:table>


      </uix:header>

       <uix:pageButtons>
        <uix:pageButtonBar>
            <uix:button textBinding="CANCEL@DBMsgBundle@servletRequest"
              destinationBinding="beginBackLink@servletRequest" />

            <uix:submitButton textBinding="OK@DBMsgBundle@servletRequest"
              name="event"
              value="goReport"/>
        </uix:pageButtonBar>
        </uix:pageButtons>


    </uix:pageLayout>
    </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>

