<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>


  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <uix:pageLayout  titleBinding="header@defaultBean@servletRequest" >
    <%@ include file="/database/global.jspf" %>
    
    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>     

    <db:form name="foo2" method="POST" destination="/console/database/instance/swrfCompareResults"
      copyParams="target,type">


    <uix:header textBinding="FIRST_TIMELINE@DBMsgBundle@servletRequest">
  
      <uix:labeledFieldLayout fieldWidth="25%" labelWidth="25%" columns="2" width="100%" >
        <uix:messagePrompt promptBinding="BEGIN_SNAP_ID@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="startIdString@firstDetails@defaultBean@servletRequest" />
        <uix:messagePrompt promptBinding="BEGIN_SNAP_CAPTURE_TIME@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="startTime@firstDetails@defaultBean@servletRequest" />
        <uix:messagePrompt promptBinding="END_SNAP_ID@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="endIdString@firstDetails@defaultBean@servletRequest" />
        <uix:messagePrompt promptBinding="END_SNAP_CAPTURE_TIME@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="endTime@firstDetails@defaultBean@servletRequest" />
     </uix:labeledFieldLayout>  

    </uix:header> 


    <uix:header textBinding="SECOND_TIMELINE@DBMsgBundle@servletRequest">

      <uix:labeledFieldLayout fieldWidth="25%" labelWidth="25%" columns="2" width="100%">
        <uix:messagePrompt promptBinding="BEGIN_SNAP_ID@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="startIdString@secondDetails@defaultBean@servletRequest" />
        <uix:messagePrompt promptBinding="BEGIN_SNAP_CAPTURE_TIME@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="startTime@secondDetails@defaultBean@servletRequest" />
        <uix:messagePrompt promptBinding="END_SNAP_ID@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="endIdString@secondDetails@defaultBean@servletRequest" />
        <uix:messagePrompt promptBinding="END_SNAP_CAPTURE_TIME@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="endTime@secondDetails@defaultBean@servletRequest" />
       </uix:labeledFieldLayout>

    </uix:header>

   <uix:spacer height="20" />



  <uix:header textBinding="RESULT_LABEL@DBMsgBundle@servletRequest"
    renderedBinding="isVersionLessThan10gR2@defaultBean@servletRequest"> 

   <uix:spacer height="10" />

    <uix:tableLayout>
      <uix:rowLayout hAlign="left">
      
        <uix:messagePrompt promptBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
          labeledNodeId="ViewLabel" />
      
        <uix:spacer width="10" />
        
        <uix:choice name="rateType" id="ViewLabel"
          onChange="submitForm('foo2', true, {'event':'switchRateType'})" >
          <uix:option textBinding="SP_PER_SECOND@DBMsgBundle@servletRequest"
            value="RATE_PER_SEC" />
          <uix:option textBinding="SP_PER_TRANSACTION@DBMsgBundle@servletRequest"
            value="RATE_PER_TRANS"
            selectedBinding="transSelected@defaultBean@servletRequest" />
        </uix:choice>
      
      </uix:rowLayout>
    </uix:tableLayout>

     <uix:tableLayout width="100%" >
        <uix:rowLayout vAlign="top">

        <oem:table name="compareResultsUIDataSource"
                   partialRenderMode="self"
                   id="theCompareResultsTable"
                   alternateTextBinding="TABLE_NO_DATA@DBMsgBundle@servletRequest" 
                   width="100%"
                   dataSourceProp="compareResultsUIDataSource"
                   beanKey="defaultBean"
                   summaryBinding="RESULT_LABEL@DBMsgBundle@servletRequest" 
                   formSubmitted="true">
              </oem:table>

      </uix:rowLayout>
    </uix:tableLayout>
  </uix:header>


   <uix:subTabLayout renderedBinding="isVersionGTE10gR2@defaultBean@servletRequest"> 
    <uix:subTabs>
      <uix:subTabBar selectedIndex="0">
          <uix:link textBinding="GENERAL@DBMsgBundle@servletRequest" />
          <uix:link textBinding="REPORT@DBMsgBundle@servletRequest"
          destinationBinding="reportLink@servletRequest" />
      </uix:subTabBar>
    </uix:subTabs>
  
   <uix:spacer height="10" />

    <uix:tableLayout>
      <uix:rowLayout hAlign="left">
      
        <uix:messagePrompt promptBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
          labeledNodeId="ViewLabel" />
      
        <uix:spacer width="10" />
        
        <uix:choice name="rateType" id="ViewLabel"
          onChange="submitForm('foo2', true, {'event':'switchRateType'})" >
          <uix:option textBinding="SP_PER_SECOND@DBMsgBundle@servletRequest"
            value="RATE_PER_SEC" />
          <uix:option textBinding="SP_PER_TRANSACTION@DBMsgBundle@servletRequest"
            value="RATE_PER_TRANS"
            selectedBinding="transSelected@defaultBean@servletRequest" />
        </uix:choice>
      
      </uix:rowLayout>
    </uix:tableLayout>

     <uix:tableLayout width="100%" >
        <uix:rowLayout vAlign="top">

        <oem:table name="compareResultsUIDataSource"
                   partialRenderMode="self"
                   id="theCompareResultsTable"
                   alternateTextBinding="TABLE_NO_DATA@DBMsgBundle@servletRequest" 
                   width="100%"
                   dataSourceProp="compareResultsUIDataSource"
                   summaryBinding="RESULT_LABEL@DBMsgBundle@servletRequest" 
                   beanKey="defaultBean"
                   formSubmitted="true">
              </oem:table>

      </uix:rowLayout>
    </uix:tableLayout>
      
    </uix:subTabLayout>  
      

  </db:form>	
  
  
  
  <uix:pageButtons>
  <uix:pageButtonBar>
   <uix:flowLayout >
    <uix:button textBinding="CHANGE_PERIODS@DBMsgBundle@servletRequest" 
     destinationBinding="changePeriodsLink@servletRequest" />
    </uix:flowLayout>
  </uix:pageButtonBar>
  </uix:pageButtons>
  
  
  </uix:pageLayout>
  </uix:body>


  </uix:document>
</uix:renderingContext>

