<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>


  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" method="POST" destination="/console/database/instance/swrfSnapshots"
      copyParams="target,type">

    <uix:formValue name="pageName" value="/database/instance/swrf/endSnapshot" />

    <uix:pageLayout titleBinding="selectedAction@snapshotsBean@servletRequest" >
    <%@ include file="/database/global.jspf" %>

    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>    

    <uix:messagePrompt promptBinding="CREATE_BASELINE_INSTR@DBMsgBundle@servletRequest" 
     renderedBinding="actionIsCreateBaseline@snapshotsBean@servletRequest" />

    <uix:spacer height="10" />

    
      <uix:labeledFieldLayout labelWidth="0" fieldWidth="100%" columns="1">     
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt promptBinding="BEGIN_SNAP_ID@DBMsgBundle@servletRequest" />
        </uix:cellFormat>
          <uix:styledText styleClass="OraDataText" 
            textBinding="beginSnapshotID@snapshotsBean@servletRequest" />
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt promptBinding="BEGIN_SNAP_CAPTURE_TIME@DBMsgBundle@servletRequest" />
        </uix:cellFormat>
          <uix:styledText styleClass="OraDataText" 
            textBinding="beginSnapshotTime@snapshotsBean@servletRequest" />
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt promptBinding="nameText@snapshotsBean@servletRequest" 
             renderedBinding="showBaselineName@snapshotsBean@servletRequest" 
             requiredBinding="nameRequired@snapshotsBean@servletRequest"  
             labeledNodeId="baselineNameId" />
        </uix:cellFormat>
           <uix:textInput name="baselineName" id="baselineNameId"
            textBinding="baselineName@snapshotsBean@servletRequest" 
            renderedBinding="showBaselineName@snapshotsBean@servletRequest" />
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt promptBinding="DESCRIPTION@DBMsgBundle@servletRequest" 
             renderedBinding="showDescription@snapshotsBean@servletRequest"
             labeledNodeId="baselineDescId" />
        </uix:cellFormat>
           <uix:textInput name="description" id="baselineDescId"
            textBinding="description@snapshotsBean@servletRequest" 
            renderedBinding="showDescription@snapshotsBean@servletRequest" /> 
            
     </uix:labeledFieldLayout>
     
      <uix:spacer height="10" />

      <uix:header textBinding="SELECT_ENDING_SNAP@DBMsgBundle@servletRequest" >
      

      <uix:tableLayout>
        <uix:rowLayout hAlign="left">  
          <uix:messagePrompt promptBinding="JUMP_TO_TIME@DBMsgBundle@servletRequest" 
            labeledNodeId="jumpToTime" />
          <uix:spacer width="10" />
          <uix:cellFormat>
            <uix:dateField  name="jumpDate" columns="15" id="jumpToTime"
              valueBinding="jumpDate@snapshotsBean@servletRequest"
              maxValueBinding="currentDate@snapshotsBean@servletRequest"/>

            <oem:choice name="jumpTime"
              shortDescBinding="JUMP_TO_TIME@DBMsgBundle@servletRequest" 
              selectedValueBinding="jumpTime@snapshotsBean@servletRequest"
              optionsBinding="timeValues@snapshotsBean@servletRequest"  />
              
            <uix:submitButton textBinding="GO@DBMsgBundle@servletRequest"
                name="event" value="jumpToTime2"/>
              
          </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout hAlign="left">  
            <uix:spacer width="1" />
            <uix:spacer width="1" />
            <uix:styledText styleClass="OraInlineInfoText"
              textBinding="exampleDate@snapshotsBean@servletRequest" />
          </uix:rowLayout>
        </uix:tableLayout>




            <oem:table name="snapshotsUIDataSource"
                       partialRenderMode="self"
                       id="snapshotsTable"
                       alternateTextBinding="NO_SNAPSHOTS_ALT@DBMsgBundle@servletRequest" 
                       width="80%"
                       dataSourceProp="snapshotsUIDataSource"
                       beanKey="snapshotsBean"
                       formSubmitted="true"
                       summaryBinding="SNAPSHOTS@DBMsgBundle@servletRequest" 
                       blockSize="25">

              <uix:tableSelection >
                <oem:singleSelection 
                  selectedIndexBinding="snapshotSelectedIndex@snapshotsBean@servletRequest"
                  shortDescBinding="SELECT@DBMsgBundle@servletRequest" />
              </uix:tableSelection>
            </oem:table>


      </uix:header>

        <uix:pageButtons>
        <uix:pageButtonBar>
            <uix:button textBinding="CANCEL@DBMsgBundle@servletRequest"
              destinationBinding="backLink@servletRequest" />
              
            <uix:switcher childNameBinding="actionIsDeleteSnapshots@snapshotsBean@servletRequest" > 
            <uix:case name="true">
              <uix:submitButton textBinding="CONTINUE@DBMsgBundle@servletRequest"
                name="event" 
                valueBinding="actionEventName@snapshotsBean@servletRequest"/>
            </uix:case> 
            <uix:case name="false">
              <uix:submitButton textBinding="OK@DBMsgBundle@servletRequest"
                name="event" 
                valueBinding="actionEventName@snapshotsBean@servletRequest"/>
            </uix:case> 
            </uix:switcher>          
        </uix:pageButtonBar>
        </uix:pageButtons>



    </uix:pageLayout>
    </db:form>    
    </uix:body>

  </uix:document>
</uix:renderingContext>

