<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>


  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" method="POST" destination="/console/database/instance/swrfCompare"
      copyParams="target,type">
    <uix:formValue name="source"/>
    <uix:formValue name="value" 
      valueBinding="pageSequence@defaultBean@servletRequest"/>
    <uix:formValue name="pageSeq" 
      valueBinding="pageSequence@defaultBean@servletRequest"/>

    <uix:pageLayout titleBinding="header@servletRequest">
    <%@ include file="/database/global.jspf" %>
    <%@ include file="/database/rec/trainMessages.jspf" %>
         
      <uix:labeledFieldLayout labelWidth="0" fieldWidth="100%" columns="1">
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt promptBinding="DATABASE@DBMsgBundle@servletRequest" />
        </uix:cellFormat>
          <uix:styledText styleClass="OraDataText" 
            textBinding="targetName@firstTimelineSnapshotsBean@defaultBean@servletRequest" />      
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt promptBinding="BEGIN_SNAP_ID@DBMsgBundle@servletRequest" />
        </uix:cellFormat>
          <uix:styledText styleClass="OraDataText" 
            textBinding="beginSnapshotID@firstTimelineSnapshotsBean@defaultBean@servletRequest" />
        <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt promptBinding="BEGIN_SNAP_CAPTURE_TIME@DBMsgBundle@servletRequest" />
        </uix:cellFormat>
          <uix:styledText styleClass="OraDataText" 
            textBinding="beginSnapshotTime@firstTimelineSnapshotsBean@defaultBean@servletRequest" />
      </uix:labeledFieldLayout>

    <uix:separator/>
    
      <uix:stackLayout>

        

        <uix:messagePrompt 
          promptBinding="SELECT_END_FIRST_TIMELINE@DBMsgBundle@servletRequest" />

        <uix:spacer height="10" />

        <uix:tableLayout>
          <uix:rowLayout hAlign="left">  
            <uix:messagePrompt promptBinding="JUMP_TO_TIME@DBMsgBundle@servletRequest" 
              labeledNodeId="jumpToTime" />
            <uix:spacer width="10" />
            <uix:cellFormat>
              <uix:dateField  name="firstJumpDate" columns="15" id="jumpToTime"
                valueBinding="jumpDate@firstTimelineSnapshotsBean@defaultBean@servletRequest"
                maxValueBinding="currentDate@firstTimelineSnapshotsBean@defaultBean@servletRequest"/>

              <oem:choice name="firstJumpTime"
                shortDescBinding="JUMP_TO_TIME@DBMsgBundle@servletRequest" 
                selectedValueBinding="jumpTime@firstTimelineSnapshotsBean@defaultBean@servletRequest"
                optionsBinding="timeValues@firstTimelineSnapshotsBean@defaultBean@servletRequest"  />
              
              <uix:submitButton textBinding="GO@DBMsgBundle@servletRequest"
                  name="event" value="jumpToTime2"/>     
            </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout hAlign="left">  
              <uix:spacer width="1" />
              <uix:spacer width="1" />
              <uix:styledText styleClass="OraInlineInfoText"
                textBinding="exampleDate@firstTimelineSnapshotsBean@defaultBean@servletRequest" />
            </uix:rowLayout>
          </uix:tableLayout>
    
              <oem:table name="firstTimelineSnapshotsUIDataSource2"
                         partialRenderMode="self"
                         id="firstSnapshotsTable"
                         alternateTextBinding="NO_SNAPSHOTS_ALT@DBMsgBundle@servletRequest" 
                         width="80%"
                         dataSourceProp="firstTimelineSnapshotsUIDataSource"
                         beanKey="defaultBean"
                         summaryBinding="SNAPSHOTS@DBMsgBundle@servletRequest" 
                         formSubmitted="true"
                         blockSize="10">
                <uix:tableSelection >
                  <oem:singleSelection 
                     shortDescBinding="SELECT@DBMsgBundle@servletRequest"
                     selectedIndexBinding="snapshotSelectedIndex@firstTimelineSnapshotsBean@defaultBean@servletRequest" >
                  </oem:singleSelection>
                </uix:tableSelection>         
              </oem:table>


        </uix:stackLayout>



         <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@DBMsgBundle@servletRequest"
                  name="event" value="cancel"/>
                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>

    </db:form>	
    </uix:body>


  </uix:document>
</uix:renderingContext>

