<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>


  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" method="POST" destination="/console/database/instance/swrfCompare"
      copyParams="target,type">
    <uix:formValue name="source"/>
    <uix:formValue name="value" 
      valueBinding="pageSequence@defaultBean@servletRequest"/>
    <uix:formValue name="pageSeq" 
      valueBinding="pageSequence@defaultBean@servletRequest"/>

    <uix:pageLayout titleBinding="header@servletRequest">
    <%@ include file="/database/global.jspf" %>
    <%@ include file="/database/rec/trainMessages.jspf" %>


    
      <uix:contents>


      <uix:messagePrompt promptBinding="COMPARE_WIZ_INTRO@DBMsgBundle@servletRequest" />

      <uix:spacer height="10" />

      <uix:tableLayout width="100%" >
       <uix:stackLayout>
        <uix:radioButton name="firstTimelineSelection" value="0"
          textBinding="SELECT_BASELINE@DBMsgBundle@servletRequest"
          selectedValueBinding="firstTimelineSelection@defaultBean@servletRequest"
          onClick="submitForm('foo', true, {'event':'switchFirstSelection'})" />
        <uix:rowLayout>
          <uix:spacer width="20" />
          <uix:styledText styleClass="OraInlineInfoText"
            textBinding="SKIP_NEXT_STEP@DBMsgBundle@servletRequest" />
         </uix:rowLayout> 
         <uix:radioButton name="firstTimelineSelection" value="1"
          textBinding="SELECT_BEGIN_SNAP@DBMsgBundle@servletRequest"
          selectedValueBinding="firstTimelineSelection@defaultBean@servletRequest"
          onClick="submitForm('foo', true, {'event':'switchFirstSelection'})" />
       </uix:stackLayout>
      </uix:tableLayout>


      <uix:tableLayout width="100%" 
        renderedBinding="firstTimelineIsBaseline@defaultBean@servletRequest">
        <uix:rowLayout vAlign="top">
          <oem:table name="firstTimelineBaselinesUIDataSource"
                     partialRenderMode="self"
                     id="firstBaselinesTable"
                     alternateTextBinding="NO_BASELINES_ALT@DBMsgBundle@servletRequest" 
                     width="80%"
                     dataSourceProp="firstTimelineBaselinesUIDataSource"
                     summaryBinding="BASELINES@DBMsgBundle@servletRequest" 
                     beanKey="defaultBean"
                     formSubmitted="true"
                     blockSize="10">
            <uix:tableSelection >
              <oem:singleSelection 
                shortDescBinding="SELECT@DBMsgBundle@servletRequest"
                selectedIndex="0" >
              </oem:singleSelection>
            </uix:tableSelection>         
          </oem:table>
        </uix:rowLayout>
      </uix:tableLayout>

        



       

        <uix:tableLayout renderedBinding="firstTimelineIsSnapshot@defaultBean@servletRequest">

           <uix:spacer height="10" />
        
          <uix:rowLayout hAlign="left">  
            <uix:messagePrompt promptBinding="JUMP_TO_TIME@DBMsgBundle@servletRequest"
              labeledNodeId="jumpToTime" />
            <uix:spacer width="10" />
            <uix:cellFormat>
              <uix:dateField  name="firstJumpDate" columns="15" id="jumpToTime"
                valueBinding="jumpDate@firstTimelineSnapshotsBean@defaultBean@servletRequest"
                maxValueBinding="currentDate@firstTimelineSnapshotsBean@defaultBean@servletRequest"/>

              <oem:choice name="firstJumpTime"
                shortDescBinding="JUMP_TO_TIME@DBMsgBundle@servletRequest" 
                selectedValueBinding="jumpTime@firstTimelineSnapshotsBean@defaultBean@servletRequest"
                optionsBinding="timeValues@firstTimelineSnapshotsBean@defaultBean@servletRequest"  />
              
              <uix:submitButton textBinding="GO@DBMsgBundle@servletRequest"
                  name="event" value="jumpToTime1"/>     
            </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout hAlign="left">  
              <uix:spacer width="1" />
              <uix:spacer width="1" />
              <uix:styledText styleClass="OraInlineInfoText"
                textBinding="exampleDate@firstTimelineSnapshotsBean@defaultBean@servletRequest" />
          </uix:rowLayout>
        </uix:tableLayout>

        
          <uix:tableLayout width="100%"
            renderedBinding="firstTimelineIsSnapshot@defaultBean@servletRequest">
            <uix:rowLayout vAlign="top">
              <oem:table name="firstTimelineSnapshotsUIDataSource1"
                         partialRenderMode="self"
                         id="firstSnapshotsTable"
                         alternateTextBinding="NO_SNAPSHOTS_ALT@DBMsgBundle@servletRequest" 
                         width="80%"
                         dataSourceProp="firstTimelineSnapshotsUIDataSource"
                         beanKey="defaultBean"
                         summaryBinding="SNAPSHOTS@DBMsgBundle@servletRequest" 
                         formSubmitted="true"
                         blockSize="10">
                <uix:tableSelection >
                  <oem:singleSelection 
                    shortDescBinding="SELECT@DBMsgBundle@servletRequest"
                    selectedIndexBinding="snapshotSelectedIndex@firstTimelineSnapshotsBean@defaultBean@servletRequest" >
                  </oem:singleSelection>
                </uix:tableSelection>         
              </oem:table>
            </uix:rowLayout>
          </uix:tableLayout>
          


      </uix:contents>

       <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:submitButton textBinding="CANCEL@DBMsgBundle@servletRequest"
              name="event" value="cancel"/>
            <uix:contents>
              <uix:navigationBar
                name="tableNav"
                blockSize="-1"
                formSubmitted="true"
                formName="foo"
                maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                minValue="1"
                valueBinding="pageSequence@defaultBean@servletRequest"/>
            </uix:contents>
          </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>

    </db:form>	
    </uix:body>


  </uix:document>
</uix:renderingContext>

