<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>


  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" method="POST" destination="/console/database/instance/swrfCompare"
      copyParams="target,type">
    <uix:formValue name="source"/>
    <uix:formValue name="value" 
      valueBinding="pageSequence@defaultBean@servletRequest"/>
    <uix:formValue name="pageSeq" 
      valueBinding="pageSequence@defaultBean@servletRequest"/>

    <uix:pageLayout titleBinding="header@servletRequest">
    <%@ include file="/database/global.jspf" %>
    <%@ include file="/database/rec/trainMessages.jspf" %>


    
      <uix:contents>

      <uix:labeledFieldLayout labelWidth="0" fieldWidth="100%" columns="1">
       <uix:cellFormat wrappingDisabled="true" hAlign="right">
          <uix:messagePrompt promptBinding="DATABASE@DBMsgBundle@servletRequest" />
        </uix:cellFormat>
          <uix:styledText styleClass="OraDataText" 
            textBinding="targetName@firstTimelineSnapshotsBean@defaultBean@servletRequest" />      
      </uix:labeledFieldLayout>
    
    <uix:header textBinding="FIRST_TIMELINE@DBMsgBundle@servletRequest">

      <uix:labeledFieldLayout fieldWidth="16%" labelWidth="14%" columns="3" width="100%" 
        renderedBinding="firstTimelineIsBaseline@defaultBean@servletRequest">
        <uix:messagePrompt promptBinding="BASELINE_ID@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="baselineID@firstTimelineBaselinesBean@defaultBean@servletRequest" />
        <uix:messagePrompt promptBinding="BEGIN_SNAP_ID@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="beginSnapshotID@firstTimelineBaselinesBean@defaultBean@servletRequest" />
        <uix:messagePrompt promptBinding="CAPTURE_TIME@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="beginSnapshotTime@firstTimelineBaselinesBean@defaultBean@servletRequest" />
        <uix:messagePrompt promptBinding="NAME@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="baselineName@firstTimelineBaselinesBean@defaultBean@servletRequest" />
        <uix:messagePrompt promptBinding="END_SNAP_ID@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="endSnapshotID@firstTimelineBaselinesBean@defaultBean@servletRequest" />
        <uix:messagePrompt promptBinding="CAPTURE_TIME@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="endSnapshotTime@firstTimelineBaselinesBean@defaultBean@servletRequest" />
            
     </uix:labeledFieldLayout>

    
      <uix:labeledFieldLayout fieldWidth="25%" labelWidth="25%" columns="2" width="100%" 
        renderedBinding="firstTimelineIsSnapshot@defaultBean@servletRequest" >
        <uix:messagePrompt promptBinding="BEGIN_SNAP_ID@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="beginSnapshotID@firstTimelineSnapshotsBean@defaultBean@servletRequest" />
        <uix:messagePrompt promptBinding="BEGIN_SNAP_CAPTURE_TIME@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="beginSnapshotTime@firstTimelineSnapshotsBean@defaultBean@servletRequest" />
        <uix:messagePrompt promptBinding="END_SNAP_ID@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="endSnapshotID@firstTimelineSnapshotsBean@defaultBean@servletRequest" />
        <uix:messagePrompt promptBinding="END_SNAP_CAPTURE_TIME@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="endSnapshotTime@firstTimelineSnapshotsBean@defaultBean@servletRequest" />
     </uix:labeledFieldLayout>  

    </uix:header>

    <uix:separator/>

    <uix:stackLayout>
      <uix:messagePrompt promptBinding="SECOND_TIMELINE_INTRO@DBMsgBundle@servletRequest" />
    
    
    <uix:spacer height="10" />

    
      <uix:tableLayout width="100%" >
       <uix:stackLayout>
        <uix:radioButton name="secondTimelineSelection" value="0"
          textBinding="SELECT_BASELINE@DBMsgBundle@servletRequest"
          selectedValueBinding="secondTimelineSelection@defaultBean@servletRequest"
          onClick="submitForm('foo', true, {'event':'switchSecondSelection'})" />
        <uix:rowLayout>
          <uix:spacer width="20" />
          <uix:styledText styleClass="OraInlineInfoText"
            textBinding="SKIP_NEXT_STEP@DBMsgBundle@servletRequest" />
         </uix:rowLayout>   
        <uix:radioButton name="secondTimelineSelection" value="1"
          textBinding="SELECT_BEGIN_SNAP@DBMsgBundle@servletRequest"
          selectedValueBinding="secondTimelineSelection@defaultBean@servletRequest"
          onClick="submitForm('foo', true, {'event':'switchSecondSelection'})" />
       </uix:stackLayout>
      </uix:tableLayout>


       <uix:tableLayout width="100%" 
        renderedBinding="secondTimelineIsBaseline@defaultBean@servletRequest">
          <uix:rowLayout vAlign="top">

            <oem:table name="secondTimelineBaselinesUIDataSource"
                       partialRenderMode="self"
                       id="secondBaselinesTable"
                       alternateTextBinding="NO_BASELINES_ALT@DBMsgBundle@servletRequest" 
                       width="80%"
                       dataSourceProp="secondTimelineBaselinesUIDataSource"
                       beanKey="defaultBean"
                       formSubmitted="true"
                       summaryBinding="BASELINES@DBMsgBundle@servletRequest" 
                       blockSize="10">
              <uix:tableSelection >
                <oem:singleSelection 
                  shortDescBinding="SELECT@DBMsgBundle@servletRequest"
                  selectedIndex="0" >
                </oem:singleSelection>
              </uix:tableSelection>         
            </oem:table>
            
          </uix:rowLayout>
        </uix:tableLayout>


        <uix:tableLayout renderedBinding="secondTimelineIsSnapshot@defaultBean@servletRequest">
           <uix:spacer height="10" />
            <uix:rowLayout hAlign="left">  
            <uix:messagePrompt promptBinding="JUMP_TO_TIME@DBMsgBundle@servletRequest" 
              labeledNodeId="jumpToTime" />
            <uix:spacer width="10" />
            <uix:cellFormat>
              <uix:dateField  name="secondJumpDate" columns="15" id="jumpToTime"
                valueBinding="jumpDate@secondTimelineSnapshotsBean@defaultBean@servletRequest"
                maxValueBinding="currentDate@secondTimelineSnapshotsBean@defaultBean@servletRequest"/>

              <oem:choice name="secondJumpTime"
                shortDescBinding="JUMP_TO_TIME@DBMsgBundle@servletRequest" 
                selectedValueBinding="jumpTime@secondTimelineSnapshotsBean@defaultBean@servletRequest"
                optionsBinding="timeValues@secondTimelineSnapshotsBean@defaultBean@servletRequest"  />
              
              <uix:submitButton textBinding="GO@DBMsgBundle@servletRequest"
                  name="event" value="jumpToTime3"/>     
            </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout hAlign="left">  
              <uix:spacer width="1" />
              <uix:spacer width="1" />
              <uix:styledText styleClass="OraInlineInfoText"
                textBinding="exampleDate@firstTimelineSnapshotsBean@defaultBean@servletRequest" />
            </uix:rowLayout>
          </uix:tableLayout>


      
          <uix:tableLayout width="100%" 
          renderedBinding="secondTimelineIsSnapshot@defaultBean@servletRequest">
            <uix:rowLayout vAlign="top">
              <oem:table name="secondTimelineSnapshotsUIDataSource1"
                         partialRenderMode="self"
                         id="secondSnapshotsTable"
                         alternateTextBinding="NO_SNAPSHOTS_ALT@DBMsgBundle@servletRequest" 
                         width="80%"
                         dataSourceProp="secondTimelineSnapshotsUIDataSource"
                         beanKey="defaultBean"
                         summaryBinding="SNAPSHOTS@DBMsgBundle@servletRequest"
                         formSubmitted="true"
                         blockSize="10">
                <uix:tableSelection >
                  <oem:singleSelection 
                    shortDescBinding="SELECT@DBMsgBundle@servletRequest"
                    selectedIndexBinding="snapshotSelectedIndex@secondTimelineSnapshotsBean@defaultBean@servletRequest" >
                  </oem:singleSelection>
                </uix:tableSelection>         
              </oem:table>
            </uix:rowLayout>
          </uix:tableLayout>
        

    </uix:stackLayout>
    
     

        </uix:contents>

         <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@DBMsgBundle@servletRequest"
                  name="event" value="cancel"/>
                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>

    </db:form>	
    </uix:body>


  </uix:document>
</uix:renderingContext>

