<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>


  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" method="POST" 
      destination="/console/database/instance/swrfSnapshotDetails"
      copyParams="target,type">

    <uix:pageLayout titleBinding="header@defaultBean@servletRequest">
    <%@ include file="/database/global.jspf" %>

    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>     

   <uix:subTabLayout renderedBinding="noErrors@defaultBean@servletRequest">
      <uix:subTabs>
        <uix:subTabBar selectedIndex="0">
            <uix:link textBinding="DETAILS@DBMsgBundle@servletRequest" />
            <uix:link textBinding="REPORT@DBMsgBundle@servletRequest"
            destinationBinding="reportLink@servletRequest" />
        </uix:subTabBar>
      </uix:subTabs>

    <uix:tableLayout width="100%" renderedBinding="noErrors@defaultBean@servletRequest" >
      <uix:labeledFieldLayout fieldWidth="25%" labelWidth="25%" columns="2" width="100%" 
        renderedBinding="isSnapshots@defaultBean@servletRequest" >
        <uix:messagePrompt promptBinding="BEGIN_SNAP_ID@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="startIdString@defaultBean@servletRequest" />
        <uix:messagePrompt promptBinding="END_SNAP_ID@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="endIdString@defaultBean@servletRequest" />
        <uix:messagePrompt promptBinding="BEGIN_SNAP_CAPTURE_TIME@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="startTime@defaultBean@servletRequest" />
        <uix:messagePrompt promptBinding="END_SNAP_CAPTURE_TIME@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="endTime@defaultBean@servletRequest" />
     </uix:labeledFieldLayout>  
    </uix:tableLayout>

     <uix:tableLayout width="100%" renderedBinding="noErrors@defaultBean@servletRequest">
      <uix:labeledFieldLayout fieldWidth="16%" labelWidth="14%" columns="3" width="100%" 
        renderedBinding="isBaseline@defaultBean@servletRequest">
        <uix:messagePrompt promptBinding="BASELINE_ID@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="baselineID@defaultBean@servletRequest" />
         <uix:messagePrompt promptBinding="BEGIN_SNAP_ID@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="startIdString@defaultBean@servletRequest" />
          <uix:messagePrompt promptBinding="END_SNAP_ID@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="endIdString@defaultBean@servletRequest" />
          <uix:messagePrompt promptBinding="NAME@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="baselineName@defaultBean@servletRequest" />
           <uix:messagePrompt promptBinding="CAPTURE_TIME@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="startTime@defaultBean@servletRequest" />
          <uix:messagePrompt promptBinding="CAPTURE_TIME@DBMsgBundle@servletRequest" />
        <uix:styledText styleClass="OraDataText" 
          textBinding="endTime@defaultBean@servletRequest" />
      </uix:labeledFieldLayout>
    </uix:tableLayout>

      <uix:tableLayout width="100%" renderedBinding="noErrors@defaultBean@servletRequest">
        <uix:rowLayout vAlign="top">
          <oem:table name="snapshotDetailsUIDataSource"
                     partialRenderMode="self"
                     id="snapshotDetailsTable"
                     alternateTextBinding="TABLE_NO_DATA@DBMsgBundle@servletRequest" 
                     width="100%"
                     dataSourceProp="snapshotDetailsUIDataSource"
                     summaryBinding="header@defaultBean@servletRequest"
                     beanKey="defaultBean"
                     formSubmitted="true">
          </oem:table>
        </uix:rowLayout>
      </uix:tableLayout>

      </uix:subTabLayout>

        <uix:pageButtons>
        <uix:pageButtonBar>
          <uix:button destinationBinding="hdmLink@servletRequest"
            textBinding="VIEW_HDM_RUN@DBMsgBundle@servletRequest" 
            renderedBinding="showADDMButton@defaultBean@servletRequest" />   
        </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>

    </db:form>	
    </uix:body>


  </uix:document>
</uix:renderingContext>

