<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>


  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" method="POST" 
      destination="/console/database/instance/swrfSnapshotDetails"
      copyParams="target,type">

    <uix:pageLayout titleBinding="header@defaultBean@servletRequest">
    <%@ include file="/database/global.jspf" %>

    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>     

    <uix:subTabLayout>
      <uix:subTabs>
        <uix:subTabBar selectedIndex="1">
            <uix:link textBinding="DETAILS@DBMsgBundle@servletRequest"
                  destinationBinding="returnLink@servletRequest" />
            <uix:link textBinding="REPORT@DBMsgBundle@servletRequest" />
        </uix:subTabBar>
      </uix:subTabs>


    <uix:tableLayout width="100%" renderedBinding="noErrors@defaultBean@servletRequest">
      <uix:rowLayout hAlign="right">  
        <uix:submitButton textBinding="SAVE_TO_FILE@DBMsgBundle@servletRequest" 
            name="event" value="saveToFile" />
       </uix:rowLayout>
    </uix:tableLayout>

    <uix:tableLayout width="100%" renderedBinding="noErrors@defaultBean@servletRequest" >
      <uix:rawText textBinding="swrfReport@defaultBean@servletRequest" /> 
    </uix:tableLayout>


    </uix:subTabLayout>

      <uix:pageButtons>
      <uix:pageButtonBar>
        <uix:button destinationBinding="hdmLink@servletRequest"
          textBinding="VIEW_HDM_RUN@DBMsgBundle@servletRequest" 
          renderedBinding="isSnapshots@defaultBean@servletRequest" />   
      </uix:pageButtonBar>
      </uix:pageButtons>


      </uix:pageLayout>

    </db:form>	
    </uix:body>


  </uix:document>
</uix:renderingContext>

