<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<oem:pageSegment>
<uix:dataScope>
<uix:bundle name="DBMsg" class="oracle.sysman.db.rsc.inst.DBMsg"/>
<uix:bundle name="sdkMessageBundle"
	    class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

<uix:hideShowHeader textBinding="SELECT_CHART_TIME_PERIOD@DBMsg" disclosedBinding="showChartTimePeriodSection@timePicker@" formSubmitted="true" id="hideShowChartTimePeriod" >
<%-- partialRenderMode="self" --%>
<uix:stackLayout>
<uix:styledText styleClass="OraInstructionText" textBinding="SELECT_CHART_TIME_PERIOD_INST@DBMsg"/>
<uix:spacer height="10"/>
<uix:labeledFieldLayout columns="2" labelWidth="150" width="80%">
<uix:styledText styleClass="OraPromptText" textBinding="CHART_START_DATE@DBMsg" labeledNodeId="chartStartDate"/>
<uix:dateField id="chartStartDate" name="chartStartDateString" valueBinding="chartStartDateString@timePicker@" columns="24"/>
<uix:styledText styleClass="OraPromptText" textBinding="CHART_END_DATE@DBMsg" labeledNodeId="chartEndDate"/>
<uix:dateField id="chartEndDate" name="chartEndDateString" valueBinding="chartEndDateString@timePicker@" columns="24"/> 
<uix:spacer width="10%"/>
<uix:submitButton textBinding="GO@DBMsg" name="event" value="timePickerSegment_setChartTimePeriod"/>
</uix:labeledFieldLayout>
</uix:stackLayout>
</uix:hideShowHeader>

<uix:header textBinding="SELECT_TIME_PERIOD@DBMsg">
<uix:styledText styleClass="OraInstructionText" textBinding="selectTimePeriodInstruction@servletRequest"/>
<uix:tableLayout width="90%" cellSpacing="2">
<uix:rowLayout>
<uix:spacer width="10"/>
<uix:cellFormat>
<uix:radioButton  name="whichDate" value="startDate" 
	selected="true"
     	selectedValueBinding="whichDate@timePicker@" id="startDate"/>
</uix:cellFormat>
<uix:cellFormat wrappingDisabled="true">
<uix:flowLayout>
<uix:messagePrompt labeledNodeId="startDate" promptBinding="PERIOD_START_TIME@DBMsg"/>

<uix:spacer width="3"/>
<uix:image source="/em/images/start_snapshot.gif" id="startDate"/>
<uix:spacer width="8"/> 

      <uix:switcher childNameBinding="moreThanOneChoicesForStartTime@timePicker@">
	<uix:case name="true"> 
          <oem:choice name="startTimeString"
	       selectedValueBinding="startTimeString@timePicker@" 
	       optionsBinding="startTimeChoices@timePicker@" 
	       onChange="submitForm(document.forms[0], true, {'event':'timePickerSegment_chooseStartTime'})"
	       id="startDate"/>
	</uix:case>
	<uix:case name="false"> 
          <uix:styledText styleClass="OraDataText" 
	   textBinding="startTimeString@timePicker@"/>
	</uix:case>
      </uix:switcher> 
</uix:flowLayout> 
</uix:cellFormat>

<uix:cellFormat>
<uix:radioButton name="whichDate" value="endDate"
     selectedValueBinding="whichDate@timePicker@" id="endDate"/>
</uix:cellFormat>
<uix:cellFormat wrappingDisabled="true">

<uix:flowLayout>
<uix:messagePrompt promptBinding="PERIOD_END_TIME@DBMsg" labeledNodeId="endDate"/>
<uix:spacer width="3"/>
<uix:image source="/em/images/end_snapshot.gif" id="endDate"/>
<uix:spacer width="8"/>
      <uix:switcher childNameBinding="moreThanOneChoicesForEndTime@timePicker@">
	<uix:case name="true"> 
          <oem:choice name="endTimeString"
	       selectedValueBinding="endTimeString@timePicker@" 
	       optionsBinding="endTimeChoices@timePicker@" 
	       onChange="submitForm(document.forms[0], true, {'event':'timePickerSegment_chooseEndTime'})"
	        id="endDate"/>
	</uix:case>
	<uix:case name="false"> 
          <uix:styledText styleClass="OraDataText" 
	   textBinding="endTimeString@timePicker@"/>
	</uix:case>
      </uix:switcher>
</uix:flowLayout>
</uix:cellFormat> 

</uix:rowLayout> 
</uix:tableLayout>

<uix:switcher childNameBinding="showData@waitsBean@">
<uix:case name="true">
<uix:tableLayout cellSpacing="20">
<uix:rowLayout>
<uix:cellFormat hAlign="right">
<oem:chart 
  chartType="timeSeriesChart"
  width="850"
  height="150"
  timeGranularity="SECOND" 
  orientation="vertical"
  seriesColorsAutomatic="true"
  legendPosition="east" 
  legendVisible="true"
  fill="cumulative"
  yAxisLabelBinding="ACTIVE_SESSIONS@DBMsg"
  titleBinding="ACTIVE_SESSIONS@DBMsg"
  titleVisible="false"
  xAxisMinBinding="beginDate@waitsBean@"
  xAxisMaxBinding="endDate@waitsBean@"
  format="svg"
  colorPaletteBinding="nonStaticPickerColors@waitsChart@"
  axisMaxBinding="maxValue@waitsBean@"
  svgHighlightLegend="true"
>
  <uix:contents>
    <oem:timeSelector
      intervalTimeSecBinding="intervalTimeSec@waitsBean@"
      height="25"
      selectionDest="svgIconClicked"
      selectionDestType="JavaScript"
      selectionAltTextBinding="selectionAltText"
      position="south"
      timebandDataSourceBinding="timebands@waitsBean@"
      xAxisScrollDest="scroll_timechart"
      xAxisScrollDestType="JavaScript"
      xAxisScrollPrev="true"
      xAxisScrollPrevAltTextBinding="GO_BACKWARD@DBMsg"
      xAxisScrollNext="true"
      xAxisScrollNextAltTextBinding="GO_FORWARD@DBMsg"
      showBorder="false"
    >
    </oem:timeSelector>
    <oem:boundChartDataSource 
      chartDataSourceBinding="chartDataSource@waitsBean@"/>
    <oem:chartColumn                                   
        isKey="true" 
        displayLabel=""
        sourceIndex="0" />
    <oem:chartColumn
        isTimeColumn="true"
        displayLabel="Time"
        sourceIndex="1"  />
    <oem:chartColumn                                   
        displayLabel=""
        sourceIndex="2" />
  </uix:contents>
</oem:chart>
</uix:cellFormat>
<uix:cellFormat>
  <uix:header textBinding="ZOOM@DBMsg">
    <uix:rowLayout hAlign="right">
      <uix:spacer width="20"/>
      <uix:switcher childNameBinding="zoomInDisabled@waitsBean@">
        <uix:case name="true">
          <uix:image source="/em/images/toolbar_zoomin_enabled.gif"/>
        </uix:case>
        <uix:case name="false">
          <uix:image source="/em/images/toolbar_zoomin_enabled.gif" 
                    onClick="zoomIn()"/>
        </uix:case>
      </uix:switcher>
      <uix:spacer width="10"/>
      <uix:switcher childNameBinding="zoomOutDisabled@waitsBean@">
        <uix:case name="true">
          <uix:image source="/em/images/toolbar_zoomout_enabled.gif"/>
        </uix:case>
        <uix:case name="false">
          <uix:image source="/em/images/toolbar_zoomout_enabled.gif" 
                    onClick="zoomOut()"/>
        </uix:case>
      </uix:switcher>            
    </uix:rowLayout>        
  </uix:header>
</uix:cellFormat>
</uix:rowLayout>
</uix:tableLayout>
</uix:case>
</uix:switcher>
</uix:header>
</uix:dataScope>
</oem:pageSegment>
