<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<db:script src="/database/instance/alertlog/archivepurge/netUtil.js"/>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

<uix:bundle name="SDKUIResourceBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<uix:bundle name="MultiTargetResourceBundle" class="oracle.sysman.eml.rsc.target.MultiTargetMsg"/>
<uix:bundle name="DbRscInstBundle" class="oracle.sysman.db.rsc.inst.DBMsg"/>
  
        <uix:document>
             <%@ include file="/oemTitle.jspf" %>
            <uix:body>
              <uix:contents>
                <uix:form name="archiveForm" method="POST">
                   <uix:formValue  name="lovName"/>
                  <uix:contents>
                    <uix:pageLayout titleBinding="title@archivePurgeBean@servletRequest">
                       <%@ include file="/enablePPR.jspf" %>
                         <%@ include file="/oemGlobal.jspf" %>
                         <oem:messageBox messageType="info" 
                            errorTableBinding="info@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
                         <oem:messageBox messageType="error" 
                            errorTableBinding="errors@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>

                      <!-- main contents -->
                      <uix:contents>

                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                            <uix:styledText styleClass="OraInstructionText" textBinding="CRED_INSTR_TEXT@DbRscInstBundle" />
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                                <uix:spacer width="10" height="10"/>
                       <uix:header textBinding="sourceHosCredentialHeader@archivePurgeBean@servletRequest">
                        <uix:contents>
                          <uix:rowLayout width="90%" renderedBinding="enterpriseMode@archivePurgeBean@servletRequest">
                              <uix:contents>
                                <uix:cellFormat width="70%">
                                  <uix:contents>
                                        <uix:messageStyledText textBinding="sourceHost@archivePurgeBean@servletRequest" promptBinding="HOST@DbRscInstBundle" styleClass="OraDataText"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                          </uix:rowLayout>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer height="10" width="10"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:spacer height="10" width="10"/>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                           <uix:rowLayout >
                                             <uix:contents>
                                                <uix:cellFormat>
                                                  <uix:contents>
                                                    <uix:styledText styleClass="OraInstructionText" textBinding="CREDENTIAL_TYPEDbRscInstBundle"/>
                                                    <uix:spacer height="10" width="10"/>
                                                   </uix:contents>
                                                </uix:cellFormat>
                                                  <uix:rowLayout>
                                                    <uix:contents childDataBinding="preferredFlagOptions@archivePurgeBean@servletRequest">
                                                    <uix:radioButton shortDescBinding="text" 
                                                           valueBinding="value" 
                                                           name="credType" 
                                                          onClick= "submitForm('archiveForm', true, {'event':'preferredFlagChanged'})"
                                                          selectedBinding="selected"/>
                                                     <uix:messagePrompt promptBinding="text" />
                                                  </uix:contents>
                                                </uix:rowLayout>
                                             </uix:contents>
                                           </uix:rowLayout>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer height="10" width="10"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                         <uix:rowLayout >
                           <uix:tableLayout borderWidth="0" >
                           <uix:rowLayout>
                            <uix:cellFormat hAlign="right">
                              <uix:contents>
                                <uix:spacer height="1" width="35"/>
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="right">
                              <uix:contents>
                                 <uix:messageChoice promptBinding="HOST_CREDENTIALS@DbRscInstBundle" name="sourceHostCredType" selectedValueBinding="sourceCredType@archivePurgeBean@servletRequest" renderedBinding="showPrefCred@archivePurgeBean@servletRequest"  shortDescBinding="HOST_CREDENTIALS@DbRscInstBundle">
                                                <uix:option textBinding="NORMAL_CRED@DbRscInstBundle" value="HostCredsNormal" shortDescBinding="NORMAL_CRED@DbRscInstBundle"/>
                                                <uix:option textBinding="PRIV_CRED@DbRscInstBundle" value="HostCredsPriv" shortDescBinding="PRIV_CRED@DbRscInstBundle"/>
                                 </uix:messageChoice>
                              </uix:contents>
                            </uix:cellFormat>
                           </uix:rowLayout>
                           </uix:tableLayout>
                        </uix:rowLayout>

                        <uix:tableLayout borderWidth="0" renderedBinding="overrideCredFlag@archivePurgeBean@servletRequest">
                          <uix:contents>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:styledText styleClass="OraInstructionText" text=""/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:messageTextInput columns="10" required="uiOnly" promptBinding="userNamePrompt@archivePurgeBean@servletRequest" name="overriddenUserId" textBinding="overriddenUserid@archivePurgeBean@servletRequest"  messageBinding="usernameerrmsg@servletRequest" messageTypeBinding="usernameerrtype@servletRequest" shortDescBinding="LOCK_USERNAME@DbRscInstBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="10"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                              <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:styledText styleClass="OraInstructionText" text=""/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:messageTextInput columns="10" secret="true" promptBinding="passwordPrompt@archivePurgeBean@servletRequest" required="uiOnly" noAutoComplete="true" name="overriddenPassword" textBinding="overriddenPassword@archivePurgeBean@servletRequest" messageBinding="userpwderrmsg@servletRequest" messageTypeBinding="userpwderrtype@servletRequest"  shortDescBinding="PASSWORD@DbRscInstBundle"/>
                                  </uix:contents>
                               </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="10"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="10"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                         </uix:contents>
                        </uix:tableLayout>
                       </uix:contents>
                      </uix:header>
     
                       <uix:header textBinding="DEST_HOST_CRED@DbRscInstBundle" renderedBinding="enterpriseMode@archivePurgeBean@servletRequest">
                        <uix:contents>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:styledText textBinding="DEST_HOST@DbRscInstBundle" styleClass="OraInstructionText"/>
                                    <uix:spacer height="10" width="10"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:messageLovField name="destHost" id="destHost" columns="15"  onClick = "openTargetSelWindow('destHost');"  textBinding="archiveDestHost@archivePurgeBean@servletRequest" shortDescBinding="DEST_HOST@DbRscInstBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>

                        <uix:spacer height="10" width="10"/>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                           <uix:rowLayout >
                                             <uix:contents>
                                                <uix:cellFormat>
                                                  <uix:contents>
                                                    <uix:styledText styleClass="OraInstructionText" textBinding="CREDENTIAL_TYPE@DbRscInstBundle"/>
                                                    <uix:spacer height="10" width="10"/>
                                                   </uix:contents>
                                                </uix:cellFormat>
                                                  <uix:rowLayout>
                                                    <uix:contents childDataBinding="destPreferredFlagOptions@archivePurgeBean@servletRequest">
                                                    <uix:radioButton shortDescBinding="text" 
                                                           valueBinding="value" 
                                                           name="destcredType" 
                                                          onClick= "submitForm('archiveForm', true, {'event':'destPreferredFlagChanged'})"
                                                          selectedBinding="selected"/>
                                                     <uix:messagePrompt promptBinding="text" />
                                                  </uix:contents>
                                                </uix:rowLayout>
                                             </uix:contents>
                                           </uix:rowLayout>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer height="10" width="10"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                         <uix:rowLayout>
                                 <uix:messageChoice promptBinding="HOST_CREDENTIALS@DbRscInstBundle" name="destHostCredType" selectedValueBinding="destCredType@archivePurgeBean@servletRequest" renderedBinding="showDestPrefCred@archivePurgeBean@servletRequest" shortDescBinding="HOST_CREDENTIALS@DbRscInstBundle">
                                                <uix:option textBinding="NORMAL_CRED@DbRscInstBundle" value="HostCredsNormal" shortDescBinding="NORMAL_CRED@DbRscInstBundle"/>
                                                <uix:option textBinding="PRIV_CRED@DbRscInstBundle" value="HostCredsPriv" shortDescBinding="PRIV_CRED@DbRscInstBundle"/>
                                 </uix:messageChoice>
                        </uix:rowLayout>

                        <uix:tableLayout borderWidth="0" renderedBinding="destOverrideCredFlag@archivePurgeBean@servletRequest">
                          <uix:contents>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:styledText styleClass="OraInstructionText" text=""/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:messageTextInput columns="10" required="uiOnly" promptBinding="userNamePrompt@archivePurgeBean@servletRequest" name="destoverriddenUserId" textBinding="destOverriddenUserid@archivePurgeBean@servletRequest"  messageBinding="destusernameerrmsg@servletRequest" messageTypeBinding="destusernameerrtype@servletRequest" shortDescBinding="LOCK_USERNAME@DbRscInstBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="10"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                              <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:styledText styleClass="OraInstructionText" text=""/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:messageTextInput columns="10" secret="true" promptBinding="passwordPrompt@archivePurgeBean@servletRequest" required="uiOnly" noAutoComplete="true" name="destoverriddenPassword" textBinding="destOverriddenPassword@archivePurgeBean@servletRequest" messageBinding="destuserpwderrmsg@servletRequest" messageTypeBinding="destuserpwderrtype@servletRequest" shortDescBinding="PASSWORD@DbRscInstBundle"/>
                                  </uix:contents>
                               </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="10"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="10"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                         </uix:contents>
                        </uix:tableLayout>
                       </uix:contents>
                      </uix:header>
                        <uix:spacer height="10" width="10"/>
                        <uix:spacer height="10" width="10"/>
                        <uix:spacer height="10" width="10"/>
                        <uix:spacer height="10" width="10"/>
                        <uix:spacer height="10" width="10"/>
                        <uix:spacer height="10" width="10"/>
                         <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                    <uix:spacer height="10" width="10"/>
                                  <uix:contents>
                                <uix:messageCheckBox name="purgeFlag" textBinding="PURGE_TRACE_FILE_CHOICE_TEXT@DbRscInstBundle" styleClass="OraInstructionText" checkedBinding="purgeRequired@archivePurgeBean@servletRequest" value="true" shortDescBinding="PURGE_TRACE_FILE_CHOICE_TEXT@DbRscInstBundle"/>
                                    
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                        
                        <uix:spacer height="10" width="10"/>
                      </uix:contents>
                     
                        <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
                              <uix:submitButton
                    textBinding="CANCEL@SDKUIResourceBundle"
                    name="event"
                    value="cancel" shortDescBinding="CANCEL@SDKUIResourceBundle"/>
                              <uix:submitButton
                    textBinding="CONTINUE@DbRscInstBundle"
                    name="event"
                    value="continue" shortDescBinding="CONTINUE@DbRscInstBundle"/>

                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>

                     
                     
                    </uix:pageLayout>
                  </uix:contents>
                </uix:form>
              </uix:contents>
            </uix:body>
        </uix:document>
      </uix:renderingContext>
