<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<db:script src="/database/instance/trcfile/archivepurge/netUtil.js"/>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle name="SDKUIResourceBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="MultiTargetResourceBundle" class="oracle.sysman.eml.rsc.target.MultiTargetMsg"/>
  <uix:bundle name="DbRscInstBundle" class="oracle.sysman.db.rsc.inst.DBMsg"/>

        <uix:document>
             <%@ include file="/oemTitle.jspf" %>
          
            <uix:body>
              <uix:contents>
                <uix:form name="archivepurgeform"  method="POST">
                  <uix:formValue name="pageName" value="/database/instance/alertlog/archivepurge/archiveAlertLog"/>
                  <uix:formValue  name="lovName"/>
                  <uix:formValue  name="listingType"/>
                  <uix:formValue  name="curDir"/>
                  <uix:formValue  name="defaultMethod"/>

                  <uix:contents>
                    <uix:pageLayout  titleBinding="title@archivePurgeBean@servletRequest">
                          <%@ include file="/enablePPR.jspf" %>
                         <%@ include file="/oemGlobal.jspf" %>

                         <oem:messageBox messageType="info" 
                            errorTableBinding="info@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
                         <oem:messageBox messageType="error" 
                            errorTableBinding="errors@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
                      <!-- main contents -->
                      <uix:contents>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer width="10" height="10"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:tableLayout >
                          <uix:contents>
                            <uix:rowLayout >
                              <uix:contents>
                                <uix:cellFormat >
                                  <uix:contents>
                                    <uix:labeledFieldLayout >
                                      <uix:contents>
                                        <uix:messageStyledText textBinding="sourceHost@archivePurgeBean@servletRequest" promptBinding="HOST@DbRscInstBundle" styleClass="OraDataText"/>
                                        <uix:spacer height="10" width="10"/>
                                        <uix:messageStyledText textBinding="sourceDB@archivePurgeBean@servletRequest" promptBinding="DATABASE_INSTANCE@DbRscInstBundle" styleClass="OraDataText"/>
                                      </uix:contents>
                                    </uix:labeledFieldLayout>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer width="10" height="10"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                         <!-------- -->
                            <uix:rowLayout>
                             <uix:contents>
                               <uix:cellFormat>
                                 <uix:contents>
                                   <uix:styledText textBinding="SEL_DIRECTORY@DbRscInstBundle" styleClass="OraInstructionText"/>
                                 </uix:contents>
                               </uix:cellFormat>
                              </uix:contents>
                           </uix:rowLayout>
                           <uix:rowLayout >
                              <uix:contents>
                                        <uix:tableLayout borderWidth="0" cellPadding="2" >
                                          <uix:contents>
                                            <uix:rowLayout>
                                              <uix:contents>
                                                <uix:cellFormat>
                                                  <uix:contents>
                                                    <uix:spacer height="1" width="50"/>
                                                  </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat styleClass="OraInstructionText" >
                                                 <uix:contents>
                                                   <uix:radioButton name="directoryName" textBinding="FG_INSTRUCTION@DbRscInstBundle" styleClass="OraInstructionText" value="0" selectedValueBinding="dirNameChoice@archivePurgeBean@servletRequest" shortDescBinding="FG_INSTRUCTION@DbRscInstBundle"/>
                                                 </uix:contents>
                                                </uix:cellFormat>
                                                
                                                <uix:cellFormat/>
                                                <uix:cellFormat/>
                                              </uix:contents>
                                            </uix:rowLayout>
                                            <uix:rowLayout>
                                              <uix:contents>
                                                <uix:cellFormat >
                                                  <uix:contents>
                                                    <uix:spacer height="1" width="10"/>
                                                  </uix:contents>
                                                </uix:cellFormat>
                                                 <uix:cellFormat hAlign="left" >
                                                  <uix:contents >
                                                   <uix:tableLayout borderWidth="0">
                                                     <uix:rowLayout>
                                                    <uix:spacer height="1" width="30"/>
                                                   <uix:messageStyledText styleClass="OraDataText" textBinding="userDumpLocation@archivePurgeBean@servletRequest" prompt="$USER_DUMP_DEST    "/>
                                                  </uix:rowLayout>
                                                  </uix:tableLayout>
                                                 </uix:contents>
                                                </uix:cellFormat> 
                                                <uix:cellFormat hAlign="left">
                                                 <uix:contents>
                                                 </uix:contents>
                                                </uix:cellFormat>
                                              </uix:contents>
                                            </uix:rowLayout>
                                            <uix:rowLayout styleClass="OraInstructionText">
                                              <uix:contents>
                                                <uix:cellFormat>
                                                  <uix:contents>
                                                    <uix:spacer height="1" width="50"/>
                                                  </uix:contents>
                                                </uix:cellFormat>
                                                <uix:radioButton name="directoryName" textBinding="BG_INSTRUCTION@DbRscInstBundle" styleClass="OraInstructionText" value="1"  selectedValueBinding="dirNameChoice@archivePurgeBean@servletRequest" shortDescBinding="BG_INSTRUCTION@DbRscInstBundle"/>
                                               
                                                <uix:cellFormat vAlign="bottom">
                                                  <uix:contents>
                                                    <uix:spacer height="1" width="50"/>
                                                  </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat/>
                                              </uix:contents>
                                            </uix:rowLayout>
                                            <uix:rowLayout>
                                                <uix:cellFormat>
                                                  <uix:contents>
                                                    <uix:spacer height="1" width="10"/>
                                                  </uix:contents>
                                                </uix:cellFormat>
                                                <uix:cellFormat hAlign="left">
                                                 <uix:contents>
                                                   <uix:tableLayout borderWidth="0">
                                                     <uix:rowLayout>
                                                    <uix:spacer height="1" width="30"/>
                                                    <uix:messageStyledText styleClass="OraDataText" textBinding="backGroundDumpLocation@archivePurgeBean@servletRequest" prompt="$BACK_GROUND_DUMP_DEST"/>
                                                     </uix:rowLayout>
                                                   </uix:tableLayout>
                                                 </uix:contents>
                                                </uix:cellFormat>
                                             </uix:rowLayout>
                                            <uix:rowLayout>
                                              <uix:contents>
                                                <uix:cellFormat >
                                                  <uix:contents>
                                                    <uix:spacer height="1" width="50"/>
                                                  </uix:contents>
                                                </uix:cellFormat>
                                                 <uix:cellFormat >
                                                  <uix:contents>
                                                   <uix:radioButton name="directoryName"  textBinding="SOURCE_DIR_LOC@DbRscInstBundle" value="2"  selectedValueBinding="dirNameChoice@archivePurgeBean@servletRequest" shortDescBinding="SOURCE_DIR_LOC@DbRscInstBundle"/>
                                                  </uix:contents>
                                                 </uix:cellFormat>
                                                 <uix:cellFormat >
                                                  <uix:contents>
                                                 </uix:contents>
                                                </uix:cellFormat> 
                                              </uix:contents>
                                            </uix:rowLayout>
                                            <uix:rowLayout>
                                              <uix:contents>
                                                <uix:cellFormat >
                                                  <uix:contents>
                                                    <uix:spacer height="1" width="50"/>
                                                  </uix:contents>
                                                </uix:cellFormat>
                                                 <uix:cellFormat >
                                                  <uix:contents>
                                                   <uix:tableLayout borderWidth="0">
                                                     <uix:rowLayout>
                                                    <uix:spacer height="1" width="30"/>
                                                   <uix:messageLovField name="sourceDirLoc" id="sourceDirLoc" columns="15"  onClick = "openRFSWindow2('sourceDirLoc','LIST_DIRS','sourceDirLoc');" textBinding="sourceDirLocation@archivePurgeBean@servletRequest"  messageBinding="sourcelocerrmsg@servletRequest" messageTypeBinding="sourcelocerrtype@servletRequest" shortDescBinding="SOURCE_DIR_LOC@DbRscInstBundle" searchDescBinding="SOURCE_DIR_LOC@DbRscInstBundle"/>
                                                  </uix:rowLayout>
                                                  </uix:tableLayout>
                                                 </uix:contents>
                                                </uix:cellFormat> 
                                              </uix:contents>
                                            </uix:rowLayout>
                                          </uix:contents>
                                        </uix:tableLayout>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:tableLayout borderWidth="0" cellPadding="2"  width="70%">
                                          <uix:contents>
                                            <uix:rowLayout>
                                              <uix:contents>
                                                <uix:cellFormat>
                                                  <uix:contents>
                                                    <uix:spacer height="1" width="50"/>
                                                  </uix:contents>
                                                </uix:cellFormat>

                                              </uix:contents>
                                              </uix:rowLayout>
                                              </uix:contents>
                                  </uix:tableLayout>
                              </uix:contents>
                            </uix:rowLayout>
                         <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer width="10" height="10"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat >
                              <uix:contents>
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:spacer height="10" width="10"/> 
                                    <uix:messageTextInput name="archivePurgeAge"  textBinding="archivePurgeAgeAsStr@archivePurgeBean@servletRequest" columns="2" promptBinding="TRACE_PROMPT@DbRscInstBundle" shortDescBinding="TRACE_PROMPT@DbRscInstBundle" />
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer height="10" width="10"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:spacer height="10" width="10"/>
                            <uix:messageTextInput id="tp" name="filepattern" columns="10" textBinding="traceFilePattern@archivePurgeBean@servletRequest" shortDescBinding="traceFilePatternPrompt@archivePurgeBean@servletRequest" tipBinding="TRACE_PATTERN_TIP@DbRscInstBundle" promptBinding= "traceFilePatternPrompt@archivePurgeBean@servletRequest" />
                          </uix:contents>
                        </uix:rowLayout>
                         <uix:rowLayout>
                          <uix:contents>
                          </uix:contents>
                        </uix:rowLayout>
                         <!-------- -->
                        <uix:spacer height="10" width="10"/>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer width="10" height="5"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                      </uix:contents>
                      <!-- navigation -->
                      <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
                             <uix:submitButton textBinding="PURGE_BUTTON_LABEL@DbRscInstBundle"
                              name="event"
                              value="purge"
                              shortDescBinding="PURGE_BUTTON_LABEL@DbRscInstBundle"
                             />
                             <uix:submitButton textBinding="ARCHIVE_BUTTON_LABEL@DbRscInstBundle"
                              name="event"
                              value="archive"
                              shortDescBinding="ARCHIVE_BUTTON_LABEL@DbRscInstBundle"
                             />
                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>
                    </uix:pageLayout>
                  </uix:contents>
                </uix:form>
              </uix:contents>
            </uix:body>
         
        </uix:document>
    
</uix:renderingContext>
