<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<db:script src="/database/instance/alertlog/archivepurge/netUtil.js"/>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

<uix:bundle name="SDKUIResourceBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<uix:bundle name="MultiTargetResourceBundle" class="oracle.sysman.eml.rsc.target.MultiTargetMsg"/>
<uix:bundle name="DbRscInstBundle" class="oracle.sysman.db.rsc.inst.DBMsg"/>
  
        <uix:document>
          <%@ include file="/oemTitle.jspf" %>
            <uix:body>
              <uix:contents>
                <uix:form name="purgeForm"  method="POST">
                  <uix:formValue name="pageName" value="/database/instance/alertlog/archivepurge/archiveAlertLog"/>
                  <uix:formValue  name="lovName"/>
                  <uix:formValue  name="listingType"/>
                  <uix:formValue  name="curDir"/>
                  <uix:formValue  name="defaultMethod"/>
                  <uix:contents>
                    <uix:pageLayout titleBinding="title@archivePurgeBean@servletRequest">
                          <uix:messageBox messageType="error"
                                 messageTypeBinding="messageType@segmenterrors@servletRequest"
                                 messageBinding="message@segmenterrors@servletRequest"
                                 rendered="false"
                                 renderedBinding="errorOccurred@segmenterrors@servletRequest">
                             <uix:contents childDataBinding="errorList@segmenterrors@servletRequest">
                             <uix:link textBinding="label"
                                longDescBinding="message"
                               destinationBinding="destination"/>
                            </uix:contents>
                        </uix:messageBox>
                         <%@ include file="/oemGlobal.jspf" %>
                         <oem:messageBox messageType="info" 
                            errorTableBinding="info@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
                         <oem:messageBox messageType="error" 
                            errorTableBinding="errors@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>


                      <!-- main contents -->
                      <uix:contents>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer width="10" height="10"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                       <uix:header textBinding="SELECT_DEST_DIR_LOC@DbRscInstBundle">
                          <uix:contents>
                             <uix:tableLayout borderWidth="0">
                              <uix:contents>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="10"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:spacer height="1" width="120"/>
                                </uix:contents>
                               </uix:cellFormat>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                       <uix:messageStyledText id="destHost" textBinding="archiveDestHost@archivePurgeBean@servletRequest" promptBinding="hostPrompt@archivePurgeBean@servletRequest" styleClass="OraDataText" shortDescBinding="archiveDestHost@archivePurgeBean@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="10"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:spacer height="1" width="120"/>
                                </uix:contents>
                               </uix:cellFormat>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:messageLovField promptBinding="destDirLocPrompt@archivePurgeBean@servletRequest" name="destDirLoc" id="destDirLoc" columns="15"  onClick = "openRFSWindow('destDirLoc','LIST_DIRS','destDirLoc','destHost');" textBinding="archiveDestDirLocation@archivePurgeBean@servletRequest"  messageBinding="destlocerrmsg@servletRequest" messageTypeBinding="destlocerrtype@servletRequest" shortDescBinding="destDirLocPrompt@archivePurgeBean@servletRequest" searchDescBinding="destDirLocPrompt@archivePurgeBean@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
                          </uix:contents>
                        </uix:header>

                            <uix:header textBinding="JOB_TITLE@DbRscInstBundle">
                          <uix:contents>
                        <uix:tableLayout borderWidth="0">
                          <uix:contents>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="1" width="5"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout hAlign="right">
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:spacer height="1" width="10"/>
                                </uix:contents>
                               </uix:cellFormat>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                  <uix:messageTextInput name="JobName" required="uiOnly" promptBinding="jobNamePrompt@archivePurgeBean@servletRequest" messageBinding="jobnameerrmsg@servletRequest" messageTypeBinding="jobnameerrtype@servletRequest"  columns="20" textBinding="jobName@archivePurgeBean@servletRequest" shortDescBinding="jobNamePrompt@archivePurgeBean@servletRequest"/>
                                </uix:contents>
                               </uix:cellFormat>
                            </uix:rowLayout>
                            <uix:rowLayout hAlign="right">
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:spacer height="1" width="80"/>
                                </uix:contents>
                               </uix:cellFormat>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                  <uix:messageTextInput columns="20" name="jobDescr" promptBinding="jobDescriptionPrompt@archivePurgeBean@servletRequest" textBinding="jobDescription@archivePurgeBean@servletRequest" shortDescBinding="jobDescriptionPrompt@archivePurgeBean@servletRequest"/>
                                </uix:contents>
                               </uix:cellFormat>
                            </uix:rowLayout>
                         </uix:contents>
                        </uix:tableLayout>
                      </uix:contents>
                      </uix:header>
                     
   
                      <uix:header textBinding="SCHEDULE@DbRscInstBundle">
                              <uix:ref refID="INCLUDING_PAGE_NODE" />
                      </uix:header>
                  </uix:contents>
                      <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
                              <uix:submitButton
                    textBinding="CANCEL@SDKUIResourceBundle"
                    name="event"
                    value="cancel" shortDescBinding="CANCEL@SDKUIResourceBundle"/>
                              <uix:submitButton
                    textBinding="BACK@SDKUIResourceBundle"
                    name="event"
                    value="back" shortDescBinding="BACK@SDKUIResourceBundle"/>
                              <uix:submitButton
                    textBinding="OK@SDKUIResourceBundle"
                    name="event"
                    value="ok" shortDescBinding="OK@SDKUIResourceBundle"/>

                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>
                      
                      <uix:messages>
                        <uix:messageBox>
                          <uix:contents>
                            <uix:styledText textBinding="archiveSelectionInfo@archivePurgeBean@servletRequest" styleClass="OraInstructionText"/>
                          </uix:contents>
                        </uix:messageBox>
                      </uix:messages>
                 
                    </uix:pageLayout>
                  </uix:contents>
                </uix:form>
              </uix:contents>
            </uix:body>
        </uix:document>
     
  </uix:renderingContext>


