<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

<uix:bundle name="SDKUIResourceBundle" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<uix:bundle name="MultiTargetResourceBundle" class="oracle.sysman.eml.rsc.target.MultiTargetMsg"/>
<uix:bundle name="DbRscInstBundle" class="oracle.sysman.db.rsc.inst.DBMsg"/>

  
        <uix:document>
          <%@ include file="/oemTitle.jspf" %>
            <uix:body>
              <uix:contents>
                <uix:form name="purgeForm"  method="POST">
                  <uix:contents>
                    <uix:pageLayout titleBinding="title@archivePurgeBean@servletRequest">
                          <uix:messageBox messageType="error"
                                 messageTypeBinding="messageType@segmenterrors@servletRequest"
                                 messageBinding="message@segmenterrors@servletRequest"
                                 rendered="false"
                                 renderedBinding="errorOccurred@segmenterrors@servletRequest">
                             <uix:contents childDataBinding="errorList@segmenterrors@servletRequest">
                             <uix:link textBinding="label"
                                longDescBinding="message"
                               destinationBinding="destination"/>
                            </uix:contents>
                        </uix:messageBox>

                         <%@ include file="/oemGlobal.jspf" %>
                         <oem:messageBox messageType="info" 
                            errorTableBinding="info@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
                         <oem:messageBox messageType="error" 
                            errorTableBinding="errors@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>

                      <!-- main contents -->
                      <uix:contents>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer width="10" height="10"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                       <uix:header textBinding="HOST_CREDENTIALS@DbRscInstBundle">
                       <uix:contents>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer height="10" width="10"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:styledText styleClass="OraInstructionText" textBinding="CRED_INSTR_TEXT@DbRscInstBundle" />
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:spacer height="10" width="10"/>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                           <uix:rowLayout >
                                             <uix:contents>
                                                <uix:cellFormat>
                                                  <uix:contents>
                                                    <uix:styledText styleClass="OraInstructionText" textBinding="CRED_TYPE@DbRscInstBundle"/>
                                                    <uix:spacer height="10" width="10"/>  
                                                   </uix:contents>
                                                </uix:cellFormat>
                                                  <uix:rowLayout>
                                                    <uix:contents childDataBinding="preferredFlagOptions@archivePurgeBean@servletRequest">
                                                    <uix:radioButton shortDescBinding="text" 
                                                           valueBinding="value" 
                                                           name="credType" 
                                                          onClick= "submitForm('purgeForm', true, {'event':'preferredFlagChanged'})"
                                                          selectedBinding="selected"/> 
                                                     <uix:messagePrompt promptBinding="text" />
                                                  </uix:contents>
                                                </uix:rowLayout>
                                             </uix:contents>
                                           </uix:rowLayout>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat>
                              <uix:contents>
                                <uix:spacer height="10" width="10"/>
                              </uix:contents>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                        <uix:rowLayout>
                        <uix:tableLayout borderWidth="0" >
                           <uix:rowLayout>
                            <uix:cellFormat hAlign="right">
                              <uix:contents>
                                <uix:spacer height="1" width="35"/>
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="right">
                              <uix:contents>

                                 <uix:messageChoice promptBinding="HOST_CREDENTIALS@DbRscInstBundle" name="sourceHostCredType" selectedValueBinding="sourceCredType@archivePurgeBean@servletRequest" renderedBinding="showPrefCred@archivePurgeBean@servletRequest" shortDescBinding="HOST_CREDENTIALS@DbRscInstBundle">
                                                <uix:option textBinding="NORMAL_CRED@DbRscInstBundle" value="HostCredsNormal" shortDescBinding="NORMAL_CRED@DbRscInstBundle"/>
                                                <uix:option textBinding="PRIV_CRED@DbRscInstBundle" value="HostCredsPriv" shortDescBinding="PRIV_CRED@DbRscInstBundle"/>
                                 </uix:messageChoice>
                            </uix:contents>
                            </uix:cellFormat>
                           </uix:rowLayout>
                           </uix:tableLayout>
                        </uix:rowLayout>

                        <uix:tableLayout borderWidth="0" renderedBinding="overrideCredFlag@archivePurgeBean@servletRequest">
                          <uix:contents>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:styledText styleClass="OraInstructionText" text=""/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:messageTextInput columns="10" required="uiOnly" promptBinding="userNamePrompt@archivePurgeBean@servletRequest" name="overriddenUserId" textBinding="overriddenUserid@archivePurgeBean@servletRequest"  messageBinding="usernameerrmsg@servletRequest" messageTypeBinding="usernameerrtype@servletRequest" shortDescBinding="LOCK_USERNAME@DbRscInstBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="10"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:spacer height="10" width="10"/>
                                    <uix:styledText styleClass="OraInstructionText" text=""/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:messageTextInput columns="10" secret="true" promptBinding="passwordPrompt@archivePurgeBean@servletRequest" required="uiOnly" noAutoComplete="true" name="overriddenPassword" textBinding="overriddenPassword@archivePurgeBean@servletRequest" messageBinding="userpwderrmsg@servletRequest" messageTypeBinding="userpwderrtype@servletRequest"  shortDescBinding="PASSWORD@DbRscInstBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="10"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat>
                                  <uix:contents>
                                    <uix:spacer height="10" width="10"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
                          </uix:contents>
                        </uix:header>

                            <uix:header textBinding="JOB_TITLE@DbRscInstBundle"/>
                        <uix:tableLayout borderWidth="0">
                          <uix:contents>
                            <uix:rowLayout>
                              <uix:labeledFieldLayout width="0" labelWidth="0" fieldWidth="0">
                                  <uix:messageTextInput name="JobName" required="uiOnly" promptBinding="jobNamePrompt@archivePurgeBean@servletRequest" messageBinding="jobnameerrmsg@servletRequest" messageTypeBinding="jobnameerrtype@servletRequest"  columns="20" textBinding="jobName@archivePurgeBean@servletRequest" shortDescBinding="jobNamePrompt@archivePurgeBean@servletRequest"/>
                                  <uix:messageTextInput columns="20" name="jobDescr" promptBinding="jobDescriptionPrompt@archivePurgeBean@servletRequest" textBinding="jobDescription@archivePurgeBean@servletRequest" shortDescBinding="jobDescriptionPrompt@archivePurgeBean@servletRequest"/>
                              </uix:labeledFieldLayout>
                            </uix:rowLayout>
                         </uix:contents>
                        </uix:tableLayout>
                      </uix:contents>
                     
                      <uix:header textBinding="SCHEDULE@DbRscInstBundle">
                              <uix:ref refID="INCLUDING_PAGE_NODE" />
                      </uix:header>

                      <uix:pageButtons>
                        <uix:pageButtonBar>
                          <uix:contents>
                              <uix:submitButton
                    textBinding="CANCEL@SDKUIResourceBundle"
                    name="event"
                    value="cancel" shortDescBinding="CANCEL@SDKUIResourceBundle"/>
                              <uix:submitButton
                    textBinding="OK@SDKUIResourceBundle"
                    name="event"
                    value="ok" shortDescBinding="OK@SDKUIResourceBundle"/>

                          </uix:contents>
                        </uix:pageButtonBar>
                      </uix:pageButtons>
                      
                      <uix:messages>
                        <uix:messageBox>
                          <uix:contents>
                            <uix:styledText textBinding="purgeSelectionInfo@archivePurgeBean@servletRequest" styleClass="OraInstructionText"/>
                          </uix:contents>
                        </uix:messageBox>
                      </uix:messages>
                 
                    </uix:pageLayout>
                  </uix:contents>
                </uix:form>
              </uix:contents>
            </uix:body>
        </uix:document>
     
  </uix:renderingContext>


