<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/> 

  <uix:document> 

    <uix:metaContainer> 
      <uix:head titleBinding="undoManagementTitle@undoBean@servletRequest"/> 
    </uix:metaContainer>
    <uix:body>
      <db:form name="adviceForm" method="POST" destination="/console/database/instance/undoAdvisory" copyParams="target,type">
        <uix:pageLayout titleBinding="UNDO_MANAGEMENT@msgBundle@servletRequest" >
          <uix:formValue name="pageName" value="/database/instance/undo/undoAdv_Activity"/>
      
          <%@ include file="/database/global.jspf" %>
        

          <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
      <uix:styledText styleClass="OraInstructionText" 
                      textBinding="INSTRUCTION_TEXT@msgBundle@servletRequest"/>
    <uix:subTabLayout>

      <%-- property tabs --%>
      <uix:subTabs>
        <uix:subTabBar selectedIndex="1">
          <oem:submitLink textBinding="TAB_ADVICE@msgBundle@servletRequest"
                          shortDescBinding="TAB_ADVICE@msgBundle@servletRequest"
                          onClick="submitForm('adviceForm',1,{'event':'refresh'})"
                          formName="adviceForm"/>
          <oem:submitLink textBinding="TAB_SYSTEM_ACTIVITY@msgBundle@servletRequest"
                          shortDescBinding="TAB_SYSTEM_ACTIVITY@msgBundle@servletRequest"
                          onClick="submitForm('adviceForm',1,{'event':'systemActivity'})"
                          formName="adviceForm"/>
        </uix:subTabBar>
      </uix:subTabs>

                  <uix:header textBinding="HEADER_SYSTEM_ACTIVITY@msgBundle@servletRequest">
                   <uix:contents>
                      <uix:labeledFieldLayout labelWidth="40%">
                    <uix:messagePrompt promptBinding="TIME_INTERVAL@msgBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" textBinding="intervalChoiceSelected@undoBean@servletRequest"/>
                        <uix:messagePrompt promptBinding="longestQueryLabel@undoBean@servletRequest"/>
                        <uix:styledText styleClass="OraInstructionTextStrong" 
                          textBinding="longestQuery@undoBean@servletRequest"/>
                        <uix:messagePrompt promptBinding="AVG_UNDO_GEN_RATE@msgBundle@servletRequest"/>
                        <uix:styledText styleClass="OraInstructionTextStrong" 
                          textBinding="avgUndoGenRate@undoBean@servletRequest"/>
                        <uix:messagePrompt promptBinding="MAX_UNDO_GEN_RATE@msgBundle@servletRequest"/>
                        <uix:styledText styleClass="OraInstructionTextStrong" 
                          textBinding="maxUndoGenRate@undoBean@servletRequest"/>
                        <uix:messagePrompt promptBinding="NUMBER_FAILED_QUERY@msgBundle@servletRequest"/>
                        <uix:styledText styleClass="OraInstructionTextStrong" 
                          text="0"/>
                        <uix:messagePrompt promptBinding="NUMBER_FAILED_TRANSACTION@msgBundle@servletRequest"/>
                        <uix:styledText styleClass="OraInstructionTextStrong" 
                          text="0"/>
                      </uix:labeledFieldLayout>
                 <uix:rawText text="<br>"/>
                 <!-- uix:styledText styleClass="OraInstructionText" textBinding="NOTE_GRAPH@msgBundle@servletRequest" renderedBinding="showGraph@undoBean@servletRequest"/ -->
		 
                      <uix:hideShow disclosedBinding="showGraphSysActivity@undoBean@servletRequest"
                        formSubmitted="true" id="hideShow"
                        undisclosedTextBinding="SHOW_DETAILS@msgBundle@servletRequest"
                        disclosedTextBinding="HIDE_DETAILS@msgBundle@servletRequest">
                        <uix:contents>
                          <oem:chart
                            titleBinding="UNDO_TABLESPACE_USAGE@msgBundle@servletRequest"
                            chartType="timeSeriesChart"
                            yAxisLabelBinding="Y_AXIS_LABEL_SIZE@msgBundle@servletRequest"
                            width="400"
                            height="250"
                            orientation="vertical"
                            timeGranularityBinding="timeGranularity@undoBean@servletRequest"
                            legendPosition="east"
                            legendVisible="external"
                            externalLegendOrientation="vertical"
                            fill = "cumulative">

                            <uix:contents>
                              <oem:boundChartDataSource
                                chartDataSourceBinding="usageDataSource@undoBean@servletRequest"
                              />
                              <oem:chartColumn
                                isTimeColumn="true"
                                displayLabelBinding="X_AXIS_LABEL@msgBundle@servletRequest" 
                                sourceIndex="0" 
                              />
                              <%--
                              <oem:chartColumn
                                displayLabelBinding="TBS_SYSTEM@msgBundle@servletRequest"
                                itemColor="gray" 
                                sourceIndex="5" 
                              />
                              --%>
                              <oem:chartColumn
                                displayLabelBinding="TBS_ACTIVE@msgBundle@servletRequest"
                                itemColor="red" 
                                sourceIndex="2" 
                              />
                              <oem:chartColumn
                                displayLabelBinding="TBS_UNEXPIRED@msgBundle@servletRequest"
                                itemColor="yellow" 
                                sourceIndex="3" 
                              />
                              <oem:chartColumn
                                displayLabelBinding="TBS_FREE@msgBundle@servletRequest"
                                itemColor="green" 
                                sourceIndex="4" 
                              />
                            </uix:contents>
                          </oem:chart>

                          <oem:chart
                            titleBinding="AUTO_TUNING@msgBundle@servletRequest"
                            chartType="timeSeriesChart"
                            yAxisLabelBinding="AUTOTUNED_RETENTION_MINUTE@msgBundle@servletRequest"
                            width="400"
                            height="250"
                            orientation="vertical"
                            timeGranularityBinding="timeGranularity@undoBean@servletRequest"
                            legendPosition="east"
                            legendVisible="external"
                            externalLegendOrientation="vertical"
                            >

                            <uix:contents>
                              <oem:boundChartDataSource
                                chartDataSourceBinding="usageDataSource@undoBean@servletRequest"
                              />
                              <oem:chartColumn
                                isTimeColumn="true"
                                displayLabelBinding="X_AXIS_LABEL@msgBundle@servletRequest" 
                                sourceIndex="0" 
                              />
                              <oem:chartColumn
                                displayLabelBinding="AUTO_TUNING_MINUTE@msgBundle@servletRequest"
                                itemColor="#3399FF" 
                                sourceIndex="5"
                              />
                              <oem:chartColumn
                                displayLabelBinding="MAX_POSSIBLE_QUERY@msgBundle@servletRequest"
                                itemColor="#800000" 
                                sourceIndex="6"
                              />
                            </uix:contents>
                          </oem:chart>

                          <oem:chart
                            titleBinding="UNDO_GENERATION_RATE@msgBundle@servletRequest"
                            chartType="timeSeriesChart"
                            yAxisLabelBinding="Y_AXIS_LABEL_RATE@msgBundle@servletRequest"
                            width="400"
                            height="250"
                            orientation="vertical"
                            timeGranularityBinding="timeGranularity@undoBean@servletRequest"
                            legendPosition="east"
                            legendVisible="FALSE"
                            externalLegendOrientation="vertical"
                            >

                            <uix:contents>
                              <oem:boundChartDataSource
                                chartDataSourceBinding="usageDataSource@undoBean@servletRequest"
                              />
                              <oem:chartColumn
                                isTimeColumn="true"
                                displayLabelBinding="X_AXIS_LABEL@msgBundle@servletRequest" 
                                sourceIndex="0" 
                              />
                              <oem:chartColumn
                                displayLabelBinding="Y_AXIS_LABEL_RATE@msgBundle@servletRequest"
                                itemColor="blue" 
                                sourceIndex="1" 
                              />
                            </uix:contents>
                          </oem:chart>

                        </uix:contents>
                      </uix:hideShow>
 
                    </uix:contents>
                  </uix:header>
       </uix:subTabLayout>
      </uix:pageLayout>
      </db:form>
    </uix:body>
   
  </uix:document>
    
</uix:renderingContext>
