<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/> 

  <uix:document> 

    <uix:metaContainer> 
      <uix:head titleBinding="undoTitle@servletRequest"/> 
    </uix:metaContainer>
    <uix:body>
      <uix:contents>
      
      <db:form name="adviceForm" method="POST" destination="/console/database/instance/undoAdvisory" copyParams="target,type,id">
        <uix:pageLayout titleBinding="UNDO_ADVISOR@msgBundle@servletRequest" >
          <uix:formValue name="pageName" value="/database/instance/undo/undoAdv_Advice"/>
	  <uix:formValue name="event" value="changeInterval" />
          
          <%@ include file="/database/global.jspf" %>
        

          <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:pageStatus>
            <uix:switcher childNameBinding="undoMode@servletRequest">
              <uix:case name="AUTO">
                <uix:labeledFieldLayout labelWidth="35%" columns="2" width="100%">
                  <uix:messagePrompt promptBinding="labelUndoRetentionForAdvisor@undoBean@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionTextStrong" textBinding="undoRetentionForAdvisor@undoBean@servletRequest"/>
                  <uix:messagePrompt promptBinding="CURR_UNDO_TBS_SIZE@msgBundle@servletRequest"/>
                  <uix:styledText textBinding="currundosize@servletRequest" styleClass="OraInstructionTextStrong" />
                </uix:labeledFieldLayout>
              </uix:case>
            </uix:switcher>
          </uix:pageStatus>

          <uix:separator/>

          <uix:switcher childNameBinding="undoMode@servletRequest">
            <uix:case name="AUTO">
              <uix:rowLayout>
                <uix:styledText styleClass="OraInstructionText" textBinding="instructionForAdvisor@undoBean@servletRequest"/>
              </uix:rowLayout>
            </uix:case>
          </uix:switcher>

          <uix:switcher childNameBinding="undoMode@servletRequest">
            <uix:case name="AUTO">
              <uix:header textBinding="ADVISOR_HEADER@msgBundle@servletRequest">
                <uix:contents>
                  <uix:labeledFieldLayout labelWidth="25%">
                    <uix:messageTextInput id="currundoret"
                      name="currundoret"
                      promptBinding="NEW_UNDO_RETENTION@msgBundle@servletRequest"
                      textBinding="currundoret@servletRequest"
                      columns="10" 
                      messageBinding="retMsg@retErrors@servletRequest"
                      messageTypeBinding="retMsgType@retErrors@servletRequest"
                      required="uiOnly">
                      <uix:end>
                        <uix:flowLayout>
                          <oem:choice id= "currunit" name="currunit" optionsBinding="units@servletRequest" selectedValueBinding="currunit@servletRequest" shortDescBinding="NEW_UNDO_RETENTION@msgBundle@servletRequest"/>
                        </uix:flowLayout>
                      </uix:end>
                    </uix:messageTextInput>
                    <uix:messagePrompt labeledNodeId="intervalChoice" promptBinding="CHANGE_TIME_INTERVAL@msgBundle@servletRequest"/>
                    <uix:flowLayout>
                    <uix:choice  id="intervalChoice" name="intervalChoice" onChange="submitForm('adviceForm',1,{'event':'changeInterval'});return false"
                                shortDescBinding="CHANGE_TIME_INTERVAL@msgBundle@servletRequest" 
                                selectedValueBinding="intervalChoiceOption@undoBean@servletRequest"> 
                        <uix:contents childDataBinding="analysisTimePeriod@undoBean@servletRequest">
                           <uix:option textBinding="analysisTimePeriodText@undoBean@servletRequest" valueBinding="analysisTimePeriodValue@undoBean@servletRequest"/>
                        </uix:contents>
                    </uix:choice>
                    </uix:flowLayout>
                    <uix:messagePrompt prompt=" "/>
                    <uix:styledText styleClass="OraInlineInfoText" textBinding="INTERVAL_INFO@msgBundle@servletRequest" />
                    <uix:messagePrompt promptBinding="TIME_INTERVAL@msgBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" textBinding="intervalChoiceSelected@undoBean@servletRequest"/>
                  </uix:labeledFieldLayout>

                  <uix:tableLayout width="100%" cellSpacing="0">          
                    <uix:rowLayout vAlign="top">

                        <uix:header textBinding="ANALYSIS_HEADER@msgBundle@servletRequest">
                      <uix:cellFormat width="60%" vAlign="top">
                          <uix:contents>
                            <uix:labeledFieldLayout labelWidth="75%">
                              <uix:messagePrompt promptBinding="NEW_UNDO_SIZE@msgBundle@servletRequest"/>
                              <uix:styledText styleClass="OraInstructionTextStrong" textBinding="requiredTbsSize@undoBean@servletRequest"/>
              		          <uix:messageStyledText promptBinding="labelRequiredRetention@undoBean@servletRequest"
                                styleClass="OraInstructionTextStrong" textBinding="requiredRetention@undoBean@servletRequest"
                                renderedBinding="notAutoTuneRetention@undoBean@servletRequest"/>
                              <uix:messageStyledText promptBinding="REQUIRED_UNDO_SIZE_CURR_RETENTION@msgBundle@servletRequest"
                                styleClass="OraInstructionTextStrong" textBinding="currentUndoSize@undoBean@servletRequest"
                                renderedBinding="isUndoTbsAutoExtend@undoBean@servletRequest"/> 
                              <uix:messageStyledText promptBinding="MAXIMUM_EXTENSIBLE_TABLESPACE@msgBundle@servletRequest"
                                styleClass="OraInstructionTextStrong" textBinding="maximumTablespace@undoBean@servletRequest"
                                renderedBinding="isUndoTbsAutoExtend@undoBean@servletRequest"/> 
                            </uix:labeledFieldLayout>
                          </uix:contents>	
                      </uix:cellFormat>

                      <uix:cellFormat width="40%" vAlign="top">
                          <uix:contents>
                              <uix:messageStyledText promptBinding="labeLowThresholdRetentionForAdvisor@undoBean@servletRequest"
                                styleClass="OraInstructionTextStrong" textBinding="undoRetention@undoBean@servletRequest"
                                renderedBinding="isAutoTuneRetention@undoBean@servletRequest"/>
                              <uix:messageStyledText promptBinding="labelBestRetention@undoBean@servletRequest"
                                styleClass="OraInstructionTextStrong" textBinding="bestRetention@undoBean@servletRequest"
                                renderedBinding="isAutoTuneRetention@undoBean@servletRequest"/>
                          </uix:contents>	
                      </uix:cellFormat>
                        </uix:header>

                    </uix:rowLayout>                
                  </uix:tableLayout> 

                  <%--
                  <uix:header textBinding="TBS_RETENTION_GRAPH_HEADER@msgBundle@servletRequest">
                    <uix:contents>
                      <uix:rawText text="<a href=\"/em/console/database/instance/undoAdvisory?event=graphClick&id=1\" target=\"codeframe\"><img name=\"cacheAdv\" width=\"400\" height=\"350\" border=\"0\" src=\"/em/dynamicImage/database/instance/charts?chartid=7&w=400&h=350\" ismap></a>"/>
                      <uix:tip>
                        <uix:styledText textBinding="ADVICETIP@msgBundle@servletRequest"/>
                      </uix:tip>
                    </uix:contents>	
                  </uix:header>
                  --%>

                  <oem:chart titleBinding="TBS_RETENTION_GRAPH_HEADER@msgBundle@servletRequest"
                    chartType="lineChart"
                    width="500"
                    height="500" 
                    orientation="vertical"
                    xAxisNumberFormatBinding="XAxisNumberFormat@undoBean@servletRequest"
                    xAxisLabelBinding="advisorGraphXLabel@undoBean@servletRequest"
                    yAxisLabelBinding="REQUIRED_UNDO_SIZE@msgBundle@servletRequest"
                    legendVisible="false"
                    seriesSymbolsAutomatic="true"
                    >
                    <uix:contents>
                      <oem:boundChartDataSource 
                        chartDataSourceBinding="advisorDataSource@undoBean@servletRequest"
                      />
                      <oem:annotation
                        annotationDataSourceBinding="advisorAnnotation@undoBean@servletRequest" />
                      <oem:imageMap imageMapItemsBinding="advisorImageMap@undoBean@servletRequest" />
                      <oem:chartColumn
                        isKey="true" 
                        sourceIndex="0"
                      />
                      <oem:chartColumn
                        displayLabel="Tablespace Size"
                        sourceIndex="1"
                      />
                    </uix:contents>
                  </oem:chart>

                  <uix:tip>
                    <uix:styledText textBinding="UNDO_ADVISOR_GRAPH_TIP@msgBundle@servletRequest"/>
                  </uix:tip>

                </uix:contents>
              </uix:header>
            </uix:case>
          </uix:switcher>

          <%-- TEST  --%>
          <%--
          <uix:switcher childNameBinding="undoMode@servletRequest">
            <uix:case name="AUTO">
              <uix:header text="Test Backend Functionality">
                <uix:contents>
                  <uix:labeledFieldLayout labelWidth="20%">
                    <uix:messagePrompt promptBinding="TABLESPACE_NAME@msgBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="undoTableSpace@undoBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="TABLESPACE_SIZE@msgBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="undoTableSpaceSize@undoBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="AUTO_EXTENSIBLE@msgBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="undoTbsAutoExtend@undoBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="UNDO_RETENTION_TUNNING@msgBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="autoTuneRetention@undoBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="UNDO_RETENTION@msgBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="undoRetention@undoBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="UNDO_RETENTION_GUARANTEE@msgBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="retentionGuarantee@undoBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="LONGEST_RUNNING_QUERY@msgBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="longestQuery@undoBean@servletRequest"/>
                      
                    <uix:messagePrompt promptBinding="HEALTH@msgBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="health@undoBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="POTENTIAL_PROBLEMS@msgBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="problem@undoBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="RECOMMENDED_ACTION@msgBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="recommendation@undoBean@servletRequest"/>

                    <uix:messagePrompt promptBinding="UNDO_ADVISOR@msgBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="advisor@undoBean@servletRequest"/>

                    <uix:messagePrompt promptBinding="REQUIRED_UNDO_RETENTION@msgBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="requiredRetention@undoBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="X_POSSIBLE_RETENTION@msgBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="bestRetention@undoBean@servletRequest"/>
                    <uix:messagePrompt prompt="Required undo tablespace size"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="requiredUndoSize@undoBean@servletRequest"/>
          
                  </uix:labeledFieldLayout>	
                </uix:contents>	
              </uix:header>
            </uix:case>
          </uix:switcher>
          --%>

          <uix:tableLayout>
            <uix:switcher childNameBinding="undoMode@servletRequest">
              <uix:case name="MANUAL">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                    <uix:messagePrompt promptBinding="UNDO_MGMT@msgBundle@servletRequest" />
                  </uix:cellFormat>
                  <uix:spacer width="5" />
                  <uix:stackLayout>
                    <uix:styledText textBinding="RBU_UNDO_MGMT@msgBundle@servletRequest" styleClass="OraDataText" />
                  </uix:stackLayout>  
                </uix:rowLayout>
              </uix:case>
            </uix:switcher>
          </uix:tableLayout>
        
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:switcher childNameBinding="undoMode@servletRequest">
                <uix:case name="AUTO">
                  <uix:submitButton textBinding="SHOWSQL@DBObjectBundle@servletRequest" name="event" value="showSql"/>
                </uix:case>
              </uix:switcher>
              <uix:switcher childNameBinding="undoMode@servletRequest">
                <uix:case name="AUTO">
                  <uix:button textBinding="CANCEL@DBObjectBundle@servletRequest" destinationBinding="backURL@servletRequest"/>
                  <%-- <uix:submitButton textBinding="REVERT@DBObjectBundle@servletRequest" name="event" value="revert"/> --%>
                </uix:case>
              </uix:switcher>
              <uix:switcher childNameBinding="undoMode@servletRequest">
                <uix:case name="AUTO">
                  <uix:submitButton textBinding="OK@DBObjectBundle@servletRequest" name="event" value="apply"/>
                  <%-- <uix:button textBinding="APPLY@DBObjectBundle@servletRequest" destinationBinding="applyURL@servletRequest" targetFrame="_top"/> --%>
                  <%-- <uix:submitButton textBinding="APPLY@DBObjectBundle@servletRequest" name="event" value="apply"/> --%>
                </uix:case>
              </uix:switcher>
              <uix:switcher childNameBinding="undoMode@servletRequest">
                <uix:case name="MANUAL">
                  <uix:button text="View Rollback Segments" destination="/console/database/databaseObjectsSearch?event=search&otype=rbsegment"/>
                </uix:case>
              </uix:switcher>
            </uix:pageButtonBar>
          </uix:pageButtons>
          
        </uix:pageLayout>
      </db:form>
      </uix:contents>
    </uix:body>
   
  </uix:document>
    
</uix:renderingContext>
