<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="msg" class="oracle.sysman.emSDK.eml.SDKUIMsg" />
  <oem:setURLEncoder id="renderingContext"/> 

  <uix:document> 

    <uix:metaContainer> 
      <uix:head titleBinding="undoTitle@servletRequest"/> 
    </uix:metaContainer>
    <uix:body>
      <db:form name="adviceForm" method="POST" destination="/console/database/instance/undoAdvisory" copyParams="target,type">
        <uix:pageLayout titleBinding="CUSTOMIZE_INTERVAL@msgBundle@servletRequest" >
          <uix:formValue name="pageName" value="/database/instance/undo/undoAdv_IntervalMgmt"/>
      
          <%@ include file="/database/global.jspf" %>
        

          <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>

          <%@ include file="/database/instance/undo/interval.jspf" %>
        
          <uix:pageButtons>
            <uix:pageButtonBar> 
              <uix:submitButton textBinding="CANCEL@msgBundle@servletRequest" name="event" value="cancelMgmt" unvalidated="true"/>
              <uix:submitButton textBinding="OK@msgBundle@servletRequest" name="event" value="okMgmt"/>
            </uix:pageButtonBar>
          </uix:pageButtons>
          
        </uix:pageLayout>
      </db:form>
    </uix:body>
   
  </uix:document>
    
</uix:renderingContext>

