<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>
<script language="javascript">
bAutomatically = true;
function setOptions()
{
    document.forms[0].currundoret.disabled = document.forms[0].desiredRetentionChoice[0].checked;
    document.forms[0].currunit.disabled = document.forms[0].desiredRetentionChoice[0].checked;
}
function submitOption()
{
  setOptions();
  if (document.forms[0].desiredRetentionChoice[0].checked && !bAutomatically)
    submitForm('adviceForm',1,{'event':'changeIntervalMgmt'});
}
function updateAdvice()
{
  if (document.forms[0].desiredRetentionChoice[0].checked)
    submitForm('adviceForm',1,{'event':'changeIntervalMgmt'});
  else
    submitForm('adviceForm',1,{'event':'updateRetention'});
}
</script>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/> 

  <uix:document> 

    <uix:metaContainer> 
      <uix:head titleBinding="undoManagementTitle@undoBean@servletRequest"/> 
    </uix:metaContainer>
    <uix:body onLoad="bAutomatically=document.forms[0].desiredRetentionChoice[0].checked;setOptions()">
      <db:form name="adviceForm" method="POST" destination="/console/database/instance/undoAdvisory" copyParams="target,type">
        <uix:pageLayout titleBinding="UNDO_MANAGEMENT@msgBundle@servletRequest" >
          <uix:formValue name="pageName" value="/database/instance/undo/undoAdv_Management"/>
      
          <%@ include file="/database/global.jspf" %>
        

          <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
    <uix:pageStatus>
      <uix:styledText styleClass="OraInstructionText" 
                      textBinding="INSTRUCTION_TEXT@msgBundle@servletRequest"/>
    </uix:pageStatus>
    <uix:subTabLayout>

      <%-- property tabs --%>
      <uix:subTabs>
        <uix:subTabBar selectedIndex="0">
          <oem:submitLink textBinding="TAB_ADVICE@msgBundle@servletRequest"
                          shortDescBinding="TAB_ADVICE@msgBundle@servletRequest"
                          onClick="submitForm('adviceForm',1,{'event':'changeIntervalMgmt'})"
                          formName="adviceForm"/>
          <oem:submitLink textBinding="TAB_SYSTEM_ACTIVITY@msgBundle@servletRequest"
                          shortDescBinding="TAB_SYSTEM_ACTIVITY@msgBundle@servletRequest"
                          onClick="submitForm('adviceForm',1,{'event':'systemActivity'})"
                          formName="adviceForm"/>
        </uix:subTabBar>
      </uix:subTabs>

          <uix:switcher childNameBinding="undoMode@servletRequest">
            <uix:case name="AUTO"> 
            <uix:tableLayout width="100%" cellSpacing="2">   
            <uix:rowLayout vAlign="top">     
             <uix:cellFormat vAlign="top" width="45%"> 
              <uix:header textBinding="HEADER_UNDO_SETTINGS@msgBundle@servletRequest">
                <uix:contents>
                  <uix:labeledFieldLayout labelWidth="50%">
                    <uix:switcher childNameBinding="isAutoTuneRetention@undoBean@servletRequest">
                      <uix:case name="true">
                        <uix:messagePrompt promptBinding="lowThreshholdRetentionLabel@undoBean@servletRequest"/>
                      </uix:case>
                      <uix:case name="false">
                        <uix:messagePrompt promptBinding="undoRetentionLabel@undoBean@servletRequest"/>
                      </uix:case>
                    </uix:switcher>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="undoRetention@undoBean@servletRequest"/>
                    
                   <uix:messagePrompt promptBinding="UNDO_RETENTION_GUARANTEE@msgBundle@servletRequest"/>
                    <uix:link textBinding="retentionGuarantee@undoBean@servletRequest" destinationBinding="undodestination@servletRequest" />
                  </uix:labeledFieldLayout>
                </uix:contents>
              </uix:header>
             </uix:cellFormat> 
             <uix:cellFormat vAlign="top" width="55%"> 
              <uix:header textBinding="HEADER_TABLESPACE_INSTANCE@msgBundle@servletRequest">
                <uix:contents>
                  <uix:labeledFieldLayout labelWidth="40%" columns="1" width="100%">
                    <uix:messagePrompt promptBinding="TABLESPACE_NAME@msgBundle@servletRequest"/>
                    <uix:flowLayout>
                      <uix:link textBinding="undoTableSpace@undoBean@servletRequest" destinationBinding="undodestination@servletRequest" />
                      <uix:spacer width="10"/>
                      <uix:submitButton textBinding="CHANGE_TABLESPACE@msgBundle@servletRequest" shortDescBinding="CHANGE_TABLESPACE@msgBundle@servletRequest" name="event" value="switchTablespace"/>
                    </uix:flowLayout>

                    <uix:messagePrompt promptBinding="TABLESPACE_SIZE@msgBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="undoTableSpaceSize@undoBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="AUTO_EXTENSIBLE@msgBundle@servletRequest"/>
                    <uix:link textBinding="undoTbsAutoExtend@undoBean@servletRequest" destinationBinding="undodestination@servletRequest" />
                  </uix:labeledFieldLayout>
                </uix:contents>	
              </uix:header>
             </uix:cellFormat> 
             </uix:rowLayout>     
             </uix:tableLayout>
            </uix:case>
          </uix:switcher>

          <uix:switcher childNameBinding="undoMode@servletRequest">
            <uix:case name="AUTO">
              <uix:header textBinding="HEADER_ADVICE@msgBundle@servletRequest">
                <uix:contents>

                  <uix:rowLayout width="100%">
                    <uix:contents>
                      <uix:cellFormat vAlign="top">
                        <uix:contents>
                          <uix:formattedText styleClass="OraInstructionText" textBinding="MSG_ADVICE_PARAGRAPH_1@msgBundle@servletRequest"/>
                        </uix:contents>
                      </uix:cellFormat>
                    </uix:contents>
                  </uix:rowLayout>

                  <uix:spacer height="10"/>
              <uix:header textBinding="ANALYSIS_PERIOD@msgBundle@servletRequest">
                <uix:contents>

                  <uix:labeledFieldLayout labelWidth="25%">
                    <uix:messagePrompt labeledNodeId="intervalChoice" promptBinding="CHANGE_TIME_INTERVAL@msgBundle@servletRequest"/>
                    <uix:flowLayout>
                    <uix:choice name="intervalChoice" onChange="submitForm('adviceForm',1,{'event':'changeIntervalMgmt'});return false"
                                shortDescBinding="CHANGE_TIME_INTERVAL@msgBundle@servletRequest" id="intervalChoice" 
                                selectedValueBinding="intervalChoiceOption@undoBean@servletRequest"> 
                        <uix:contents childDataBinding="analysisTimePeriod@undoBean@servletRequest">
                           <uix:option textBinding="analysisTimePeriodText@undoBean@servletRequest" valueBinding="analysisTimePeriodValue@undoBean@servletRequest"/>
                        </uix:contents>
                    </uix:choice>
                    </uix:flowLayout>

                    <uix:messagePrompt promptBinding="DESIRED_UNDO_RETENTION@msgBundle@servletRequest"/>
                    <uix:radioButton nodeID="desiredRetention1" name="desiredRetentionChoice" value="desiredRetention1" textBinding="ANALYSIS_LONGEST_QUERY@msgBundle@servletRequest" selectedBinding="automatically@undoBean@servletRequest" onClick="submitOption()"/>
                    <uix:messagePrompt prompt=""/>
                    <uix:radioButton nodeID="desiredRetention2" name="desiredRetentionChoice" value="desiredRetention2" textBinding="ANALYSIS_LONGER_DURATION_QUERY@msgBundle@servletRequest" selectedBinding="manually@undoBean@servletRequest" onClick="setOptions()" />
                    <uix:messagePrompt prompt=""/>
                    <uix:flowLayout>
                      <uix:spacer width="18"/>
                      <uix:messagePrompt labeledNodeId="DURATION" promptBinding="DURATION@msgBundle@servletRequest"/>
                      <uix:textInput id="currundoret" name="currundoret" shortDescBinding="DURATION@msgBundle@servletRequest" textBinding="currundoret@servletRequest" columns="15"/>
                      <uix:spacer width="5"/>
                      <uix:choice id="DURATION" name="currunit" selectedValueBinding="currentUnit@undoBean@servletRequest">
                        <uix:option textBinding="UNDO_DAYS@msgBundle@servletRequest"
                          value="UNDO_DAYS"/> 
                        <uix:option textBinding="UNDO_HOURS@msgBundle@servletRequest"
                          value="UNDO_HOURS"/>
                        <uix:option textBinding="UNDO_MINUTES@msgBundle@servletRequest"
                          value="UNDO_MINUTES"/>
                        <uix:option textBinding="UNDO_SECONDS@msgBundle@servletRequest"
                          value="UNDO_SECONDS" />  
                      </uix:choice>
                    </uix:flowLayout>
                    <uix:messagePrompt prompt=""/>
                    <uix:flowLayout>
                     <uix:spacer height="15"/>
                     <uix:submitButton textBinding="RUN_ANALYSIS@msgBundle@servletRequest" shortDescBinding="UPDATE_ADVICE_GRAPH@msgBundle@servletRequest" name="event" value="updateRetention" onClick="updateAdvice();return false;" />
                    </uix:flowLayout>
                  </uix:labeledFieldLayout>
           <uix:header textBinding="ANALYSIS_RESULTS@msgBundle@servletRequest">
                <uix:contents>
                     <uix:tableLayout width="100%" cellSpacing="2">   
                      <uix:rowLayout width="100%" vAlign="top">
                       <uix:cellFormat hAlign="right">
                        <uix:button textBinding="editTablespaceLabel@undoBean@servletRequest" shortDescBinding="editTablespaceLabel@undoBean@servletRequest" destinationBinding="editTbsURL@servletRequest"/>
                        <uix:spacer width="5"/>
                        <uix:button textBinding="EDIT_UNDO_RETENTION@msgBundle@servletRequest" shortDescBinding="EDIT_UNDO_RETENTION@msgBundle@servletRequest" destinationBinding="editUndoRetentionURL@servletRequest" />
                       </uix:cellFormat>
                      </uix:rowLayout>
                     </uix:tableLayout>
                            <uix:labeledFieldLayout labelWidth="35%">
                    <uix:messagePrompt promptBinding="TIME_INTERVAL@msgBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" textBinding="intervalChoiceSelected@undoBean@servletRequest"/>
                              <uix:messagePrompt promptBinding="MIN_REQ_UNDO_TB_SIZE@msgBundle@servletRequest"/>
                              <uix:styledText styleClass="OraInstructionTextStrong" textBinding="requiredTbsSize@undoBean@servletRequest"/>
              		          <uix:messageStyledText promptBinding="labelRequiredRetention@undoBean@servletRequest"
                                styleClass="OraInstructionTextStrong" textBinding="requiredRetention@undoBean@servletRequest"
                                renderedBinding="notAutoTuneRetention@undoBean@servletRequest"/>
                              <uix:messageStyledText promptBinding="RECOMMENDED_UNDO_TB_SIZE@msgBundle@servletRequest"
                                styleClass="OraInstructionTextStrong" textBinding="currentUndoSize@undoBean@servletRequest"
                                renderedBinding="isUndoTbsAutoExtend@undoBean@servletRequest"/> 
                            </uix:labeledFieldLayout>
                 <uix:switcher childNameBinding="isUndoTbsAutoExtend@undoBean@servletRequest">
                   <uix:case name="true">
                     <uix:tableLayout width="100%" cellSpacing="0">   
                      <uix:rowLayout width="100%" vAlign="top">
                       <uix:cellFormat hAlign="left" width="10%">
                        <uix:spacer width="1"/>
                       </uix:cellFormat>
                       <uix:cellFormat hAlign="left">
                         <uix:tip>
                           <uix:styledText styleClass="OraTipText" textBinding="HINT_RECOMMENDED_SIZE@msgBundle@servletRequest" />
                         </uix:tip>
                       </uix:cellFormat>
                      </uix:rowLayout>
                     </uix:tableLayout>
                   </uix:case>
                 </uix:switcher>		   
                   <uix:rawText text="<br>"/>
                    <uix:styledText styleClass="OraInstructionText"
		    textBinding="WARNING_ANALYSIS_PERIOD@msgBundle@servletRequest" renderedBinding="snapshotError@undoBean@servletRequest"/>

                  <uix:labeledFieldLayout labelWidth="35%">
                    <uix:messagePrompt promptBinding="POTENTIAL_PROBLEMS@msgBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="problem@undoBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="RECOMMENDED_ACTION@msgBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" 
                      textBinding="recommendation@undoBean@servletRequest"/>
                    <uix:switcher childNameBinding="showRationale@undoBean@servletRequest">
                      <uix:case name="true">
                        <uix:messagePrompt promptBinding="RECOMMENDATION_RATIONALE@msgBundle@servletRequest"/>
                      </uix:case>
                    </uix:switcher>
                    <uix:switcher childNameBinding="showRationale@undoBean@servletRequest">
                      <uix:case name="true">
                        <uix:styledText styleClass="OraInstructionTextStrong" textBinding="rationale@undoBean@servletRequest"/>
                      </uix:case>
                    </uix:switcher>
                  </uix:labeledFieldLayout>
                      <uix:hideShow disclosedBinding="showGraph@undoBean@servletRequest"
                        formSubmitted="true" id="hideShow"
                        undisclosedTextBinding="SHOW_DETAILS@msgBundle@servletRequest"
                        disclosedTextBinding="HIDE_DETAILS@msgBundle@servletRequest">
                        <uix:contents>
                  <oem:chart titleBinding="MSG_TS_BY_LONGEST_QUERY@msgBundle@servletRequest"
                    chartType="lineChart"
                    width="500"
                    height="500" 
                    orientation="vertical"
                    xAxisNumberFormatBinding="XAxisNumberFormat@undoBean@servletRequest"
                    xAxisLabelBinding="advisorGraphXLabel@undoBean@servletRequest"
                    yAxisLabelBinding="REQUIRED_UNDO_SIZE@msgBundle@servletRequest"
                    legendVisible="false"
                    seriesSymbolsAutomatic="true"
                    >
                    <uix:contents>
                      <oem:boundChartDataSource chartDataSourceBinding="advisorDataSource@undoBean@servletRequest"/>
                      <oem:annotation annotationDataSourceBinding="advisorAnnotation@undoBean@servletRequest" />
                      <oem:imageMap imageMapItemsBinding="advisorImageMap@undoBean@servletRequest" />
                      <oem:chartColumn isKey="true" sourceIndex="0" />
                      <oem:chartColumn displayLabel="Tablespace Size" sourceIndex="1"/>
                    </uix:contents>
                  </oem:chart>
                  <uix:tip>
                    <uix:styledText textBinding="MSG_TIP_ANIMATED_GRAPH@msgBundle@servletRequest"/>
                  </uix:tip>
                        </uix:contents>
                      </uix:hideShow>
                </uix:contents>
                  </uix:header>
                  
                </uix:contents>	
               </uix:header>
                </uix:contents>
              </uix:header>
            </uix:case>
          </uix:switcher>

          <uix:switcher childNameBinding="undoMode@servletRequest">
            <uix:case name="NON_SVRMGMT">
              <uix:rowLayout>
                <uix:styledText styleClass="OraInstructionText" textBinding="NON_SVRMGMT_INSTRUCTION@msgBundle@servletRequest"/>
              </uix:rowLayout>
            </uix:case>
          </uix:switcher>

          <uix:switcher childNameBinding="undoMode@servletRequest">
            <uix:case name="MANUAL">
              <uix:rowLayout>
                <uix:formattedText styleClass="OraInstructionText" textBinding="tbsSizeMigrationMesg@undoBean@servletRequest"/>
              </uix:rowLayout>
            </uix:case>
          </uix:switcher>
       </uix:subTabLayout>

       <uix:pageButtons>
        <uix:switcher childNameBinding="manually@undoBean@servletRequest">
         <uix:case name="true">
            <uix:pageButtonBar>
              <uix:switcher childNameBinding="undoMode@servletRequest">
                <uix:case name="AUTO">
                  <uix:submitButton textBinding="SHOWSQL@DBObjectBundle@servletRequest" shortDescBinding="SHOWSQL@DBObjectBundle@servletRequest" name="event" value="showSql" onClick="if (document.forms[0].currundoret.disabled) return false"/>
                </uix:case>
              </uix:switcher>
              <uix:switcher childNameBinding="undoMode@servletRequest">
                <uix:case name="AUTO">
                  <uix:submitButton textBinding="APPLY@DBObjectBundle@servletRequest" shortDescBinding="APPLY@DBObjectBundle@servletRequest" name="event" value="apply" />
                </uix:case>
              </uix:switcher>
            </uix:pageButtonBar>
         </uix:case>
        </uix:switcher>
       </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>
   
  </uix:document>
    
</uix:renderingContext>
