<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer> 
      <uix:head titleBinding="undoTitle@servletRequest"/> 
    </uix:metaContainer>

    <uix:body>
      <db:form name="adviceForm" method="POST" destination="/console/database/instance/undoAdvisory" copyParams="target,type">
        <uix:pageLayout titleBinding="CHANGE_TABLESPACE_TITLE@msgBundle@servletRequest" >
          <uix:formValue name="pageName" value="/database/instance/undo/undoAdv_Tablespace"/>
	  <uix:formValue name="event" value="searchTablespace" />

          <!-- for breadcrumbs support; plus standard label, links, tabs, etc -->
          <%@ include file="/database/global.jspf" %>

          <uix:pageStatus>
            <uix:labeledFieldLayout labelWidth="35%" columns="2" width="100%">
              <uix:messagePrompt promptBinding="CUR_TABLESPACE_NAME@msgBundle@servletRequest"/>
              <uix:styledText styleClass="OraInstructionTextStrong" textBinding="undoTableSpace@undoBean@servletRequest"/>
              <uix:messagePrompt promptBinding="CUR_TABLESPACE_SIZE@msgBundle@servletRequest"/>
              <uix:styledText textBinding="undoTableSpaceSize@undoBean@servletRequest" styleClass="OraInstructionTextStrong" />
            </uix:labeledFieldLayout>
          </uix:pageStatus>

          <uix:separator/>

          <uix:rowLayout>
              <uix:styledText 	styleClass="OraInstructionText"
                textBinding="SEARCH_INSTRUCTION@msgBundle@servletRequest"/>
          </uix:rowLayout>

          <uix:spacer height="10"/>

          <uix:tableLayout width="100%">
            <uix:rowLayout hAlign="left">
              <uix:cellFormat>
                <uix:flowLayout>
                  <uix:styledText labeledNodeId="searchName"  styleClass="OraInstructionText"
                    textBinding="SEARCH_TABLESPACE@msgBundle@servletRequest"/>
                  <uix:textInput  id="searchName"  textBinding="searchName@undoBean@servletRequest"
                    columns="15"
                    name="searchName"/>
                  <uix:spacer width="5"/>
                  <uix:submitButton textBinding="GO@msgBundle@servletRequest"
                    name="event"
                    value="searchTablespace" />
                </uix:flowLayout>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>

          <oem:table width="100%" blockSize="10" 	
            alternateTextBinding="NO_ITEMS_FOUND@msgBundle@servletRequest"
            beanKey="undoBean"
            name="selectUndoTablespace"
            formSubmitted="true"
            dataSourceProp="selectUndoTablespace"
            copyParams="target,type">
            <uix:tableSelection>
              <oem:singleSelection shortDescBinding="SELECT@msgBundle@servletRequest" selectedIndexBinding="selectedIndex@undoBean@servletRequest"/>
            </uix:tableSelection>
          </oem:table>

          <uix:pageButtons>
            <uix:pageButtonBar> 
              <uix:submitButton textBinding="CANCEL@msgBundle@servletRequest" name="event" value="cancelMgmt" unvalidated="true"/>
              <uix:submitButton textBinding="OK@msgBundle@servletRequest" name="event" value="doSwitchTbs"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
            
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
