<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 

  <uix:document> 

    <uix:metaContainer> 
      <uix:head titleBinding="adviceTitle@servletRequest"/> 
      
    </uix:metaContainer> 
    <uix:body>
    <db:form name="adviceForm" method="POST" destination="/console/database/instance/undo" copyParams="target,type,oname,cancelURL">
    <uix:pageLayout titleBinding="UNDO_CHART_TITLE@msgBundle@servletRequest" >
    <uix:formValue name="pageName" value="/database/instance/undo/undoAdvice"/>
    <uix:formValue name="requiredTbsSizefv" valueBinding="requiredTbsSize@servletRequest"/>
      
        <%@ include file="/database/global.jspf" %>
        

        <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
        <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:switcher childNameBinding="undoMode@servletRequest">
            <uix:case name="AUTO">
              <uix:header textBinding="CURRENT_UNDO_SETTINGS@msgBundle@servletRequest">
                <uix:contents>
                  <uix:labeledFieldLayout labelWidth="20%">
                    <uix:messagePrompt promptBinding="UNDO_MGMT@msgBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" textBinding="undoType@servletRequest"/>

                    <uix:messagePrompt promptBinding="labelCurrentUndoRetention@undoBean@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" textBinding="realCurrentUndoRetention@undoBean@servletRequest"/>
                
                    <uix:messagePrompt promptBinding="CURR_UNDO_TBS@msgBundle@servletRequest"/>
                    <uix:link textBinding="currundotbs@servletRequest" destinationBinding="undodestination@servletRequest" />
                
                    <uix:messagePrompt promptBinding="CURR_UNDO_TBS_SIZE@msgBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" textBinding="currundosize@servletRequest"/>
                  </uix:labeledFieldLayout>
                </uix:contents>	
              </uix:header>
            </uix:case>
          </uix:switcher>
          
          <uix:switcher childNameBinding="undoMode@servletRequest">
            <uix:case name="AUTO">
              <uix:header textBinding="UNDO_GENERATION_RATE@msgBundle@servletRequest">
                <uix:contents>
                  <uix:labeledFieldLayout labelWidth="20%">
                    <uix:messagePrompt promptBinding="AVG_UNDO_RATE@msgBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" textBinding="avgundorate@servletRequest"/>
                    <uix:messagePrompt promptBinding="MAX_UNDO_RATE@msgBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong" textBinding="maxundorate@servletRequest"/>
                  </uix:labeledFieldLayout>
                </uix:contents>	
              </uix:header>
            </uix:case>
          </uix:switcher>
          
          <uix:switcher childNameBinding="undoMode@servletRequest">
            <uix:case name="AUTO">
              <uix:header textBinding="SET_RETENTION@msgBundle@servletRequest">
                <uix:contents>
                  <uix:labeledFieldLayout labelWidth="20%">
                    <uix:messageTextInput id="currundoret"
                      name="currundoret"
                      promptBinding="CURR_UNDO_RET@msgBundle@servletRequest"
                      textBinding="currundoret@servletRequest"
                      columns="10" 
                      messageBinding="retMsg@retErrors@servletRequest"
                      messageTypeBinding="retMsgType@retErrors@servletRequest"
                      required="uiOnly">
                      <uix:end>
                        <uix:flowLayout>
                          <oem:choice id="currunit" name="currunit" optionsBinding="units@servletRequest" selectedValueBinding="currunit@servletRequest"/>
                          <uix:spacer width="10"/>
                          <uix:submitButton textBinding="UPDATE_GRAPH@msgBundle@servletRequest" name="event" value="go"/>
                        </uix:flowLayout>
                      </uix:end>
                    </uix:messageTextInput>

                    <uix:switcher childNameBinding="isHighlightPointOutOfRange@undoBean@servletRequest">
                      <uix:case name="true">
                        <uix:messagePrompt prompt=""/>
                      </uix:case>
                    </uix:switcher>
                    <uix:switcher childNameBinding="isHighlightPointOutOfRange@undoBean@servletRequest">
                      <uix:case name="true">
                        <uix:styledText styleClass="OraInlineInfoText" textBinding="HIGHLIGHT_OUT_RANGE@msgBundle@servletRequest"/>
                      </uix:case>
                    </uix:switcher>
                  </uix:labeledFieldLayout>

                  <%--
                  <uix:rawText text="<a href=\"/em/console/database/instance/undo?event=graphClick&id=1\" target=\"codeframe\"><img name=\"cacheAdv\" width=\"400\" height=\"350\" border=\"0\" src=\"/em/dynamicImage/database/instance/charts?chartid=6&w=400&h=350\" ismap></a>"/>
                  --%>
                  
                  <uix:rawText textBinding="undoGraphURL@undoBean@servletRequest"/>
                  <uix:tip>
                    <uix:styledText textBinding="ADVICETIP@msgBundle@servletRequest"/>
                  </uix:tip>
                  
                </uix:contents>	
              </uix:header>
            </uix:case>
          </uix:switcher>
        <%--
        <uix:switcher childNameBinding="undoMode@servletRequest">
          <uix:case name="AUTO">
            <uix:rawText text="<a href=\"/em/console/database/instance/undo?event=graphClick&id=1\" target=\"codeframe\"><img name=\"cacheAdv\" width=\"400\" height=\"350\" border=\"0\" src=\"/em/dynamicImage/database/instance/charts?chartid=6&w=400&h=350\" ismap></a>"/>
          </uix:case>
        </uix:switcher>

        <uix:switcher childNameBinding="undoMode@servletRequest">
          <uix:case name="AUTO">
            <uix:tip>
              <uix:styledText textBinding="ADVICETIP@msgBundle@servletRequest"/>
            </uix:tip>
          </uix:case>
        </uix:switcher>
        --%>
        <uix:tableLayout>
        <uix:switcher childNameBinding="undoMode@servletRequest">
          <uix:case name="MANUAL">
            <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:messagePrompt promptBinding="UNDO_MGMT@msgBundle@servletRequest" />
                </uix:cellFormat>
                <uix:spacer width="5" />
     	          <uix:stackLayout>
                  <uix:styledText textBinding="RBU_UNDO_MGMT@msgBundle@servletRequest" styleClass="OraDataText" />
                </uix:stackLayout>
                
              </uix:rowLayout>
              </uix:case>
         </uix:switcher>

        
        </uix:tableLayout>  
         <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:switcher childNameBinding="undoMode@servletRequest">
              <uix:case name="AUTO">
                <uix:submitButton textBinding="SHOWSQL@DBObjectBundle@servletRequest" name="event" value="showSql"/>
              </uix:case>
            </uix:switcher>
            
            <uix:switcher childNameBinding="undoMode@servletRequest">
              <uix:case name="AUTO">
                <uix:submitButton textBinding="REVERT@DBObjectBundle@servletRequest" name="event" value="revert" unvalidated="true"/>
              </uix:case>
            </uix:switcher>
            <uix:switcher childNameBinding="undoMode@servletRequest">
              <uix:case name="AUTO">
                <uix:submitButton textBinding="APPLY@DBObjectBundle@servletRequest" name="event" value="apply"/>
              </uix:case>
           </uix:switcher>
           <uix:switcher childNameBinding="undoMode@servletRequest">
              <uix:case name="MANUAL">
                <uix:button text="View Rollback Segments" destination="/console/database/databaseObjectsSearch?event=search&otype=rbsegment"/>
              </uix:case>
           </uix:switcher>
          </uix:pageButtonBar>
        </uix:pageButtons>
      </uix:pageLayout>
      </db:form>
      </uix:body>
   
    </uix:document>
    
  </uix:renderingContext>
