<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

    
    <uix:pageLayout>
      <%@ include file="/database/global.jspf" %>

    <uix:switcher childNameBinding="refreshChoice@servletRequest">
      <uix:case name="15">
        <uix:rawText>
          <meta http-equiv="Refresh" content="<%=request.getAttribute("refreshChoice") %>" >
        </uix:rawText>
      </uix:case>
    </uix:switcher>

    <uix:form name="waitHistForm" destinationBinding="onChangeRefreshChoiceDest@servletRequest">
    
      <uix:tableLayout width="100%">

        <uix:rowLayout>
          <uix:stackLayout>
      <uix:header textBinding="header@waitHistogramBean@servletRequest">

        
        
          <uix:flowLayout>
          <uix:tableLayout width="100%">
            <uix:rowLayout>

               
              <uix:cellFormat hAlign="right" >
                <uix:flowLayout>
  
            <uix:rowLayout>
                <uix:styledText styleClass="OraTipText" 
                               textBinding="PAGE_REFRESHED@DBMsgBundle@servletRequest" />
                <uix:spacer width="10"/>
                <uix:styledText styleClass="OraTipLabel" 
                              textBinding="retrievalTime@waitHistogramBean@servletRequest"/>
                <uix:spacer width="10"/>

                  <uix:button textBinding="REFRESH@SDKBundle@servletRequest"
                  destinationBinding="refreshDest@servletRequest" />
  
                  <uix:spacer width="10" />
  
                    <uix:styledText styleClass="OraFieldText" 
                      textBinding="VIEW_DATA@DBMsgBundle@servletRequest" 
                      labeledNodeId="ViewLabel" />
                        
                     <uix:spacer width="5" />
                     
                        <uix:choice name="refreshChoice"
                                id="ViewLabel"
                                onChange="submitForm('waitHistForm', true, {'event':'changeRefreshChoice'})">
                            <uix:option textBinding="REAL_TIME_AUTO_15_SEC@DBMsgBundle@servletRequest"
                                value="15"/>
                            <uix:option textBinding="REAL_TIME_MANUAL@DBMsgBundle@servletRequest"
                                value="-1" selectedBinding="manualRefresh@waitHistogramBean@servletRequest"/>
                        </uix:choice>    
  

  
                </uix:rowLayout>
  
                 </uix:flowLayout>
                </uix:cellFormat>  
              </uix:rowLayout>
        </uix:tableLayout>
      </uix:flowLayout>
        
        
        
        
        
        
        
        
        
        
        
        
        
        <uix:tableLayout width="100%">
          <uix:rowLayout hAlign="right">
            <uix:cellFormat>
              
            </uix:cellFormat>
          </uix:rowLayout>
          
          
          
          
          <uix:rowLayout>
            <uix:stackLayout>                
              <uix:tableLayout hAlign="left">                  
                <uix:rowLayout hAlign="center"> 
                  <oem:chart titleBinding="WAIT_PER_DURATION@DBMsgBundle@servletRequest"
                                chartType="barChart"
                                width="800"
                                height="300"
                                orientation="vertical"
                                legendVisible="false"
                                xAxisLabelBinding="WAIT_DURATION_MSEC@DBMsgBundle@servletRequest"
                                noDataMessageBinding="NO_WAIT_EVENTS@DBMsgBundle@servletRequest">
                    <oem:boundChartDataSource
                        chartDataSourceBinding="histogramDataSource@waitHistogramBean@servletRequest"/>
                    <oem:chartColumn isKey="true"
                                displayLabelBinding="WAIT_DURATION_MSEC@DBMsgBundle@servletRequest"
                                sourceIndex="0" />
                    <oem:chartColumn displayLabelBinding="WAIT_OCCURENCES@DBMsgBundle@servletRequest"
                                itemColor="blue"
                                sourceIndex="1"/>
                  </oem:chart>

                </uix:rowLayout>                
              </uix:tableLayout>              
            </uix:stackLayout>            
          </uix:rowLayout>          
          
        </uix:tableLayout>

      </uix:header>        
          </uix:stackLayout>
        </uix:rowLayout>
      </uix:tableLayout>
      </uix:form>
    </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>


