<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>


  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <uix:pageLayout>
    <%@ include file="/database/global.jspf" %>
    
    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>

    <db:form name="foo" method="POST" destination="/console/database/instance/workloadRepos"
      copyParams="target,type">

    <uix:formValue name="event" value="doLoad" />  

    <uix:header textBinding="header@workloadReposBean@servletRequest">

    <%@ include file="../refreshTime.jspf" %>

    <uix:messagePrompt promptBinding="WORKLOAD_REPOS_INSTR@DBMsgBundle@servletRequest"/>
    
    <uix:tableLayout width="50%" cellSpacing="2">
    <uix:rowLayout vAlign="top">

      <uix:cellFormat vAlign="top" width="50%">
      <uix:header textBinding="GENERAL@DBMsgBundle@servletRequest">

        <uix:stackLayout>

        <uix:rowLayout hAlign="right">
           <uix:button textBinding="EDIT@DBMsgBundle@servletRequest"
             destinationBinding="editSettingsLink@servletRequest" />
         </uix:rowLayout>
         
         <uix:spacer height="20" />

          <uix:tableLayout>

            <uix:rowLayout>
              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                  <uix:styledText styleClass="OraPromptText"
                    textBinding="SNAPSHOT_RETENTION_DAYS@DBMsgBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:spacer width="8"/>
              <uix:cellFormat hAlign="left" wrappingDisabled="true">
                <uix:styledText styleClass="OraDataText"
                  textBinding="retentionTimeForDisplay@workloadReposBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>


            <uix:rowLayout>
              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                  <uix:styledText styleClass="OraPromptText"
                    textBinding="SNAPSHOT_INTERVAL@DBMsgBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:spacer width="8"/>
              <uix:cellFormat hAlign="left" wrappingDisabled="true">
                <uix:styledText styleClass="OraDataText"
                  textBinding="snapIntervalForDisplay@workloadReposBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>


            <uix:rowLayout>
              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                  <uix:styledText styleClass="OraPromptText"
                    textBinding="COLLECTION_LEVEL@DBMsgBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:spacer width="8"/>
              <uix:cellFormat hAlign="left" wrappingDisabled="true">
                <uix:styledText styleClass="OraDataText"
                  textBinding="collectionLevel@workloadReposBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>


            <uix:rowLayout>
              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                  <uix:styledText styleClass="OraPromptText"
                    textBinding="NEXT_CAPTURE_TIME@DBMsgBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:spacer width="8"/>
              <uix:cellFormat hAlign="left" wrappingDisabled="true">
                <uix:styledText styleClass="OraDataText"
                  textBinding="nextSnapshotTime@workloadReposBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
            
          </uix:tableLayout>
        </uix:stackLayout>


      </uix:header>

      <uix:header textBinding="manageSnapsSectionHeader@workloadReposBean@servletRequest">

        <uix:stackLayout>

          <uix:rowLayout hAlign="right">
           <uix:button textBinding="AWR_REPORT@DBMsgBundle@servletRequest"
             destinationBinding="runAWRReport@servletRequest" />
           <uix:button textBinding="AWR_DIFF_REPORT@DBMsgBundle@servletRequest"
             destinationBinding="runAWRDiffReport@servletRequest"/>
         </uix:rowLayout>

         <uix:spacer height="20" />

          <uix:tableLayout>


            <uix:rowLayout>
              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                  <uix:styledText styleClass="OraPromptText"
                    textBinding="SNAPSHOTS@DBMsgBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:spacer width="8"/>
              <uix:cellFormat hAlign="left" wrappingDisabled="true">
                <oem:license>
                 <uix:link destinationBinding="snapshotsLink@servletRequest"
                  textBinding="snapshotCount@workloadReposBean@servletRequest"/>                
                </oem:license>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                  <uix:styledText styleClass="OraPromptText"
                    textBinding="baselinesMsg@workloadReposBean@servletRequest"/>
              </uix:cellFormat>
              <uix:spacer width="8"/>
              <uix:cellFormat hAlign="left" wrappingDisabled="true">
               <oem:license>
                <uix:link 
                  textBinding="baselineCount@workloadReposBean@servletRequest"
                  destinationBinding="baselinesLink@servletRequest" />
                </oem:license>
              </uix:cellFormat>
            </uix:rowLayout>

          
            <uix:rowLayout>
              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                  <uix:styledText styleClass="OraPromptText"
                    textBinding="LATEST_TIMESTAMP@DBMsgBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:spacer width="8"/>
              <uix:cellFormat hAlign="left" wrappingDisabled="true">
                <uix:styledText styleClass="OraDataText"
                  textBinding="mostRecentTimestamp@workloadReposBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:cellFormat hAlign="right" wrappingDisabled="true">
                  <uix:styledText styleClass="OraPromptText"
                    textBinding="EARLIEST_TIMESTAMP@DBMsgBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:spacer width="8"/>
              <uix:cellFormat hAlign="left" wrappingDisabled="true">
                <uix:styledText styleClass="OraDataText"
                  textBinding="earliestTimestamp@workloadReposBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
            

          </uix:tableLayout>
        </uix:stackLayout>

      </uix:header>

      
      </uix:cellFormat>

    </uix:rowLayout>                      
    </uix:tableLayout>
    </uix:header>


    </db:form>    
    </uix:pageLayout>
    </uix:body>

  </uix:document>
</uix:renderingContext>

