<%-- 
 * Copyright (c) 2006, Oracle. All rights reserved.  
 *
 *      NAME
 *       workloadReposSettings.jsp
 *
 *      NOTES
 *       Automatic Workload Repository Edit page.
 *
 * MODIFIED
 *    kmckeen    08/09/06 - Bug 5446813 - disable Execute SQL for db control
--%>

<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>


  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" method="POST" destination="/console/database/instance/workloadRepos"
      copyParams="target,type">
     <uix:formValue name="pageName" value="/database/instance/workload/workloadReposSettings"/>
    <uix:pageLayout titleBinding="EDIT_SETTINGS@DBMsgBundle@servletRequest">
    <%@ include file="/database/global.jspf" %>

    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
    
    <uix:tableLayout width="50%" cellSpacing="2"> 
    <uix:rowLayout vAlign="top">

      <uix:cellFormat vAlign="top" width="50%">

        <uix:rowLayout vAlign="top">

        <uix:cellFormat vAlign="top" >
          <uix:styledText styleClass="OraPromptText"
              textBinding="SNAPSHOT_RETENTION@DBMsgBundle@servletRequest" />
        </uix:cellFormat> 

          <uix:stackLayout>

            <uix:rowLayout>
              <uix:radioButton name="purgingChoice" 
                selectedValueBinding="purgingChoice@workloadReposBean@servletRequest"
                textBinding="TIME_BASED_RETENTION@DBMsgBundle@servletRequest"
                value="1"  />
             </uix:rowLayout>
             
             <uix:rowLayout>
              <uix:spacer width="20" />  
              <uix:styledText styleClass="OraPromptText"
              textBinding="RETENTION_PERIOD@DBMsgBundle@servletRequest" 
              labeledNodeId="retention"/>
              <uix:spacer width="5" />  
              <uix:textInput name="retentionTimeForSetting" columns="10"
                  textBinding="retentionTime@workloadReposBean@servletRequest"
                  id="retention" >
               <uix:onSubmitValidater><uix:decimal/></uix:onSubmitValidater>   
             </uix:textInput>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:radioButton name="purgingChoice" 
                selectedValueBinding="purgingChoice@workloadReposBean@servletRequest"
                textBinding="MANUAL_PURGING@DBMsgBundle@servletRequest"
                value="0"  />
            </uix:rowLayout>

        </uix:stackLayout>

        </uix:rowLayout>


        <uix:rowLayout vAlign="top">
        
          <uix:cellFormat vAlign="top" >
            <uix:styledText styleClass="OraPromptText"
                textBinding="SNAPSHOT_COLLECTION@DBMsgBundle@servletRequest" />
          </uix:cellFormat> 


          <uix:stackLayout>

            <uix:rowLayout>
              <uix:radioButton name="collectionChoice" 
                  selectedValueBinding="collectionChoice@workloadReposBean@servletRequest"
                  textBinding="SYS_SNAP_INTERVAL@DBMsgBundle@servletRequest"
                  value="1"  />
            </uix:rowLayout>  

             <uix:rowLayout>
              <uix:spacer width="20" />  
              <uix:styledText styleClass="OraPromptText"
              textBinding="INTERVAL@DBMsgBundle@servletRequest" 
              labeledNodeId="interval" />
              <uix:spacer width="5" />  
              <uix:choice name="snapIntervalForSetting" id="interval"
                selectedValueBinding="snapInterval@workloadReposBean@servletRequest" >
                <uix:contents childDataBinding="intervalChoices@workloadReposBean@servletRequest" >
                  <uix:option textBinding="text" valueBinding="value" />
                </uix:contents>  
             </uix:choice>
            </uix:rowLayout>
            
            <uix:rowLayout>
              <uix:radioButton name="collectionChoice" 
                selectedValueBinding="collectionChoice@workloadReposBean@servletRequest"
                textBinding="TURN_OFF_COLL@DBMsgBundle@servletRequest"
                value="0"  />
            </uix:rowLayout>


          </uix:stackLayout>
          
        </uix:rowLayout>
        
        <uix:spacer height="8"/>

        <uix:rowLayout>
          <uix:cellFormat hAlign="right" wrappingDisabled="true">
              <uix:styledText styleClass="OraPromptText"
               textBinding="COLLECTION_LEVEL@DBMsgBundle@servletRequest" />
          </uix:cellFormat>
          <uix:spacer width="8"/>
          <uix:cellFormat hAlign="left" wrappingDisabled="true">
            <uix:link textBinding="collectionLevel@workloadReposBean@servletRequest"
              destinationBinding="statisticsLevelLink@servletRequest" />
          </uix:cellFormat>
        </uix:rowLayout>


      
      </uix:cellFormat>

    </uix:rowLayout>                      
    </uix:tableLayout>


  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
   <uix:flowLayout >
    <uix:submitButton textBinding="LAUNCH_EXECUTE_SQL@uixDBObjectBundle@servletRequest"
                    renderedBinding="launchExecuteSQLRendered@workloadReposBean@servletRequest"
                    name="event" 
                    value="launchExecuteSQL" />
    <uix:spacer width="10"/>                
    <uix:submitButton textBinding="SHOW_SQL@DBMsgBundle@servletRequest" 
                      name="event" 
                      value="showSQL"/>
    <uix:spacer width="10"/>
    <uix:submitButton textBinding="CANCEL@DBMsgBundle@servletRequest" 
                      name="event" 
                      value="cancel"/>
    <uix:spacer width="10"/>
    <uix:submitButton textBinding="OK@DBMsgBundle@servletRequest" 
                      name="event" 
                      value="apply"/>
    </uix:flowLayout>
  </uix:pageButtonBar>
  </uix:pageButtons>
   
    </uix:pageLayout>
    </db:form> 
    </uix:body>

  </uix:document>
</uix:renderingContext>

