<%@ include file="/sdk/oemTop.jspf" %>

<%--
  -- Page:       objPrivsMainPage.jsp
  -- Controller: db/util/invalidObj/invalidObjController.java
  --
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/utils.js"/>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="oraMsgs" class="oracle.sysman.db.rsc.oracle_databaseMsg"/>
<uix:bundle name="sdkMsgs" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>

  <uix:body>
    <db:form name="invalidObjForm" 
             method="post" 
             destinationBinding="destination@objectBean@servletRequest"
             copyParams="target,type,cancelURL,sname,oname,otype" >
    <uix:formValue name="pageName" value="/database/invalidObj/invalidObjectsPage"/>
    <uix:formValue name="source"/>
    <uix:pageLayout titleBinding="header@objectBean@servletRequest">

      <%-- Oracle Logo and Tabs --%>
      <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageType="info" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" 
                        mainTextKey="mainText"/>
        <oem:messageBox messageType="error" 
                        errorTableBinding="errors@servletRequest" 
                        titleTextKey="titleText" 
                        mainTextKey="mainText"/>

          <%-- uix:spacer height="10"/ --%>

          <uix:tableLayout cellSpacing="5"> 
          <uix:rowLayout>
            <uix:tableLayout width="100%"> 
              <uix:rowLayout hAlign="right">
                <uix:cellFormat/>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraTipText" 
                                  textBinding="PAGE_REFRESHED_TIME@sdkMsgs"/>
                  <uix:spacer width="5"/>
                  <uix:styledText styleClass="OraTipLabel" 
                                  textBinding="refreshTimestamp@objectBean@servletRequest"/>
                  <uix:spacer width="5"/>
                  <uix:submitButton textBinding="REFRESH@dbMsgs"
                                    shortDescBinding="REFRESH@dbMsgs"
                                    name="event"
                                    value="refresh"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout> 
          </uix:rowLayout>

          <uix:spacer height="10"/>

          <uix:rowLayout>
          <uix:tableLayout> 
          <uix:rowLayout> 
            <uix:styledText styleClass="OraInstructionText" 
                            textBinding="INVALID_OBJECTS_INSTRUCTION@dbMsgs"/>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:spacer height="15"/>
          </uix:rowLayout>
          <uix:rowLayout> 
            <uix:dataScope currentDataBinding="invalidObjDS@servletRequest">
              <uix:table name="invalidObjTable"
                         id="invalidObjTable"
                         alternateTextBinding="NO_OBJECT_FOUND@dbMsgs"
                         formSubmitted="true"
                         width="100%"
                         tableDataBinding="rowData"
                         minValue="1"
                         valueBinding="startIndex"
                         maxValueBinding="numRows"
                         blockSizeBinding="blockSize"
                         summaryBinding="all_invalid_objects@oraMsgs">
                <uix:tableFormat tableBanding="rowBanding"/>
                   
                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="NAME@dbMsgs"
                                        sortableBinding="onameSort"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:link textBinding="oname" destinationBinding="onameDest"/>
                </uix:column>

                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="TYPE@dbMsgs"
                                        sortableBinding="otypeSort"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:styledText textBinding="otype"/>
                </uix:column>

                <uix:column>
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="STATUS@dbMsgs"
                                        sortableBinding="statusSort"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:styledText textBinding="status"/>
                </uix:column>

                <uix:tableSelection>
                  <uix:multipleSelection selectedBinding="select">
                                         <%--disabledBinding="selectionDisabled">--%>
                    <uix:submitButton textBinding="RECOMPILE@dbMsgs"
                                      shortDescBinding="RECOMPILE@dbMsgs"
                                      name="event"
                                      value="recompile"/>
                    <uix:spacer width="5"/>
                    <uix:submitButton textBinding="DELETE@dbMsgs"
                                      shortDescBinding="DELETE@dbMsgs"
                                      name="event"
                                      value="delete"/>
                  </uix:multipleSelection >
                </uix:tableSelection>
              </uix:table>
            </uix:dataScope> 
            </uix:rowLayout> 

            <uix:rowLayout>
              <uix:tip>
                <uix:styledText styleClass="OraTipText"
                                textBinding="tableRowSelectionTip@objectBean@servletRequest" />
              </uix:tip>
            </uix:rowLayout>

          </uix:tableLayout>
          </uix:rowLayout>
          </uix:tableLayout>

</uix:pageLayout>
</db:form>
</uix:body>
</uix:document>
</uix:renderingContext>

