<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:contents>
        <uix:form name="defaultBeanProcessing" method="post">
          <uix:pageLayout>
            <%@ include file="/enablePPR.jspf" %>
            <%@ include file="/oemGlobal.jspf" %>

            <uix:messages>
              <oem:messageBox
                  messageTypeBinding="messageType@servletRequest"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:header textBinding="procPageHeader@defaultBean@servletRequest" icon="/em/images/processl.gif">
              <uix:borderLayout>
                <uix:left>
                 <uix:messagePrompt promptBinding="whereMessage@defaultBean@servletRequest"/>
                </uix:left>
              </uix:borderLayout>
              <uix:tableLayout width="100%" hAlign="center">
             <uix:switcher childNameBinding="showUserWhereClause@defaultBean@servletRequest" defaultCase="false">
              <uix:case name="true">
                <uix:rowLayout hAlign="center">
                 <uix:cellFormat hAlign="left" >
                  <uix:spacer width="5" />
                  <uix:styledText styleClass="OraDataText" textBinding="whereClause@defaultBean@servletRequest"/>		
                </uix:cellFormat>        
               </uix:rowLayout>
             </uix:case>
            </uix:switcher>
              </uix:tableLayout>

              <uix:tableLayout width="100%" hAlign="center">

                <uix:rowLayout hAlign="center" >
                 <uix:cellFormat hAlign="center">
                  <uix:contents>
                  <uix:spacer width="20" />
                    <uix:messageStyledText
                      contentStyleClass="OraDataText" promptBinding="startingValue@defaultBean@servletRequest"
                      textBinding="startDateTimeOrSCNStr@defaultBean@servletRequest"/>
                  </uix:contents>
                </uix:cellFormat>
               </uix:rowLayout>
          
                <uix:rowLayout hAlign="center" >
                 <uix:cellFormat hAlign="center">
                  <uix:contents>
                      <uix:messageStyledText
                      contentStyleClass="OraDataText" promptBinding="endingValue@defaultBean@servletRequest"
                      textBinding="endDateTimeOrSCNStr@defaultBean@servletRequest"/>
                  </uix:contents>
                </uix:cellFormat>
               </uix:rowLayout>
          
                <uix:rowLayout hAlign="center">
                  <uix:cellFormat hAlign="center">
                    <uix:stackLayout>
                      <uix:contents>
                       <uix:spacer width="20" />
                        <uix:processing id="executeProcessingControl" timeIntervalBinding="refreshRate@defaultBean@servletRequest">
                          <uix:contents>
                            <uix:labeledFieldLayout labelWidth="75%">
                              <uix:contents>
                               <uix:spacer width="10" />
                                <uix:messageStyledText
                                    styleClass="OraDataText" promptBinding="TRANS_FOUND@LogMinerBundle@servletRequest"
                                    textBinding="numTransactions@defaultBean@servletRequest"/>
                                <uix:messageStyledText
                                    styleClass="OraDataText" promptBinding="timeRemainingUnits@defaultBean@servletRequest"
                                    textBinding="timeRemaining@defaultBean@servletRequest"/>
                                <uix:messageStyledText
                                    styleClass="OraDataText" promptBinding="progressSofarUnits@defaultBean@servletRequest"
                                    textBinding="progressSofar@defaultBean@servletRequest"/>
                                <uix:messageStyledText
                                    styleClass="OraDataText" promptBinding="progressTotalUnits@defaultBean@servletRequest"
                                    textBinding="progressTotal@defaultBean@servletRequest"/>
                              </uix:contents>
                            </uix:labeledFieldLayout>
                          </uix:contents>
                        </uix:processing>
                      </uix:contents>                                                              
                      
                    </uix:stackLayout>
                  </uix:cellFormat>
                </uix:rowLayout>

              </uix:tableLayout>
            </uix:header>

         <uix:spacer height="10" />

         <uix:tip> 
           <uix:styledText textBinding="procPageInstrCancel@defaultBean@servletRequest"/>
         </uix:tip>                       
                  
          <uix:pageButtons>
           <uix:pageButtonBar>
            <uix:submitButton name="event" value="cancelProcessing" textBinding="CANCEL@LogMinerBundle@servletRequest"/>
            <uix:submitButton name="event" value="stopProcessing" textBinding="STOP@LogMinerBundle@servletRequest" />
           </uix:pageButtonBar>
        </uix:pageButtons>

          </uix:pageLayout>
        </uix:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

