<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
<%
  String dest = (String)request.getSession().getAttribute("processingDoneDestination");
  if (dest != null)
  {
    PartialPageUtils.forceRedirectURL(renderingContext, dest);
    request.getSession().removeAttribute("processingDoneDestination");
  }
  %>
 
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:metaContainer> 
     <meta http-equiv="Refresh" content=<%=request.getAttribute("refreshChoice") %>>
    </uix:metaContainer> 
    <uix:body>
    <db:form name="resultsForm" destination="/console/database/lm/logminer" method="get" copyParams="target,type">
        <uix:formValue name="pageName" value="/database/lm/lmResults" />
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>

      <uix:pageLayout titleBinding="title@defaultBean@servletRequest">
        <%@ include file="/enablePPR.jspf" %>

        <%@ include file="/database/global.jspf" %>
          <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:hideShowHeader formSubmitted="true" textBinding="SUMMARY@LogMinerBundle@servletRequest" 
            id="hideShowSummary" disclosedBinding="showSummary@defaultBean@servletRequest">
         <uix:contents>

         <uix:tableLayout  cellSpacing="3" width="100%">
           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
              <uix:contents>
              <uix:messagePrompt promptBinding="MATCHING_TRANS@LogMinerBundle@servletRequest"/>
              </uix:contents>
            </uix:cellFormat>
             <uix:cellFormat hAlign="left">
              <uix:styledText styleClass="OraDataText" textBinding="numTransactions@defaultBean@servletRequest"/>
            </uix:cellFormat>
            
             <uix:cellFormat hAlign="right">
              <uix:contents>
               <uix:messagePrompt promptBinding="LM_QUERY@LogMinerBundle@servletRequest"/>
              </uix:contents>
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
              <uix:styledText styleClass="OraDataText" textBinding="whereClause@defaultBean@servletRequest"/>
             </uix:cellFormat>
           </uix:rowLayout>
    
           <uix:rowLayout>
             <uix:cellFormat hAlign="right">
              <uix:contents>
               <uix:messagePrompt promptBinding="MATCHING_RECS@LogMinerBundle@servletRequest"/>
              </uix:contents>
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
              <uix:styledText styleClass="OraDataText" textBinding="totalRecords@defaultBean@servletRequest"/>
             </uix:cellFormat>        
             <uix:cellFormat hAlign="right">
              <uix:contents>
                <uix:messagePrompt promptBinding="TOTAL_TIME1@LogMinerBundle@servletRequest"/>
              </uix:contents>
             </uix:cellFormat>
             <uix:cellFormat hAlign="left">
              <uix:styledText styleClass="OraDataText" textBinding="totalElapsedTime@defaultBean@servletRequest"/>
            </uix:cellFormat>        
           </uix:rowLayout>
          </uix:tableLayout>
          
          <uix:spacer width="5" />
    
         <uix:tableLayout>
           <uix:rowLayout >
             <uix:cellFormat width="100%">
               <uix:styledText styleClass="OraInstructionText" textBinding="introText@defaultBean@servletRequest" /> 
             </uix:cellFormat>
           </uix:rowLayout>       
          </uix:tableLayout>

          <uix:spacer width="5" />
           <uix:switcher childNameBinding="showUserSummary@defaultBean@servletRequest" defaultCase="false">
            <uix:case name="true">
              <oem:table name="logMinerSummaryUI" width="40%" beanKey="defaultBean" blockSize="5" formSubmitted="true"
                dataSourceProp="logMinerSummaryUI" summaryBinding="LM_RESULTS@LogMinerBundle@servletRequest" destination="/console/database/lm/logminer" alternateTextBinding="NO_USERS@LogMinerBundle@servletRequest" />
           </uix:case>
          </uix:switcher>

         </uix:contents> 
        </uix:hideShowHeader>

          <%--  Start of Results section --%>
          <uix:header textBinding="LM_RESULTS@LogMinerBundle@servletRequest">

          <uix:tableLayout cellSpacing="5">
           <uix:rowLayout>
             <uix:contents>
               <uix:cellFormat width="100%" hAlign="left">
                <uix:contents>
                 <uix:messagePrompt promptBinding="SEARCH_SQL@LogMinerBundle@servletRequest" labeledNodeId="searchResults"/>
                 <uix:textInput id="searchResults" name="searchResults" textBinding="searchFilter@defaultBean@servletRequest" columns="20" />
                 <uix:submitButton textBinding="GO@LogMinerBundle@servletRequest" name="event" value="searchSQLRedo" onFocus="true" formName="resultsForm"/>
                </uix:contents>
               </uix:cellFormat>
             </uix:contents>

               <uix:cellFormat width="100%" hAlign="right">
                <uix:contents>
                  <uix:messageChoice promptBinding="VIEW_BY@LogMinerBundle@servletRequest" name="viewBy" 
                        onChange="submitForm('resultsForm', true, {'event':'viewBy'})" selectedValueBinding="viewBy@defaultBean@servletRequest">
                <uix:contents>
                  <uix:option textBinding="TRANS_SUMM@LogMinerBundle@servletRequest" value="1"/>
                  <uix:option textBinding="REDO_RECORD@LogMinerBundle@servletRequest" value="2"/>
                </uix:contents>
              </uix:messageChoice>                 
             </uix:contents>
            </uix:cellFormat>
           </uix:rowLayout>
         </uix:tableLayout>
          
         <uix:switcher childNameBinding="showTxnSumm@defaultBean@servletRequest" defaultCase="false">
          <uix:case name="false">
            <oem:table name="logMinerTxnUIAll" width="100%" beanKey="logMinerTxnDataSourceBeanAll" blockSize="50" formSubmitted="true"
              dataSourceProp="logMinerTxnUIAll" summaryBinding="LM_RESULTS@LogMinerBundle@servletRequest"  destination="/console/database/lm/logminer" alternateTextBinding="NO_TRANSACTIONS@LogMinerBundle@servletRequest" >
           </oem:table>
           </uix:case>

          <uix:case name="true">
            <oem:table name="logMinerTxnUI" width="100%" beanKey="logMinerTxnDataSourceBean" blockSize="50" formSubmitted="true" summaryBinding="LM_RESULTS@LogMinerBundle@servletRequest"
              dataSourceProp="logMinerTxnUI" destination="/console/database/lm/logminer" alternateTextBinding="NO_TRANSACTIONS@LogMinerBundle@servletRequest" >
           </oem:table>
           </uix:case>
            </uix:switcher>

            <uix:switcher childNameBinding="showTxnSumm@defaultBean@servletRequest" defaultCase="false">
              <uix:case name="true">
             <uix:tip> 
               <uix:styledText textBinding="SUMMARY_TIP@LogMinerBundle@servletRequest"/>
             </uix:tip>                       
            </uix:case>
           </uix:switcher>
          </uix:header>

          <%--  End of Results section --%>
                    
      <uix:pageButtons>
        <uix:pageButtonBar>
         <uix:switcher childNameBinding="needsMoreMining@defaultBean@servletRequest" defaultCase="false">
          <uix:case name="true">
            <uix:submitButton  textBinding="CONTINUE_MINING@LogMinerBundle@servletRequest" name="event" value="continueMining" />
           </uix:case>
          </uix:switcher>
          <uix:submitButton  textBinding="BACK@LogMinerBundle@servletRequest" name="event" value="back" />
          <uix:submitButton  textBinding="DONE@LogMinerBundle@servletRequest" name="event" value="cancel" />
        </uix:pageButtonBar>
      </uix:pageButtons>

     </uix:pageLayout>
    </db:form>
   </uix:body>
  </uix:document>
</uix:renderingContext>

