<%@ include file="/sdk/oemTop.jspf" %>
<%-- ================  Database Login Page ===================
   MODIFIED    (MM/DD/YY)
      dchakumk  03/10/08 - XbranchMerge dchakumk_6752_xbmsrc from
                           st_emdbsa_11.1
      chanchan  07/17/07 - 
      xshi      04/17/07 - bug5975240
      gmahaney  02/01/07 - XbranchMerge gmahaney_emdb_pt_main from main
      qsong     01/18/07 - enable sysasm
      qsong     01/24/07 - enable SYSASM login role
      yozhang   11/30/06 - add oemNoscript.jspf for ADA
      qsong     05/10/06 - add sysasm role for asm 11g target
      kdas      08/22/05 - fix for 4376225 
      yma       06/22/05 - Bug 4449918 
      jochen    08/03/04 - Support ASM targets 
      hsu       11/06/03 - add javascript 
      vchao     10/31/03 -
      hsu       10/06/03 - rm svg detection code
      sjconnol  09/22/03 - Bug 3135258
      sjconnol  06/09/03 - add pref cred support
      qsong     04/29/03 - Add oemTop.jspf
      qsong     04/22/03 - fix 2906908, add help link
      glavash   02/21/03 - remove comments
      glavash   02/20/03 - test
      rkarunak  01/31/03 - change location of svgversion.jsp
--%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<head>
  <oem:switcher childNameProp="targetType">
    <oem:case name="osm_instance">
      <oem:title msgBundleKey="osmMsgBundle" textNLS="OSM_LOGIN"/>
    </oem:case>
    <oem:case name="oracle_database">
      <oem:title msgBundleKey="DBObjectBundle" textNLS="DATABASE_LOGIN"/>
    </oem:case>
    <oem:case name="rac_database">
      <oem:title msgBundleKey="DBObjectBundle" textNLS="DATABASE_LOGIN"/>
    </oem:case>
  </oem:switcher>
  <oem:styleSheet/>
  <script>
      var isNav = (navigator.appName.indexOf("Netscape") != -1);
      if(isNav)
      {
         document.captureEvents(Event.KEYPRESS);
      }
      document.onkeypress = getKey;
      function getKey(keyStroke)
      {
         key = (isNav) ? keyStroke.which : event.keyCode;
         if(key == "13")
         {
           submitForm('loginForm', true, {'event':'apply'});
         }
      }
      function doOnLoad()
      {
          document.forms[0].setAttribute('autocomplete','OFF');
          document.loginForm.userName.focus();
          document.loginForm.userName.select();
      }
  </script>
</head>

<oem:body onLoad="doOnLoad();">
  <oem:contents>
    <oem:form name="loginForm" method="POST"
              destinationProp="defaultControllerURL">
      <oem:formValue name="pageName" value="/database/login"/>
      <oem:formValue name="target" valueKey="target"/>
      <oem:formValue name="type" valueKey="type"/>
      <%
        if(request.getAttribute("oracle.sysman.db.adm.DBController.loginReferer") != null) {
      %>
      <oem:formValue name="oracle.sysman.db.adm.DBController.loginReferer" valueKey="oracle.sysman.db.adm.DBController.loginReferer"/>
      <% } %>
      <oem:contents>
        <oem:pageLayout>

          <%-- help link --%>
          <oem:globalButtons>
            <oem:globalButtonBar>
              <oem:contents>
                <oem:link text="Help" destinationProp="helpDestination"/>
              </oem:contents>
            </oem:globalButtonBar>
          </oem:globalButtons>

          <%@ include file="/oemPageGlobal.jspf"%>

          <oem:contents>
            <oem:messagePrompt prompt=""/>
            <oem:spacer height="10"/>
            <oem:messageBox messageType="info"
                             errorTableKey="info"
                             titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:messageBox messageType="error" errorTableKey="errors"
                             msgBundleKey="defaultMsgBundle"
                             titleTextKey="titleText" mainTextKey="mainText"/>
            <oem:switcher childNameProp="targetType">
              <oem:case name="oracle_database">
                <oem:header msgBundleKey="DBObjectBundle" textNLS="DATABASE_LOGIN"/>
              </oem:case>
              <oem:case name="osm_instance">
                <oem:header msgBundleKey="osmMsgBundle" textNLS="OSM_LOGIN"/>
              </oem:case>
              <oem:case name="rac_database">
                <oem:header msgBundleKey="DBObjectBundle" textNLS="DATABASE_LOGIN"/>
              </oem:case>
            </oem:switcher>
            <oem:spacer height="10"/>

            <oem:rowLayout hAlign="center">
              <oem:contents>

                <oem:stackLayout>
                  <oem:contents>


                    <oem:tableLayout cellSpacing="5">
                      <oem:contents>

                        <oem:rowLayout>
                          <oem:contents>
                            <oem:cellFormat hAlign="right">
                              <oem:contents>
                                <oem:messagePrompt labeledNodeId="user_name"
                                                errorTableKey="errors" errorKey="userName"
                                                    required="yes" textNLS="userName"/>
                              </oem:contents>
                            </oem:cellFormat>
                            <oem:stackLayout>
                              <oem:contents>
                                <oem:textInput name="userName" id ="user_name" textProp="userName"/>
                                <oem:messageText errorTableKey="errors" errorKey="userName"
                                                  messageType="error"/>
                              </oem:contents>
                            </oem:stackLayout>
                          </oem:contents>
                        </oem:rowLayout>

                        <oem:rowLayout>
                          <oem:contents>
                            <oem:cellFormat hAlign="right">
                              <oem:contents>
                                <oem:messagePrompt errorTableKey="errors" errorKey="password"
                                                   labeledNodeId="passWord"
                                                    required="yes" textNLS="password"/>
                              </oem:contents>
                            </oem:cellFormat>
                            <oem:stackLayout>
                              <oem:contents>
                                <oem:textInput name="password" id="passWord"
                                          secret="true" textProp="secretPassword"/>
                                <oem:messageText errorTableKey="errors" errorKey="password"
                                                  messageType="error"/>
                              </oem:contents>
                            </oem:stackLayout>
                          </oem:contents>
                        </oem:rowLayout>

                        <oem:switcher childNameProp="enterpriseMode">
                          <oem:case name="true">
                            <oem:rowLayout>
                              <oem:contents>
                                <oem:cellFormat hAlign="right">
                                  <oem:contents>
                                    <oem:switcher childNameProp="targetType">
                                      <oem:case name="oracle_database">
                                        <oem:messagePrompt textNLS="database"/>
                                      </oem:case>
                                      <oem:case name="rac_database">
                                        <oem:messagePrompt textNLS="database"/>
                                      </oem:case>
                                      <oem:case name="osm_instance">
                                        <oem:messagePrompt msgBundleKey="credsMsgBundle" 
                                                           textNLS="GEN_TARGET"/>
                                      </oem:case>
                                    </oem:switcher>
                                  </oem:contents>
                                </oem:cellFormat>
                                <oem:stackLayout>
                                  <oem:contents>
                                    <oem:styledText textProp="targetName" styleClass="OraDataText"/>
                                  </oem:contents>
                                </oem:stackLayout>
                              </oem:contents>
                            </oem:rowLayout>
                          </oem:case>
                          <oem:case name="false">
                            <oem:switcher childNameProp="connectStringReadOnly">
                              <oem:case name="true">
                                <oem:rowLayout>
                                  <oem:contents>
                                    <oem:cellFormat hAlign="right">
                                      <oem:contents>
                                        <oem:messagePrompt errorTableKey="errors"
                                                            required="yes" textNLS="connectString"/>
                                      </oem:contents>
                                    </oem:cellFormat>
                                    <oem:stackLayout>
                                      <oem:contents>
                                        <oem:textInput name="connectString" id="connString"
                                                textProp="connectString" readOnly="true" />
                                        <oem:messageText errorTableKey="errors"
                                                          messageType="error"/>
                                      </oem:contents>
                                    </oem:stackLayout>
                                  </oem:contents>
                                </oem:rowLayout>
                              </oem:case>
                              <oem:case name="false">
                                <oem:rowLayout>
                                  <oem:contents>
                                    <oem:cellFormat hAlign="right">
                                      <oem:contents>
                                        <oem:messagePrompt errorTableKey="errors" errorKey="connectString"
                                                            labeledNodeId="connString2"
                                                            required="yes" textNLS="connectString"/>
                                      </oem:contents>
                                    </oem:cellFormat>
                                    <oem:stackLayout>
                                      <oem:contents>
                                        <oem:textInput name="connectString" id="connString2" textProp="connectString" />
                                        <oem:messageText errorTableKey="errors" errorKey="connectString"
                                                          messageType="error"/>
                                      </oem:contents>
                                    </oem:stackLayout>
                                  </oem:contents>
                                </oem:rowLayout>
                              </oem:case>
                            </oem:switcher>
                          </oem:case>
                        </oem:switcher>

                        <oem:rowLayout>
                          <oem:contents>
                            <oem:cellFormat hAlign="right">
                              <oem:contents>
                                <oem:messagePrompt  errorTableKey="errors"
                                                    labeledNodeId="Role"
                                                    required="yes" textNLS="role"/>
                              </oem:contents>
                            </oem:cellFormat>
                            <oem:stackLayout>
                              <oem:contents>
                                <oem:switcher childNameProp="targetType">
                                  <oem:case name="oracle_database">
                                    <oem:choice name="role"
                                        onChange="submitForm('loginForm', true, {'event':'roleSwitch'})">
                                      <oem:option selectedValueProp="role"  text="Normal" value="normal"/>
                                      <oem:option selectedValueProp="role"  text="SYSDBA" value="sysdba"/>
                                    </oem:choice>
                                  </oem:case>
                                  <oem:case name="rac_database">
                                    <oem:choice name="role"
                                        onChange="submitForm('loginForm', true, {'event':'roleSwitch'})">
                                      <oem:option selectedValueProp="role"  text="Normal" value="normal"/>
                                      <oem:option selectedValueProp="role"  text="SYSDBA" value="sysdba"/>
                                    </oem:choice>
                                  </oem:case>
                                  <oem:case name="osm_instance">
                                    <oem:choice name="role" id="Role"
                                        onChange="submitForm('loginForm', true, {'event':'roleSwitch'})">
                                      <oem:switcher childNameProp="asmTarget">
                                        <oem:case name="false">
                                          <oem:option selectedValueProp="role"  
                                                      text="SYSOPER" 
                                                      value="sysoper"/>
                                        </oem:case>
                                      </oem:switcher>

                                      <oem:option selectedValueProp="role"  text="SYSDBA" value="sysdba"/>
                                      <oem:switcher childNameProp="is11gTarget">
                                        <oem:case name="true">
                                          <oem:option selectedValueProp="role"  text="SYSASM" value="sysasm"/>
                                        </oem:case> 
                                      </oem:switcher> 
                                    </oem:choice>
                                  </oem:case>
                                </oem:switcher>
                                <oem:messageText errorTableKey="errors"
                                                    messageType="error"/>
                              </oem:contents>
                            </oem:stackLayout>
                          </oem:contents>
                        </oem:rowLayout>

                       <oem:switcher childNameProp="repMode">
                        <oem:case name="true">
                         <oem:rowLayout>
                          <oem:contents>
                           <oem:cellFormat hAlign="right">
                            <oem:contents>
                            </oem:contents>
                           </oem:cellFormat>
                           <oem:stackLayout>
                            <oem:contents>
                             <oem:checkBox name="savePrefCreds"
                                             styleClass="OraFieldText"
                                             msgBundleKey="defaultMsgBundle"
                                             textNLS="prefCheck"
                                             checkedProp="savePrefCreds"
                                             disabledProp="savePrefCredsDisabled"
                                             value="true"/>
                            </oem:contents>
                           </oem:stackLayout>
                          </oem:contents>
                         </oem:rowLayout>
                        </oem:case>
                       </oem:switcher>

                      </oem:contents>
                    </oem:tableLayout>
                  </oem:contents>
                </oem:stackLayout>

              </oem:contents>
            </oem:rowLayout>
          </oem:contents>
          <oem:contentFooter>
            <oem:pageButtonBar>
              <oem:contents>
                <oem:submitButton msgBundleKey="DBObjectBundle" textNLS="CANCEL" name="event" value="cancel"/>
                <oem:submitButton msgBundleKey="DBObjectBundle" textNLS="LOGIN" name="event" value="apply"/>
              </oem:contents>
            </oem:pageButtonBar>
          </oem:contentFooter>
        </oem:pageLayout>
      </oem:contents>
    </oem:form>
  </oem:contents>
</oem:body>
