<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- 
 * Copyright (c) 2008, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       defineGroupMask.jsp
 *
 *      NOTES
 *       Page for defining the mask for a set of columns being masked as a group
 *       (also known as compound masking).
 *       
 *
 * MODIFIED
 *    kmckeen    02/12/09 - Bug 7477370 - package is a JavaScript reserved word
 *    kmckeen    02/03/09 - Include oemNoscript to eliminate OAC Cat1 violation
 *    kmckeen    11/26/08 - Implement initial input focus
 *    vgoli      10/21/08 - fix OAC violations
 *    kmckeen    10/20/08 - Enable delete
 *    kmckeen    10/16/08 - Add preserve original data checkbox
 *    kmckeen    10/02/08 - Support add column to group
 *    kmckeen    09/15/08 - Use ListDMTable LOV to include views
 *    kmckeen    08/21/08 - Handle sorting, message handling
 *    kmckeen    08/18/08 - Initial creation of module
--%>

<!-- tag library namespaces -->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<db:script src="/database/LOV.js"/>

<script language="JavaScript">

//~
// For debugging: put the textInput field under the pageStatus section below.
// Then uncomment one of the document.forms lines.
//
// <uix:textInput id="tstfld"/>
//
// document.forms[0].tstfld.value = packageField;
// document.forms[0].tstfld.value = row;
// document.forms[0].tstfld.value = schemaDotPackage.value;
// document.forms[0].tstfld.value = functionField;
//~

function launchFunctionLOV(packageField, row)
{
  document.forms[0].fvSchema.value = "";
  document.forms[0].fvPackage.value = "";

  var schemaDotPackage = eval(document.forms[0][packageField]);
  schemaDotPackage.value = trim(schemaDotPackage.value);

  var functionField = "maskGroupColumnsTbl:maskColumnFunction:"+row;

  if (schemaDotPackage.value == "")
  {
    startLov(functionField,'ListStandaloneFunction');
  }
  else
  {
    if ((schemaDotPackage.value.indexOf('"')) == 0)
    {
      var endSchema = schemaDotPackage.value.indexOf('".',1);
      if (endSchema != -1)
      {
        document.forms[0].fvSchema.value = schemaDotPackage.value.substring(1,endSchema);
        document.forms[0].fvPackage.value = trim(schemaDotPackage.value.substring(endSchema+2));
      }
    }
    else
    {
      var endSchema = schemaDotPackage.value.indexOf(".");
      if (endSchema != -1)
      {
        document.forms[0].fvSchema.value = schemaDotPackage.value.substring(0,endSchema);
        document.forms[0].fvPackage.value = trim(schemaDotPackage.value.substring(endSchema+1));
      }
    }

    if ((document.forms[0].fvPackage.value.indexOf('"')) == 0)
    {
      var endPackage = document.forms[0].fvPackage.value.indexOf('"',1);
      if (endPackage != -1)
      {
        document.forms[0].fvPackage.value = document.forms[0].fvPackage.value.substring(1, endPackage);
      }
      else
      {
        document.forms[0].fvPackage.value = "";
      }
    }

    setSearchFilter("fvSchema");
    setSearchFilter("fvPackage");

    // Note: there is a bug with disabling the filters, bug 7316613.
    setDisabledFilter('0');
    setDisabledFilter('1');

    startLov(functionField,'ListPackageFunction');
  }
}

function trim(sString)
{
  var lre = /^\s*/;
  var rre = /\s*$/;
  sString = sString.replace(lre, "");
  sString = sString.replace(rre, "");
  return sString;
}

</script>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

  <uix:bundle 
      name="dbUIMsg"
      class="oracle.sysman.db.rsc.DBObjectMsg"/>

  <uix:bundle 
      name="dmUIMsg" 
      class="oracle.sysman.db.rsc.dm.DataMaskingMsg"/>

  <uix:document>

    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              

    <uix:metaContainer>
      <uix:head 
          titleBinding="browserTitle@maskingBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body onLoad="document.forms[0].maskGroupFormat.focus()">

      <db:form 
          name="defineGroupMask"
          method="POST"
          destinationBinding="maskingDestination@maskingBean@servletRequest"
          copyParams="target,type">

        <uix:formValue 
            name="pageName" 
            value="/database/masking/defineGroupMask"/>

        <uix:formValue name="fvSchema"/>
        <uix:formValue name="fvPackage"/>

        <uix:pageLayout 
            titleBinding="titleString@maskingBean@servletRequest">

          <%@ include file="/oemGlobal.jspf" %>
          <%@ include file="/database/masking/dmMsging.jspf" %>   

          <uix:pageStatus>
            <uix:labeledFieldLayout columns="2">
              <uix:contents>
                <uix:messageStyledText
                    promptBinding="DATABASE@dmUIMsg"
                    styleClass="OraDataText"
                    textBinding="target@maskingBean@servletRequest"/>
                <uix:messageStyledText
                    promptBinding="LOGGED_IN_AS_LABEL@dbUIMsg"
                    styleClass="OraDataText"
                    textBinding="tgtUser@maskingBean@servletRequest"/>
                <uix:messageStyledText
                    promptBinding="OWNER@dmUIMsg"
                    styleClass="OraDataText"
                    textBinding="currParentOwner@maskingBean@servletRequest"/>
                <uix:messageStyledText
                    promptBinding="TABLE@dmUIMsg"
                    styleClass="OraDataText"
                    textBinding="currParentTable@maskingBean@servletRequest"/>
              </uix:contents>
            </uix:labeledFieldLayout>
          </uix:pageStatus>

          <uix:separator/>

<%-- for debugging
<uix:messageStyledText
    prompt="dest" styleClass="OraDataText"
    textBinding="maskingDestination@maskingBean@servletRequest"/>
--%>

          <uix:stackLayout>
          <uix:tableLayout width="100%">
          <uix:rowLayout>

          <uix:cellFormat hAlign="left" vAlign="bottom">

          <uix:labeledFieldLayout labelWidth="15%">
            <uix:contents>

              <uix:messageChoice 
                  id="maskGroupFormat" 
                  name="maskGroupFormat" 
                  shortDescBinding="RULE_TYPE@dmUIMsg"
                  promptBinding="RULE_TYPE@dmUIMsg"                            
                  selectedValueBinding="maskGroupFormat@maskingBean@servletRequest"
                  onChange="submitForm('defineGroupMask', true, {event:'changeGroupMaskFormat'})">
                <uix:contents 
                    childDataBinding="maskGroupFormats@maskingBean@servletRequest">
                  <uix:option 
                      textBinding="text" 
                      valueBinding="value"/>
                </uix:contents>
              </uix:messageChoice>

              <uix:styledText
                  renderedBinding="renderMaskTableLOV@maskingBean@servletRequest"
                  textBinding="MASKING_TABLE@dmUIMsg"/>
              <uix:rowLayout
                  renderedBinding="renderMaskTableLOV@maskingBean@servletRequest">
                <uix:lovField
                    id="maskGroupTable"
                    name="maskGroupTable"
                    columns="60"
                    shortDescBinding="MASKING_TABLE@dmUIMsg"
                    textBinding="maskGroupTable@maskingBean@servletRequest"
                    searchDescBinding="CLICK_TO_SELECT_TABLE@dmUIMsg"
                    onClick="startLov('maskGroupTable','ListDMTable')"/>
                <uix:cellFormat vAlign="middle">
                  <uix:submitButton
                      value="useSpecifiedTable"
                      name="event"
                      textBinding="GO@dbUIMsg"
                      shortDescBinding="GO@dbUIMsg"/>
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:messageStyledText 
                  renderedBinding="renderMaskTableLOV@maskingBean@servletRequest"
                  prompt=""
                  textBinding="SELECT_TABLE_EXAMPLE@dmUIMsg"
                  styleClass="OraInlineInfoText"/>

            </uix:contents>
          </uix:labeledFieldLayout>

          </uix:cellFormat>

          <uix:cellFormat 
              renderedBinding="renderAddColumnControls@maskingBean@servletRequest"
              hAlign="right"
              vAlign="bottom"
              wrappingDisabled="true">
            <uix:pageButtonBar>
              <uix:choice 
                  id="maskGroupAddColumn" 
                  name="maskGroupAddColumn" 
                  selectedValueBinding="maskGroupAddColumn@maskingBean@servletRequest">
                <uix:contents 
                    childDataBinding="maskGroupAddColumns@maskingBean@servletRequest">
                  <uix:option 
                      textBinding="text" 
                      valueBinding="value"/>
                </uix:contents>
              </uix:choice>
              <uix:cellFormat vAlign="middle">
                <uix:submitButton
                    textBinding="ADD_COLUMN_TO_GROUP@dmUIMsg"
                    shortDescBinding="ADD_COLUMN_TO_GROUP@dmUIMsg"
                    name="event"
                    value="addColumnToGroup"/>
              </uix:cellFormat>
            </uix:pageButtonBar>
          </uix:cellFormat>

          </uix:rowLayout>
          </uix:tableLayout>
          </uix:stackLayout>

          <uix:table 
              id="maskGroupColumnsTbl"
              name="maskGroupColumnsTbl"
              width="100%"
              formSubmitted="true"
              partialRenderMode="self"
              summaryBinding="DEFINE_GROUP_MASK@dmUIMsg"
              alternateTextBinding="NO_COLUMNS_ADDED@dmUIMsg"
              tableDataBinding="maskGroupColumns@maskingBean@servletRequest"
              columnHeaderDataBinding="maskGroupColumnsHeaders@maskingBean@servletRequest" 
              columnFormatsBinding="maskGroupColumnsFormats@maskingBean@servletRequest">

              <%-- 
                The following attributes can be used to have row subsets with 
                navigation controls on the <uix:table> above. This is not supported 
                at this time. There are not likely to be so many columns in a group 
                for this to be needed.
              --%>
              <%-- 
              blockSize="25"
              maxValueBinding="maskGroupColumnsMaxValue@maskingBean@servletRequest"
              valueBinding="maskGroupColumnsValue@maskingBean@servletRequest"
              --%>

            <uix:contents>

              <uix:column>
                <uix:columnHeader>
                  <uix:sortableHeader textBinding="COLUMN@dmUIMsg" sortableBinding="sort"/>
                </uix:columnHeader>
                <uix:columnFormat columnDataFormat="textFormat"/>
                <uix:styledText textBinding="COLUMN_NAME"/>
              </uix:column>

              <uix:column>
                <uix:columnHeader>
                  <uix:sortableHeader textBinding="DATA_TYPE@dmUIMsg" sortableBinding="sort"/>
                </uix:columnHeader>
                <uix:columnFormat columnDataFormat="textFormat"/>
                <uix:styledText textBinding="DATA_TYPE"/>    
              </uix:column>

              <uix:column renderedBinding="renderMaskTableLOV@maskingBean@servletRequest">
                <uix:columnHeader>
                  <uix:sortableHeader textBinding="MASKING_COLUMN@dmUIMsg" sortableBinding="sort"/>
                </uix:columnHeader>
                <uix:columnFormat columnDataFormat="textFormat"/>
                <uix:styledText 
                    renderedBinding="maskTableNeeded@maskingBean@servletRequest"
                    textBinding="SELECT_MASKING_TABLE@dmUIMsg"/>
                <uix:messageChoice 
                    renderedBinding="maskTableSpecified@maskingBean@servletRequest"
                    name="maskTableColumn" 
                    selectedValueBinding="MASKING_COLUMN" 
                    shortDescBinding="MASKING_COLUMN@dmUIMsg" 
                    messageTypeBinding="maskingColumnMessageType"
                    messageBinding="maskingColumnMessageText">
                  <uix:contents childDataBinding="maskTableColumns@maskingBean@servletRequest">
                    <uix:option textBinding="text" valueBinding="value"/>
                  </uix:contents>
                </uix:messageChoice>
              </uix:column>

              <uix:columnGroup renderedBinding="renderUserDefinedFunctionLOV@maskingBean@servletRequest">
                <uix:columnHeader>
                  <uix:styledText textBinding="USER_DEFINED_FUNCTION@dmUIMsg"/>
                </uix:columnHeader>
                <uix:contents>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="PACKAGE@dmUIMsg" sortableBinding="sort"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:lovField
                        name="maskColumnPackage"
                        textBinding="PACKAGE"
                        columns="40"
                        shortDescBinding="PACKAGE@dmUIMsg"
                        searchDescBinding="CLICK_TO_SELECT_PACKAGE@dmUIMsg"
                        onClickBinding="onClickPackageLOV"/>
                  </uix:column>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:sortableHeader textBinding="FUNCTION@dmUIMsg" sortableBinding="sort"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                    <uix:messageLovField
                        name="maskColumnFunction"
                        textBinding="FUNCTION"
                        columns="40"
                        shortDescBinding="FUNCTION@dmUIMsg"
                        searchDescBinding="CLICK_TO_SELECT_FUNCTION@dmUIMsg"
                        onClickBinding="onClickFunctionLOV"
                        messageTypeBinding="maskingFunctionMessageType"
                        messageBinding="maskingFunctionMessageText"/>
                  </uix:column>
                </uix:contents>
              </uix:columnGroup>

              <uix:column>
                <uix:columnHeader>
                  <uix:styledText textBinding="PRESERVE_ORIG_DATA@dmUIMsg"/>
                </uix:columnHeader>
                <uix:columnFormat columnDataFormat="iconButtonFormat" width="12%"/>
                <%--
                Checkbox parameters:
                  value - Text that when matches selectedValue text displays checkbox as checked.
                          This text is also sent on form post to indicate checkbox is checked.
                  selectedValue - Text string, one of:
                          selected - checkbox will be checked
                          notselected - checkbox will not be checked
                --%>
                <uix:checkBox
                    name="preserveOriginalData"
                    value="selected"
                    selectedValueBinding="PRESERVE_ORIG_DATA"
                    shortDescBinding="PRESERVE_ORIG_DATA@dmUIMsg"/>
              </uix:column>

              <uix:column>
                <uix:columnHeader>
                  <uix:styledText textBinding="REMOVE@dmUIMsg"/>
                </uix:columnHeader>
                <uix:columnFormat columnDataFormat="iconButtonFormat" width="8%"/>
                <uix:dataScope>
                  <uix:image 
                      shortDescBinding="REMOVE@dmUIMsg"
                      sourceBinding="removeIconSource@maskingBean@servletRequest"
                      onClickBinding="REMOVE"/>
                </uix:dataScope>
              </uix:column>

            </uix:contents>
          </uix:table>

          <uix:rowLayout>
          <uix:spacer height="5"/>
          </uix:rowLayout>
          <uix:rowLayout>
          <uix:styledText
              styleClass="OraInlineInfoText"
              textBinding="DEFINE_GROUP_MASK_TIP1@dmUIMsg"/>
          </uix:rowLayout>
          <uix:rowLayout>
          <uix:spacer height="5"/>
          </uix:rowLayout>
          <uix:rowLayout>
          <uix:styledText
              styleClass="OraInlineInfoText"
              textBinding="DEFINE_GROUP_MASK_TIP2@dmUIMsg"/>
          </uix:rowLayout>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton
                  value="defineGroupMaskCancel"
                  name="event"
                  textBinding="CANCEL@dbUIMsg"
                  shortDescBinding="CANCEL@dbUIMsg"/>
              <uix:submitButton
                  value="defineGroupMaskOK"
                  name="event"
                  textBinding="OK@dbUIMsg"
                  shortDescBinding="OK@dbUIMsg"/>
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
