<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- 
 * Copyright (c) 2004, 2009, Oracle and/or its affiliates.All rights reserved. 
 *
 *      NAME
 *       definitions.jsp
 *
 *      NOTES
 *       Common jsp for masking definitions list UI.
 *       The bean key supporting this view is 'maskingDefinitionsBean'
 *       
 *
 * MODIFIED
 *    kmckeen    02/03/09 - Include oemNoscript to eliminate OAC Cat1 violation
 *    kmckeen    10/21/08 - Add Clone Database
 *    kmckeen    07/04/08 - Implement new workflow
 *    xshen      06/25/07 - enable xml
 *    xshen      06/18/07 - import export gui
 *    xshen      05/18/07 - fix wiz page name
 *    xshen      12/06/06 - ui changes
 *    xshen      11/09/06 - ui changes
 *    xshen      08/30/06 - support masking using
 *    xshen      08/07/06 - Created
 *
--%>

<!-- taglib namespaces-->
<%@ taglib uri="http://xmlns.oracle.com/uix/ui"         prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag"    prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"  %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

<!-- message bundles -->
<uix:bundle name="dbUIMsg"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="dmUIMsg"
            class="oracle.sysman.db.rsc.dm.DataMaskingMsg"/>
<uix:bundle name="mntrResourceBundle"
            class="oracle.sysman.resources.MntrResourceBundle"/>

  <!-- page contents -->
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf"  %>              

    <uix:metaContainer>
      <uix:head titleBinding="browserTitle@maskingDefinitionsBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="definitionsForm"
               method="POST"
               destinationBinding="definitionsDestination@maskingDefinitionsBean@servletRequest"
               copyParams="target,type">
      <uix:formValue name="pageName" value="/database/masking/definitions"/>
      <uix:formValue name="event" value="searchDefinitions"/>

        <uix:pageLayout 
             titleBinding="titleString@maskingDefinitionsBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>

        <!-- Messaging Area -->
        <%@ include file="/database/masking/dmMsging.jspf" %>   

          <uix:contents>  

            <!-- Instruction Text -->
            <uix:rowLayout width="100%">
                 <uix:cellFormat wrappingDisabled="true" vAlign="top">
                  <uix:contents>
                    <uix:tableLayout>
                     <uix:rowLayout>
                     <uix:messagePrompt promptBinding="DATA_MASKING_INSTRUCTION@dmUIMsg"/>
                     </uix:rowLayout>
                    </uix:tableLayout>
                  </uix:contents>
                 </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:spacer height="4"/>
            </uix:rowLayout>

<uix:separator/>

            <uix:rowLayout>
              <uix:spacer height="4"/>
            </uix:rowLayout>

            <uix:tableLayout width="100%">
              <uix:rowLayout width="100%">
                <uix:contents>
                  <uix:cellFormat wrappingDisabled="true" vAlign="top">
                   <uix:contents>
                    <uix:tableLayout>
                     <uix:rowLayout>
                    <uix:messageChoice 
                            shortDescBinding="SEARCH@dbUIMsg"
                            name="searchType" 
                            promptBinding="SEARCH@dbUIMsg"
                            selectedValueBinding="searchType@maskingDefinitionsBean@servletRequest">
                         <uix:contents childDataBinding="searchTypes@maskingDefinitionsBean@servletRequest">
                         <uix:option textBinding="text"
                                     valueBinding="value"/>
                         </uix:contents>
                       </uix:messageChoice>                         
                       <uix:spacer width="6"/>
                       <uix:messageTextInput 
                            name="searchValue"
                            textBinding="searchValue@maskingDefinitionsBean@servletRequest"
                            shortDescBinding="ENTER_OBJECT_NAME@dbUIMsg"/>
                       <uix:spacer width="6"/>
                       <uix:submitButton name="event" 
                                         value="searchDefinitions"
                                         shortDescBinding="GO@dbUIMsg"
                                         textBinding="GO@dbUIMsg"/>
                    </uix:rowLayout>
                   </uix:tableLayout>
                  </uix:contents>
                 </uix:cellFormat>

                 <uix:cellFormat wrappingDisabled="true" vAlign="top" hAlign="right">
                  <uix:contents>
                    <!-- Import Button -->
                    <uix:submitButton 
                         textBinding="IMPORT@dmUIMsg" 
                         shortDescBinding="IMPORT@dmUIMsg" 
                         name="event" 
                         value="launchImport"/>  
                    <uix:spacer width="2"/>
                    <!-- Create Button -->
                    <db:button 
                        textBinding="CREATE@dbUIMsg" 
                        shortDescBinding="CREATE@dbUIMsg" 
                        destinationBinding="maskDestination@maskingDefinitionsBean@servletRequest"/>  
                  </uix:contents>
                 </uix:cellFormat>

                </uix:contents>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:rowLayout>
              <uix:spacer height="4"/>
            </uix:rowLayout>
              
                <!-- Results Table -->
                <!-- Notes: do not copy target, type since this messup 
                  --   the target home page URL (each row might be for 
                  --   different target where as hidden param is global)
                  --   The same reason for specType when it comes to 
                  --   comparisons - a baseline link should not copy type
                  -->
            <uix:stackLayout>                
              <uix:contents>
                <uix:rowLayout>
                  <uix:spacer height="6"/>
                </uix:rowLayout>
                <oem:table name="definitionsTable"
                           id="definitionsTable"
                           summaryBinding="MASKING_DEFINITIONS@dmUIMsg"
                           copyParams=""
                           destinationBinding="definitionsDestination@maskingDefinitionsBean@servletRequest"
                           width="100%"
                           blockSize="10"
                           beanKey="maskingDefinitionsBean"
                           formSubmitted="true"
                           dataSourceProp="definitionsTable"
                           alternateTextBinding="NO_DEFINITIONS@dmUIMsg">
                  <uix:tableSelection>
                    <uix:singleSelection 
                           shortDescBinding="SELECT@dbUIMsg"
                           selectedIndexBinding="selectedIndex@maskingDefinitionsBean@servletRequest">

                      <!-- View -->
                      <uix:submitButton
                           name="event"
                           value="viewDefinition"
                           shortDescBinding="VIEW@dbUIMsg"
                           textBinding="VIEW@dbUIMsg"/>

                      <uix:spacer width="2"/>

                      <!-- Edit -->
                      <uix:submitButton
                           name="event"
                           value="editDefinition"
                           shortDescBinding="EDIT@dbUIMsg"
                           textBinding="EDIT@dbUIMsg"/>

                      <uix:spacer width="2"/>

                      <!-- Create Like -->
                      <uix:submitButton
                           name="event"
                           value="createLikeDefinition"
                           shortDescBinding="CREATE_LIKE@dbUIMsg"
                           textBinding="CREATE_LIKE@dbUIMsg"/>

                      <uix:spacer width="2"/>

                      <!-- Generate Script -->
                      <uix:submitButton
                           name="event"
                           value="generateScript"
                           shortDescBinding="GENERATE_SCRIPT@dmUIMsg"
                           textBinding="GENERATE_SCRIPT@dmUIMsg"/>

                      <uix:spacer width="2"/>

                      <!-- Schedule Job -->
                      <uix:submitButton
                           name="event"
                           value="scheduleJob"
                           shortDescBinding="SCHEDULE_JOB@dmUIMsg"
                           textBinding="SCHEDULE_JOB@dmUIMsg"/>

                      <uix:spacer width="2"/>

                      <!-- Retry Job -->
                      <%--
                      <uix:submitButton
                           name="event"
                           value="retryJob"
                           shortDescBinding="RETRY_JOB@dmUIMsg"
                           textBinding="RETRY_JOB@dmUIMsg"/>

                      <uix:spacer width="2"/>
                      --%>

                      <!-- Export -->
                      <uix:submitButton
                           name="event"
                           value="launchExport"
                           shortDescBinding="EXPORT@dmUIMsg"
                           textBinding="EXPORT@dmUIMsg"/>

                      <uix:spacer width="2"/>
                      
                      <!-- Clone Database -->
                      <uix:submitButton
                           name="event"
                           value="cloneDatabase"
                           shortDescBinding="CLONE_DATABASE@dmUIMsg"
                           textBinding="CLONE_DATABASE@dmUIMsg"/>

                      <uix:spacer width="2"/>
                      
                      <!-- Delete -->
                      <uix:submitButton
                           name="event"
                           value="deleteDefinition"
                           shortDescBinding="DELETE@dbUIMsg"
                           textBinding="DELETE@dbUIMsg"/>

                      <uix:spacer width="2"/>

                    </uix:singleSelection>
                  </uix:tableSelection>                         
                </oem:table>
              </uix:contents>
            </uix:stackLayout>

             <!-- Related Links: rule templates library -->
             <uix:header textBinding="FORMAT_LIBRARY@dmUIMsg">
               <uix:rowLayout> 
                 <uix:messagePrompt promptBinding="FORMAT_LIBRARY_INFO@dmUIMsg"/>
               </uix:rowLayout>
               <uix:rowLayout>
                 <uix:spacer height="6"/>
               </uix:rowLayout>
               <uix:rowLayout> 
                 <db:link textBinding="FORMAT_LIBRARY@dmUIMsg" destinationBinding="formatLibraryURL@servletRequest"/>
               </uix:rowLayout>
             </uix:header>

          </uix:contents>    
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
